/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.dnd;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.ui.dnd.AbstractFileDropHandler;

public class JarDropHandler
extends AbstractFileDropHandler {
    @Override
    public void performDrop(IScriptEngine scriptEngine, Object element) {
        try {
            ICodeFactory codeFactory = ScriptService.getCodeFactory((IScriptEngine)scriptEngine);
            Method loadJarMethod = EnvironmentModule.class.getMethod("loadJar", Object.class);
            String call = codeFactory.createFunctionCall(loadJarMethod, new Object[]{this.getFileURI(element)});
            scriptEngine.executeAsync((Object)call);
        }
        catch (Exception e) {
            Logger.error((String)"org.eclipse.ease.ui", (String)"loadJar() method not found in Environment module", (Throwable)e);
        }
    }

    @Override
    protected Collection<String> getAcceptedFileExtensions() {
        return Arrays.asList("jar");
    }
}

