/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.jython.debugger;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;

public class BreakpointInfo {
    private String mFilename;
    private int mLinenumber = -1;
    private final String mCondition;
    private final int mHitcount = 0;
    private final boolean mTemporary = false;

    public BreakpointInfo(IBreakpoint breakpoint) {
        this.mCondition = null;
        this.mFilename = breakpoint.getMarker().getResource().getFullPath().toOSString();
        this.mFilename = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), this.mFilename).getAbsolutePath();
        if (breakpoint instanceof LineBreakpoint) {
            try {
                this.mLinenumber = ((LineBreakpoint)breakpoint).getLineNumber();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public String getFilename() {
        return this.mFilename;
    }

    public int getLinenumber() {
        return this.mLinenumber;
    }

    public String getCondition() {
        return this.mCondition;
    }

    public int getHitcount() {
        return 0;
    }

    public boolean getTemporary() {
        return false;
    }
}

