/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptDebugFrame;
import org.eclipse.ease.modules.unittest.components.TestComposite;
import org.eclipse.ease.modules.unittest.components.TestEntity;
import org.eclipse.ease.modules.unittest.components.TestResult;
import org.eclipse.ease.modules.unittest.components.TestStatus;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class Test
extends TestEntity {
    private final String fTitle;
    private String fDescription;
    private List<IScriptDebugFrame> fTestLocation = null;
    private final List<TestResult> fResults = new ArrayList<TestResult>();
    private final Map<String, String> fMetaData = new HashMap<String, String>();
    private boolean fTransient = false;

    public Test(TestComposite parent, String title, String description) {
        super(parent);
        this.fTitle = title;
        this.setDescription(description);
    }

    public Test(TestComposite parent, String title) {
        this(parent, title, null);
    }

    public Test(TestComposite parent, String title, boolean isTransient) {
        this(parent, title, null);
        this.fTransient = isTransient;
    }

    public String getTitle() {
        return this.fTitle;
    }

    @Override
    public TestStatus getStatus() {
        TestStatus status = super.getStatus();
        if (this.isTransient() && status == TestStatus.RUNNING) {
            status = TestStatus.PASS;
        }
        for (TestResult message : this.getMessages()) {
            status = status.merge(message.getStatus());
        }
        return status;
    }

    @Override
    public void reset() {
        super.reset();
        this.fResults.clear();
        this.fMetaData.clear();
    }

    public void setTestLocation(List<IScriptDebugFrame> stackTrace) {
        this.fTestLocation = new ArrayList<IScriptDebugFrame>();
        for (IScriptDebugFrame frame : stackTrace) {
            this.fTestLocation.add((IScriptDebugFrame)new ScriptDebugFrame(frame));
        }
    }

    public List<IScriptDebugFrame> getTestLocation() {
        return this.fTestLocation;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public void addMessage(TestResult message) {
        this.getMessages().add(message);
        Test.createMarker(message);
    }

    public List<TestResult> getMessages() {
        return this.fResults;
    }

    public TestResult getSeverestMessage() {
        TestResult result = null;
        for (TestResult message : this.getMessages()) {
            if (result != null && result.getStatus().compareTo(message.getStatus()) >= 0) continue;
            result = message;
        }
        return result;
    }

    public Collection<TestResult> getMessages(TestStatus status) {
        ArrayList<TestResult> result = new ArrayList<TestResult>();
        for (TestResult message : this.getMessages()) {
            if (!message.getStatus().equals((Object)status)) continue;
            result.add(message);
        }
        return result;
    }

    private static void createMarker(TestResult result) {
        List<IScriptDebugFrame> trace;
        if (result.getStatus().isEqualOrWorse(TestStatus.ERROR) && (trace = result.getStackTrace()) != null) {
            for (IScriptDebugFrame element : trace) {
                Object file = element.getScript().getFile();
                if (!(file instanceof IFile) || !((IFile)file).exists()) continue;
                try {
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("lineNumber", element.getLineNumber());
                    attributes.put("severity", 2);
                    attributes.put("message", result.getDescription());
                    MarkerUtilities.createMarker((IResource)((IFile)file), attributes, (String)"org.eclipse.ease.modules.unittest.scriptassertion");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isTransient() {
        return this.fTransient;
    }

    public void addMetaData(String identifier, String content) {
        this.fMetaData.put(identifier, content);
        this.fireTestEvent(this, this.getStatus());
    }

    public Map<String, String> getMetaData() {
        return Collections.unmodifiableMap(this.fMetaData);
    }
}

