/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.modules.ui;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;

public class ModulesDragListener
implements DragSourceListener {
    private final TreeViewer mTreeViewer;

    public ModulesDragListener(TreeViewer viewer) {
        this.mTreeViewer = viewer;
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = !(event.data instanceof IPath);
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        Object firstElement = selection.getFirstElement();
        if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            StringBuilder data = new StringBuilder();
            if (firstElement instanceof ModuleDefinition) {
                data.append("loadModule('").append(((ModuleDefinition)firstElement).getPath().toString()).append("');\n");
            } else if (firstElement instanceof Field) {
                data.append(((Field)firstElement).getName());
            } else if (firstElement instanceof Method) {
                data.append(ModulesTools.getSignature((Method)firstElement)).append(";\n");
            }
            event.data = data.toString();
        }
    }

    public void dragFinished(DragSourceEvent event) {
    }
}

