/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.charting.modules;

import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.charting.charts.Chart;
import org.eclipse.ease.modules.charting.views.ChartView;
import org.eclipse.ease.modules.platform.ResourcesModule;
import org.eclipse.ease.modules.platform.UIModule;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.ui.PartInitException;

public class ChartingModule
extends AbstractScriptModule {
    public static final String MODULE_NAME = "Charting";
    private Chart fChart = null;
    private static int fFigureIterator = 1;

    @WrapToScript
    public Chart figure(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String figureId) throws PartInitException {
        this.fChart = null;
        String secondaryId = figureId == null ? "Figure " + Integer.toString(fFigureIterator++) : figureId;
        ChartView view = (ChartView)UIModule.showView((String)"org.eclipse.ease.modules.charting.views.ChartView", (String)secondaryId, (int)1);
        view.setViewName(secondaryId);
        this.fChart = view.getChart();
        this.fChart.setPlotTitle(secondaryId);
        return this.fChart;
    }

    @WrapToScript
    public Trace series(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String seriesName, @ScriptParameter(defaultValue="") String format) throws PartInitException {
        return this.getChart().series(seriesName, format);
    }

    private Chart getChart() throws PartInitException {
        if (this.fChart == null) {
            this.figure(null);
        }
        return this.fChart;
    }

    @WrapToScript
    public Trace plotPoint(double x, double y) throws PartInitException {
        return this.getChart().plot(x, y);
    }

    @WrapToScript
    public Trace plot(double[] x, double[] y) throws PartInitException {
        return this.getChart().plot(x, y);
    }

    @WrapToScript(alias="title")
    public XYGraph setPlotTitle(String plotTitle) throws PartInitException {
        return this.getChart().setPlotTitle(plotTitle);
    }

    @WrapToScript(alias="xlabel")
    public Axis setXLabel(String xLabel) throws PartInitException {
        return this.getChart().setXLabel(xLabel);
    }

    @WrapToScript(alias="ylabel")
    public Axis setYLabel(String yLabel) throws PartInitException {
        return this.getChart().setYLabel(yLabel);
    }

    @WrapToScript(alias="axis")
    public void setAxisRange(double[] xrange, double[] yrange) throws Exception {
        this.getChart().setAxisRange(xrange, yrange);
    }

    @WrapToScript
    public void showGrid(boolean showGrid) throws PartInitException {
        this.getChart().showGrid(showGrid);
    }

    @WrapToScript
    public void setAutoScale(boolean performAutoScale) throws PartInitException {
        this.getChart().setAutoScale(performAutoScale);
    }

    @WrapToScript
    public void clear() throws PartInitException {
        this.getChart().clear();
    }

    @WrapToScript
    public void exportGraph(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String imageName, @ScriptParameter(defaultValue="false") boolean overwrite) throws Exception {
        Object file = null;
        if (imageName != null && !imageName.trim().isEmpty()) {
            file = ((ResourcesModule)this.getEnvironment().getModule(ResourcesModule.class)).getFile(imageName, false);
        }
        this.getChart().export(file, overwrite);
    }

    @WrapToScript
    public void removeSeries(String seriesName) throws PartInitException {
        this.getChart().removeSeries(seriesName);
    }
}

