/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.components;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ease.modules.unittest.ITestListener;
import org.eclipse.ease.modules.unittest.components.TestComposite;
import org.eclipse.ease.modules.unittest.components.TestStatus;

public class TestEntity {
    private TestStatus fStatus = TestStatus.NOT_RUN;
    private final ListenerList fTestListeners = new ListenerList();
    private long fStartTime = 0L;
    private long fEndTime = 0L;
    private final TestComposite fParent;

    public TestEntity(TestComposite parent) {
        this.fParent = parent;
    }

    public void setStatus(TestStatus status) {
        if (status != this.fStatus) {
            if (status == TestStatus.RUNNING) {
                this.fStartTime = System.currentTimeMillis();
                this.fEndTime = 0L;
            } else if (this.fStatus == TestStatus.RUNNING) {
                this.fEndTime = System.currentTimeMillis();
            }
            this.fStatus = status;
            this.fireTestEvent(this, this.getStatus());
        }
    }

    public TestStatus getStatus() {
        return this.fStatus;
    }

    public void reset() {
        this.fStartTime = 0L;
        this.fEndTime = 0L;
        this.setStatus(TestStatus.NOT_RUN);
    }

    public void addTestListener(ITestListener listener) {
        this.fTestListeners.add((Object)listener);
    }

    public void removeTestListener(ITestListener listener) {
        this.fTestListeners.remove((Object)listener);
    }

    protected void fireTestEvent(Object testObject, TestStatus status) {
        Object[] objectArray = this.fTestListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ITestListener)listener).notify(testObject, status);
            ++n2;
        }
    }

    public long getExecutionTime() {
        if (this.fEndTime != 0L) {
            return this.fEndTime - this.fStartTime;
        }
        if (this.fStartTime != 0L) {
            return System.currentTimeMillis() - this.fStartTime;
        }
        return 0L;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public TestComposite getParent() {
        return this.fParent;
    }
}

