/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.svn;

import java.util.ArrayList;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.management.AddRepositoryLocationOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class SVNModule {
    @WrapToScript
    public IRepositoryLocation createRepositoryLocation(String rootUrl, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String username, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String password) {
        IRepositoryLocation location;
        IRepositoryLocation[] locations;
        IRepositoryLocation[] iRepositoryLocationArray = locations = SVNRemoteStorage.instance().getRepositoryLocations();
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            location = iRepositoryLocationArray[n2];
            if (location.getUrlAsIs().equals(rootUrl) || location.getUrl().equals(rootUrl)) {
                return location;
            }
            ++n2;
        }
        location = SVNRemoteStorage.instance().newRepositoryLocation();
        location.setUrl(rootUrl);
        location.setTrunkLocation("trunk");
        location.setTagsLocation("tags");
        location.setBranchesLocation("branches");
        location.setStructureEnabled(true);
        if (username != null) {
            location.setUsername(username);
        }
        if (password != null) {
            location.setPassword(password);
        }
        location.setPasswordSaved(true);
        AddRepositoryLocationOperation operation = new AddRepositoryLocationOperation(location);
        final CompositeOperation op = new CompositeOperation(operation.getId(), operation.getMessagesClass());
        op.add((IActionOperation)operation);
        op.add((IActionOperation)new SaveRepositoryLocationsOperation());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                UIMonitorUtility.doTaskNowDefault((IActionOperation)op, (boolean)false);
            }
        });
        return location;
    }

    @WrapToScript
    public void importProjectFromSVN(Object rootLocation, String[] projectLocations) throws Exception {
        if (!(rootLocation instanceof IRepositoryResource)) {
            rootLocation = this.createRepositoryLocation(rootLocation.toString(), null, null);
        }
        ArrayList<IRepositoryResource> doCeckout_tmp = new ArrayList<IRepositoryResource>();
        String[] stringArray = projectLocations;
        int n = projectLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            IRepositoryResource projectResource = SVNRemoteStorage.instance().asRepositoryResource((IRepositoryLocation)rootLocation, String.valueOf(((IRepositoryLocation)rootLocation).getUrl()) + "/" + location, false);
            doCeckout_tmp.add(projectResource);
            ++n2;
        }
        final IRepositoryResource[] doCeckout = doCeckout_tmp.toArray(new IRepositoryResource[0]);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell sh = Display.getDefault().getActiveShell();
                IActionOperation op = ExtensionsManager.getInstance().getCurrentCheckoutFactory().getCheckoutOperation(sh, doCeckout, null, true, null, 3, false);
                UIMonitorUtility.doTaskNowDefault((IActionOperation)op, (boolean)true);
            }
        });
    }
}

