/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ease.ui.scripts.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.impl.InputStreamParser;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class HttpParser
extends InputStreamParser {
    public void parse(IScriptLocation location) {
        InputStream stream = location.getInputStream();
        if (stream != null) {
            try {
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new InputStreamReader(stream));
                ArrayList<IMemento> anchorNodes = new ArrayList<IMemento>();
                this.extractAnchors((IMemento)memento, anchorNodes);
                Map<URI, String> links = this.convertAnchors(anchorNodes);
                links = this.filterExternals(URI.create(location.getLocation()), links);
                System.out.println(links);
            }
            catch (WorkbenchException e1) {
                throw new RuntimeException(e1);
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Map<URI, String> filterExternals(URI base, Map<URI, String> links) {
        HashMap<URI, String> filtered = new HashMap<URI, String>();
        for (Map.Entry<URI, String> entry : links.entrySet()) {
            URI link = entry.getKey();
            if (!link.isAbsolute()) {
                link = base.resolve(link);
            }
            if (!link.toString().startsWith(base.toString())) continue;
            filtered.put(link, entry.getValue());
        }
        return filtered;
    }

    private Map<URI, String> convertAnchors(List<IMemento> anchorNodes) {
        HashMap<URI, String> links = new HashMap<URI, String>();
        for (IMemento node : anchorNodes) {
            links.put(URI.create(node.getString("href")), this.extractText(node));
        }
        return links;
    }

    private String extractText(IMemento node) {
        StringBuilder text = new StringBuilder();
        text.append(node.getTextData());
        IMemento[] iMementoArray = node.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            text.append(this.extractText(child));
            ++n2;
        }
        return text.toString();
    }

    private void extractAnchors(IMemento memento, List<IMemento> anchorNodes) {
        IMemento[] iMementoArray = memento.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            if (child.getType().equals("a")) {
                anchorNodes.add(child);
            } else {
                this.extractAnchors(child, anchorNodes);
            }
            ++n2;
        }
    }
}

