/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.IModuleWrapper;
import org.eclipse.ease.modules.IScriptFunctionModifier;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;

public abstract class AbstractModuleWrapper
implements IModuleWrapper {
    protected String getParameterName(Annotation[] parameterAnnotations) {
        Annotation[] annotationArray = parameterAnnotations;
        int n = parameterAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annot = annotationArray[n2];
            if (annot instanceof ScriptParameter) {
                ScriptParameter namedParameter = (ScriptParameter)annot;
                return namedParameter.name();
            }
            ++n2;
        }
        return null;
    }

    public static List<Parameter> parseParameters(Method method) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        int index = 0;
        while (index < method.getParameterTypes().length) {
            Parameter parameter = new Parameter();
            parameter.setClass(method.getParameterTypes()[index]);
            ScriptParameter annotation = AbstractModuleWrapper.getParameterAnnotation(method.getParameterAnnotations()[index]);
            if (annotation != null) {
                parameter.setName(annotation.name());
                parameter.setOptional(ScriptParameter.Helper.isOptional(annotation));
                parameter.setDefault(annotation.defaultValue());
            }
            parameters.add(parameter);
            ++index;
        }
        for (Parameter parameter : parameters) {
            if (!parameter.getName().isEmpty()) continue;
            parameter.setName(AbstractModuleWrapper.findName(parameters));
        }
        return parameters;
    }

    private static ScriptParameter getParameterAnnotation(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof ScriptParameter) {
                return (ScriptParameter)annotation;
            }
            ++n2;
        }
        return null;
    }

    private static String findName(List<Parameter> parameters) {
        String name;
        boolean found;
        int index = 1;
        block0: do {
            found = true;
            name = "param" + index;
            for (Parameter parameter : parameters) {
                if (!name.equals(parameter.getName())) continue;
                ++index;
                found = false;
                continue block0;
            }
        } while (!found);
        return name;
    }

    protected String getDefaultValue(Parameter parameter) {
        String defaultStringValue = parameter.getDefaultValue().replaceAll("\\r", "\\\\r").replaceAll("\\n", "\\\\n");
        Class<String> clazz = parameter.getClazz();
        if ("org.eclipse.ease.modules.ScriptParameter.null".equals(defaultStringValue)) {
            return this.getNullString();
        }
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            try {
                return Integer.toString(Integer.parseInt(defaultStringValue));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            try {
                return Long.toString(Long.parseLong(defaultStringValue));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            try {
                return Float.toString(Float.parseFloat(defaultStringValue));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            try {
                return Double.toString(Double.parseDouble(defaultStringValue));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return Boolean.parseBoolean(defaultStringValue) ? this.getTrueString() : this.getFalseString();
        }
        if ("org.eclipse.ease.modules.ScriptParameter.undefined".equals(defaultStringValue)) {
            try {
                clazz.getConstructor(new Class[0]);
                return this.classInstantiation(clazz, null);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        try {
            clazz.getConstructor(String.class);
            return this.classInstantiation(clazz, new String[]{"\"" + defaultStringValue + "\""});
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (clazz.isAssignableFrom(String.class)) {
            return this.classInstantiation(String.class, new String[]{"\"" + defaultStringValue + "\""});
        }
        return this.getNullString();
    }

    public static Collection<String> getMethodNames(Method method) {
        HashSet<String> methodNames = new HashSet<String>();
        methodNames.add(method.getName());
        WrapToScript wrapAnnotation = method.getAnnotation(WrapToScript.class);
        if (wrapAnnotation != null) {
            String[] stringArray = wrapAnnotation.alias().split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (!name.trim().isEmpty()) {
                    methodNames.add(name.trim());
                }
                ++n2;
            }
        }
        return methodNames;
    }

    public static String getPreExecutionCode(IEnvironment environment, Method method) {
        StringBuffer code = new StringBuffer();
        for (Object module : environment.getModules()) {
            if (!(module instanceof IScriptFunctionModifier)) continue;
            code.append(((IScriptFunctionModifier)module).getPreExecutionCode(method));
        }
        return code.toString();
    }

    public static String getPostExecutionCode(IEnvironment environment, Method method) {
        StringBuffer code = new StringBuffer();
        for (Object module : environment.getModules()) {
            if (!(module instanceof IScriptFunctionModifier)) continue;
            code.append(((IScriptFunctionModifier)module).getPostExecutionCode(method));
        }
        return code.toString();
    }

    protected abstract String getNullString();

    protected String getTrueString() {
        return Boolean.TRUE.toString();
    }

    protected String getFalseString() {
        return Boolean.FALSE.toString();
    }

    public static class Parameter {
        private Class<?> fClazz;
        private String fName = "";
        private boolean fOptional = false;
        private String fDefaultValue = "org.eclipse.ease.modules.ScriptParameter.null";

        public void setClass(Class<?> clazz) {
            this.fClazz = clazz;
        }

        public void setName(String name) {
            this.fName = name;
        }

        public void setOptional(boolean optional) {
            this.fOptional = optional;
        }

        public void setDefault(String defaultValue) {
            this.fDefaultValue = defaultValue;
        }

        public String getName() {
            return this.fName;
        }

        public Class<?> getClazz() {
            return this.fClazz;
        }

        public String getDefaultValue() {
            return this.fDefaultValue;
        }

        public boolean isOptional() {
            return this.fOptional;
        }
    }
}

