/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.modules.ui;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.ease.ui.tools.AbstractVirtualTreeProvider;

public class ModulesContentProvider
extends AbstractVirtualTreeProvider {
    private final boolean mModulesOnly;

    public ModulesContentProvider(boolean modulesOnly) {
        this.mModulesOnly = modulesOnly;
    }

    @Override
    public Object getParent(Object element) {
        if (element instanceof IPath) {
            return ((IPath)element).removeLastSegments(1);
        }
        if (element instanceof ModuleDefinition) {
            return ((ModuleDefinition)element).getPath().removeLastSegments(1);
        }
        if (element instanceof Field) {
            return ModulesTools.getDeclaringModule((Field)element);
        }
        if (element instanceof Method) {
            return ModulesTools.getDeclaringModule((Method)element);
        }
        return null;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ModuleDefinition && !this.mModulesOnly) {
            ArrayList children = new ArrayList();
            children.addAll(ModuleHelper.getFields((Class)((ModuleDefinition)parentElement).getModuleClass()));
            children.addAll(ModuleHelper.getMethods((Class)((ModuleDefinition)parentElement).getModuleClass()));
            return children.toArray();
        }
        return super.getChildren(parentElement);
    }

    @Override
    protected void populateElements(Object inputElement) {
        if (inputElement instanceof Collection) {
            for (Object module : (Collection)inputElement) {
                if (!(module instanceof ModuleDefinition)) continue;
                this.registerElement(((ModuleDefinition)module).getPath().removeLastSegments(1), module);
            }
        }
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof ModuleDefinition && !this.mModulesOnly) {
            boolean hasChildren = false;
            Class clazz = ((ModuleDefinition)element).getModuleClass();
            if (clazz == null) {
                return false;
            }
            hasChildren |= !ModuleHelper.getMethods((Class)clazz).isEmpty();
            return hasChildren |= !ModuleHelper.getFields((Class)clazz).isEmpty();
        }
        return super.hasChildren(element);
    }
}

