/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.scriptarchive;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;

public class ArchiveEngine
extends AbstractScriptEngine
implements IScriptEngine {
    private IScriptEngine fInternalEngine;
    private Properties fManifest;
    private List<URL> fRegisteredJars = null;

    private static void unpackArchive(Object archive, IProject project) throws CoreException {
        block7: {
            InputStream inputStream = ResourceTools.getInputStream((Object)archive);
            if (inputStream != null) {
                ZipInputStream stream = new ZipInputStream(new BufferedInputStream(inputStream));
                try {
                    ZipEntry entry = stream.getNextEntry();
                    while (entry != null) {
                        Path path = new Path(entry.getName());
                        if (!new Path("/.project").equals((Object)(path = path.removeFirstSegments(1).makeAbsolute()))) {
                            IFile file = project.getFile((IPath)path);
                            ResourceTools.createFolder((IContainer)file.getParent());
                            file.create((InputStream)new ResourceTools.NonClosingInputStream((InputStream)stream), true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        entry = stream.getNextEntry();
                    }
                }
                catch (IOException e) {
                    Logger.error((String)"org.eclipse.ease", (String)"Invalid archive detected", (Throwable)e);
                    if (stream == null) break block7;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static IProject unpack(Object archive) throws CoreException {
        IProject project = ArchiveEngine.createProject("__EASE_ScriptArchive_");
        ArchiveEngine.unpackArchive(archive, project);
        return project;
    }

    private static IProject createProject(String prefix) throws CoreException {
        int count = 1;
        IProject candidate = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(prefix) + count);
        while (candidate.exists()) {
            candidate = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(prefix) + ++count);
        }
        candidate.create((IProgressMonitor)new NullProgressMonitor());
        candidate.open((IProgressMonitor)new NullProgressMonitor());
        return candidate;
    }

    public static InputStream getArchiveStream(Object archive, String filename) {
        block7: {
            InputStream inputStream = ResourceTools.getInputStream((Object)archive);
            if (inputStream != null) {
                ZipInputStream stream = new ZipInputStream(new BufferedInputStream(inputStream));
                try {
                    ZipEntry entry = stream.getNextEntry();
                    while (entry != null) {
                        Path path = new Path(entry.getName());
                        path = path.removeFirstSegments(1).makeAbsolute();
                        if (new Path(filename).makeAbsolute().equals((Object)path)) {
                            return stream;
                        }
                        entry = stream.getNextEntry();
                    }
                }
                catch (IOException e) {
                    Logger.error((String)"org.eclipse.ease.lang.scriptarchive", (String)"Could not read archive", (Throwable)e);
                    if (stream == null) break block7;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    private static int countArchivedFiles(Object archive) {
        InputStream inputStream = ResourceTools.getInputStream((Object)archive);
        if (inputStream != null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (ZipInputStream stream = new ZipInputStream(new BufferedInputStream(inputStream));){
                    int count = 0;
                    ZipEntry entry = stream.getNextEntry();
                    while (entry != null) {
                        ++count;
                        entry = stream.getNextEntry();
                    }
                    return count;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static Properties getManifest(Object archive) {
        InputStream manifestStream = ArchiveEngine.getArchiveStream(archive, "/META-INF/MANIFEST.MF");
        if (manifestStream != null) {
            try {
                Properties properties = new Properties();
                properties.load(manifestStream);
                Properties properties2 = properties;
                return properties2;
            }
            catch (IOException e) {
                Logger.error((String)"org.eclipse.ease.lang.scriptarchive", (String)"Could not read archive", (Throwable)e);
            }
            finally {
                try {
                    manifestStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public ArchiveEngine() {
        super("Script Archive Engine");
    }

    public void registerJar(URL url) {
        if (this.fRegisteredJars == null) {
            this.fRegisteredJars = new ArrayList<URL>();
        }
        this.fRegisteredJars.add(url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupEngine() throws ScriptEngineException {
        EngineDescription engineDescription;
        if (this.getScheduledScripts().isEmpty()) return;
        Script script = (Script)this.getScheduledScripts().get(0);
        Object input = script.getCommand();
        this.fManifest = ArchiveEngine.getManifest(input);
        if (this.fManifest == null) throw new ScriptEngineException("No META-INF/MANIFEST.MF found");
        Object mainScript = this.fManifest.get("Main-Script");
        if (mainScript == null) throw new ScriptEngineException("No Main-Script found in manifest");
        ScriptService scriptService = ScriptService.getInstance();
        ScriptType scriptType = scriptService.getScriptType(mainScript.toString());
        if (scriptType == null || (engineDescription = scriptService.getEngine(scriptType.getName())) == null) return;
        this.fInternalEngine = engineDescription.createEngine();
        if (this.fRegisteredJars != null) {
            for (URL url : this.fRegisteredJars) {
                this.fInternalEngine.registerJar(url);
            }
        }
        this.fInternalEngine.setInputStream(this.getInputStream());
        this.fInternalEngine.setOutputStream((OutputStream)this.getOutputStream());
        this.fInternalEngine.setErrorStream((OutputStream)this.getErrorStream());
        this.fInternalEngine.setVariable("__MANIFEST", (Object)this.fManifest);
    }

    protected void teardownEngine() throws ScriptEngineException {
        if (this.fInternalEngine != null) {
            this.fInternalEngine.terminate();
            this.fInternalEngine = null;
        }
    }

    protected Object execute(Script script, String fileName, boolean uiThread) throws Throwable {
        InputStream mainScriptObject;
        Object input = script.getCommand();
        Object mainScript = this.fManifest.get("Main-Script");
        int archivedFiles = ArchiveEngine.countArchivedFiles(input);
        if (archivedFiles > 2) {
            try {
                IProject localProject = ArchiveEngine.unpack(input);
                mainScriptObject = localProject.getFile((IPath)new Path(mainScript.toString()));
            }
            catch (CoreException e) {
                throw new ScriptEngineException("Could not create temporary project", (Throwable)e);
            }
        } else {
            mainScriptObject = ArchiveEngine.getArchiveStream(input, mainScript.toString());
        }
        if (mainScriptObject != null) {
            ScriptResult result = this.fInternalEngine.execute((Object)mainScriptObject);
            this.fInternalEngine.schedule();
            try {
                Object object = result.get();
                return object;
            }
            finally {
                if (mainScriptObject instanceof InputStream) {
                    try {
                        mainScriptObject.close();
                    }
                    catch (Exception exception) {}
                } else if (mainScriptObject instanceof IFile) {
                    IProject project = ((IFile)mainScriptObject).getProject();
                    project.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        throw new ScriptEngineException("Main-Script cannot be read");
    }

    public void terminateCurrent() {
        if (this.fInternalEngine == null) {
            throw new RuntimeException("Not supported");
        }
        this.fInternalEngine.terminateCurrent();
    }

    protected Object internalGetVariable(String name) {
        throw new RuntimeException("Not supported");
    }

    protected Map<String, Object> internalGetVariables() {
        throw new RuntimeException("Not supported");
    }

    protected boolean internalHasVariable(String name) {
        throw new RuntimeException("Not supported");
    }

    protected void internalSetVariable(String name, Object content) {
        if (this.fInternalEngine == null) {
            throw new RuntimeException("Not supported");
        }
        this.fInternalEngine.setVariable(name, content);
    }
}

