/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.model;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.ease.debugging.model.EaseDebugTarget;
import org.eclipse.ease.debugging.model.EaseDebugVariable;
import org.eclipse.ease.debugging.model.EaseJavaArrayElementVariable;
import org.eclipse.ease.debugging.model.EaseJavaFieldVariable;

public class EaseDebugValue
implements IValue {
    private IDebugElement fParent;
    private Object fValue;
    private List<EaseDebugVariable> fVariables = null;
    private String fValueString = null;

    public static boolean isPrimitiveType(Object value) {
        return value instanceof Integer || value instanceof Byte || value instanceof Short || value instanceof Boolean || value instanceof Character || value instanceof Long || value instanceof Double || value instanceof Float;
    }

    private static Collection<Field> getFields(Class<? extends Object> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        fields.addAll(Arrays.asList(clazz.getFields()));
        Class<? extends Object> superclass = clazz.getSuperclass();
        if (superclass != null) {
            fields.addAll(EaseDebugValue.getFields(superclass));
        }
        return fields;
    }

    public EaseDebugValue(IDebugElement parent, Object value) {
        this.fParent = parent;
        this.fValue = value;
    }

    public void setParent(IDebugElement parent) {
        this.fParent = parent;
        if (this.fVariables != null) {
            for (EaseDebugVariable variable : this.fVariables) {
                variable.setParent(this.fParent);
            }
        }
    }

    public String getReferenceTypeName() {
        if (this.getValue() != null) {
            if (EaseDebugValue.isPrimitiveType(this.getValue())) {
                if (this.getValue() instanceof Integer) {
                    return "int";
                }
                if (this.getValue() instanceof Boolean) {
                    return "bool";
                }
                if (this.getValue() instanceof Character) {
                    return "char";
                }
                return this.fValue.getClass().getSimpleName().toLowerCase();
            }
            return this.getValue().getClass().getSimpleName();
        }
        return "";
    }

    public String getValueString() {
        if (this.fValueString != null) {
            return this.fValueString;
        }
        if (EaseDebugValue.isPrimitiveType(this.fValue)) {
            return this.fValue.toString();
        }
        if (this.fValue instanceof String) {
            return "\"" + this.fValue + "\" (id=" + this.getUniqueID(this.getValue()) + ")";
        }
        if (this.getValue() != null) {
            if (this.getValue().getClass().isArray()) {
                return String.valueOf(this.fValue.getClass().getComponentType().getSimpleName()) + "[" + Array.getLength(this.getValue()) + "] (id=" + this.getUniqueID(this.getValue()) + ")";
            }
            return String.valueOf(this.fValue.getClass().getSimpleName()) + " (id=" + this.getUniqueID(this.getValue()) + ")";
        }
        return "null";
    }

    private String getUniqueID(Object value) {
        if (this.getDebugTarget() != null) {
            return Integer.toString(this.getDebugTarget().getUniqueVariableId(value));
        }
        return "<none>";
    }

    public boolean isAllocated() {
        return this.fValue != null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (String.class.equals(adapter)) {
            return (T)(this.fValue != null ? this.fValue.toString() : "");
        }
        return null;
    }

    public EaseDebugTarget getDebugTarget() {
        if (this.fParent != null) {
            return (EaseDebugTarget)this.fParent.getDebugTarget();
        }
        return null;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public Object getValue() {
        return this.fValue;
    }

    public EaseDebugVariable[] getVariables() {
        if (this.fVariables == null) {
            this.fVariables = new ArrayList<EaseDebugVariable>();
            if (this.getValue() == null) {
                return new EaseDebugVariable[0];
            }
            if (EaseDebugValue.isPrimitiveType(this.getValue())) {
                return new EaseDebugVariable[0];
            }
            if (this.getValue().getClass().isArray()) {
                int length = Array.getLength(this.getValue());
                int index = 0;
                while (index < length) {
                    EaseJavaArrayElementVariable variable = new EaseJavaArrayElementVariable(index, this.getValue(), this.fParent);
                    this.fVariables.add(variable);
                    ++index;
                }
            } else if (this.getValue() instanceof Collection) {
                Collection asCollection = (Collection)this.getValue();
                int index = 0;
                for (Object value : asCollection) {
                    EaseDebugVariable variable = new EaseDebugVariable(String.format("[%d]", index++), value, this.fParent, null);
                    this.fVariables.add(variable);
                }
            } else {
                Collection fields = EaseDebugValue.getFields(this.getValue().getClass());
                fields = fields.stream().filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toSet());
                for (Field field2 : fields) {
                    try {
                        field2.setAccessible(true);
                        EaseJavaFieldVariable variable = new EaseJavaFieldVariable(field2, this.getValue(), this.fParent);
                        this.fVariables.add(variable);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
            this.sortVariables();
        }
        return this.fVariables.toArray(new EaseDebugVariable[this.fVariables.size()]);
    }

    public boolean hasVariables() {
        if (this.getValue() == null) {
            return false;
        }
        if (EaseDebugValue.isPrimitiveType(this.getValue())) {
            return false;
        }
        return this.fVariables != null ? this.getVariables().length > 0 : true;
    }

    public void setVariables(Collection<EaseDebugVariable> variables) {
        if (variables != null) {
            this.fVariables = new ArrayList<EaseDebugVariable>(variables);
            this.sortVariables();
        }
    }

    public void update(Object value) {
        this.fValue = value;
        this.fVariables = null;
    }

    public void setValueString(String valueString) {
        this.fValueString = valueString;
    }

    private void sortVariables() {
        Collections.sort(this.fVariables, (o1, o2) -> {
            String name1 = o1.getName();
            String name2 = o2.getName();
            if (name1.startsWith("[") && name1.endsWith("]") && name2.startsWith("[") && name2.endsWith("]")) {
                try {
                    int index1 = Integer.parseInt(name1.substring(1, name1.length() - 1));
                    int index2 = Integer.parseInt(name2.substring(1, name2.length() - 1));
                    return index1 - index2;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return name1.compareTo(name2);
        });
    }
}

