/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.groovy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ease.AbstractCodeFactory;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.Logger;
import org.eclipse.ease.lang.groovy.GroovyHelper;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.tools.StringTools;

public class GroovyCodeFactory
extends AbstractCodeFactory {
    public static List<String> RESERVED_KEYWORDS = new ArrayList<String>();

    static {
        RESERVED_KEYWORDS.add("abstract");
        RESERVED_KEYWORDS.add("as");
        RESERVED_KEYWORDS.add("assert");
        RESERVED_KEYWORDS.add("boolean");
        RESERVED_KEYWORDS.add("break");
        RESERVED_KEYWORDS.add("byte");
        RESERVED_KEYWORDS.add("case");
        RESERVED_KEYWORDS.add("catch");
        RESERVED_KEYWORDS.add("char");
        RESERVED_KEYWORDS.add("class");
        RESERVED_KEYWORDS.add("const");
        RESERVED_KEYWORDS.add("continue");
        RESERVED_KEYWORDS.add("def");
        RESERVED_KEYWORDS.add("default");
        RESERVED_KEYWORDS.add("do");
        RESERVED_KEYWORDS.add("double");
        RESERVED_KEYWORDS.add("else");
        RESERVED_KEYWORDS.add("enum");
        RESERVED_KEYWORDS.add("extends");
        RESERVED_KEYWORDS.add("false");
        RESERVED_KEYWORDS.add("final");
        RESERVED_KEYWORDS.add("finally");
        RESERVED_KEYWORDS.add("float");
        RESERVED_KEYWORDS.add("for");
        RESERVED_KEYWORDS.add("goto");
        RESERVED_KEYWORDS.add("if");
        RESERVED_KEYWORDS.add("implements");
        RESERVED_KEYWORDS.add("import");
        RESERVED_KEYWORDS.add("in");
        RESERVED_KEYWORDS.add("instanceof");
        RESERVED_KEYWORDS.add("int");
        RESERVED_KEYWORDS.add("interface");
        RESERVED_KEYWORDS.add("long");
        RESERVED_KEYWORDS.add("native");
        RESERVED_KEYWORDS.add("new");
        RESERVED_KEYWORDS.add("null");
        RESERVED_KEYWORDS.add("package");
        RESERVED_KEYWORDS.add("private");
        RESERVED_KEYWORDS.add("protected");
        RESERVED_KEYWORDS.add("public");
        RESERVED_KEYWORDS.add("return");
        RESERVED_KEYWORDS.add("short");
        RESERVED_KEYWORDS.add("static");
        RESERVED_KEYWORDS.add("strictfp");
        RESERVED_KEYWORDS.add("super");
        RESERVED_KEYWORDS.add("switch");
        RESERVED_KEYWORDS.add("synchronized");
        RESERVED_KEYWORDS.add("this");
        RESERVED_KEYWORDS.add("threadsafe");
        RESERVED_KEYWORDS.add("throw");
        RESERVED_KEYWORDS.add("throws");
        RESERVED_KEYWORDS.add("transient");
        RESERVED_KEYWORDS.add("true");
        RESERVED_KEYWORDS.add("try");
        RESERVED_KEYWORDS.add("void");
        RESERVED_KEYWORDS.add("volatile");
        RESERVED_KEYWORDS.add("while");
    }

    private static boolean isValidMethodName(String methodName) {
        return GroovyHelper.isSaveName(methodName) && !RESERVED_KEYWORDS.contains(methodName);
    }

    public String classInstantiation(Class<?> clazz, String[] parameters) {
        StringBuilder code = new StringBuilder();
        code.append("import ");
        code.append(clazz.getName());
        code.append(";\n");
        code.append("new ");
        code.append(clazz.getName());
        code.append("(");
        if (parameters != null) {
            String[] stringArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                code.append('\"');
                code.append(parameter);
                code.append('\"');
                code.append(", ");
                ++n2;
            }
            if (parameters.length > 0) {
                code.replace(code.length() - 2, code.length(), "");
            }
        }
        code.append(")");
        return code.toString();
    }

    protected String getNullString() {
        return "null";
    }

    public String getSaveVariableName(String variableName) {
        return GroovyHelper.getSaveName(variableName);
    }

    private StringBuilder verifyParameters(List<ICodeFactory.Parameter> parameters) {
        StringBuilder data = new StringBuilder();
        return data;
    }

    protected String createFieldWrapper(IEnvironment environment, String identifier, Field field) {
        StringBuilder groovyCode = new StringBuilder();
        groovyCode.append(field.getName());
        groovyCode.append(" = ");
        groovyCode.append(identifier);
        groovyCode.append('.');
        groovyCode.append(field.getName());
        groovyCode.append(';');
        groovyCode.append(StringTools.LINE_DELIMITER);
        return groovyCode.toString();
    }

    public String createFunctionWrapper(IEnvironment environment, String moduleVariable, Method method) {
        String methodId = environment.registerMethod(method);
        StringBuilder groovyCode = new StringBuilder();
        List parameters = ModuleHelper.getParameters((Method)method);
        StringBuilder parameterList = new StringBuilder();
        for (ICodeFactory.Parameter parameter : parameters) {
            parameterList.append(", ").append(this.toSafeName(parameter.getName()));
        }
        if (parameterList.length() > 2) {
            parameterList.delete(0, 2);
        }
        StringBuilder body = new StringBuilder();
        body.append((CharSequence)this.verifyParameters(parameters));
        body.append("\t").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".preMethodCallback('").append(methodId).append("'").append(parameters.isEmpty() ? "" : ", ").append((CharSequence)parameterList).append(");").append(StringTools.LINE_DELIMITER);
        body.append("\t").append("__result").append(" = ").append(moduleVariable).append(".").append(method.getName()).append("(");
        body.append((CharSequence)parameterList);
        body.append(");").append(StringTools.LINE_DELIMITER);
        body.append("\t").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".postMethodCallback('").append(methodId).append("', ").append("__result").append(");").append(StringTools.LINE_DELIMITER);
        body.append("\treturn ").append("__result").append(";").append(StringTools.LINE_DELIMITER);
        for (String name : GroovyCodeFactory.getMethodNames((Method)method)) {
            if (!GroovyCodeFactory.isValidMethodName(name)) {
                Logger.error((String)"org.eclipse.ease.lang.groovy", (String)("The method name \"" + name + "\" from the module \"" + moduleVariable + "\" can not be wrapped because it's name is reserved"));
                continue;
            }
            if (name.isEmpty()) continue;
            groovyCode.append(name).append(" = { ").append((CharSequence)parameterList).append(" ->").append(StringTools.LINE_DELIMITER);
            groovyCode.append((CharSequence)body);
            groovyCode.append("}").append(StringTools.LINE_DELIMITER);
        }
        return groovyCode.toString();
    }

    protected Object getLanguageIdentifier() {
        return "Groovy";
    }

    protected String toSafeName(String name) {
        while (RESERVED_KEYWORDS.contains(name)) {
            name = String.valueOf(name) + "_";
        }
        return name;
    }
}

