/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import org.eclipse.ease.ui.help.hovers.IHoverContentProvider;
import org.eclipse.ease.ui.help.hovers.internal.ControlHoverManager;
import org.eclipse.ease.ui.help.hovers.internal.StaticHoverContentProvider;
import org.eclipse.ease.ui.help.hovers.internal.TableViewerHoverManager;
import org.eclipse.ease.ui.help.hovers.internal.TreeViewerHoverManager;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.IWidgetTokenOwnerExtension;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class HoverManager
implements IWidgetTokenOwner,
IWidgetTokenOwnerExtension {
    private IWidgetTokenKeeper fTokenKeeper;
    private int fPriority = 0;
    private final Composite fHoverContainer;

    public HoverManager(Composite hoverContainer) {
        this.fHoverContainer = hoverContainer;
    }

    public ControlHoverManager addHover(Control control, IHoverContentProvider hoverContent) {
        return new ControlHoverManager(control, (Control)this.fHoverContainer, this, hoverContent);
    }

    public ControlHoverManager addHover(Control control, String hoverContent) {
        return new ControlHoverManager(control, (Control)this.fHoverContainer, this, new StaticHoverContentProvider(hoverContent));
    }

    public ControlHoverManager addHover(TableViewer tableViewer, IHoverContentProvider hoverContent) {
        return new TableViewerHoverManager(tableViewer, (Control)this.fHoverContainer, (IWidgetTokenOwner)this, hoverContent);
    }

    public ControlHoverManager addHover(TreeViewer treeViewer, IHoverContentProvider hoverContent) {
        return new TreeViewerHoverManager(treeViewer, (Control)this.fHoverContainer, (IWidgetTokenOwner)this, hoverContent);
    }

    public boolean requestWidgetToken(IWidgetTokenKeeper requester, int priority) {
        if (this.fTokenKeeper == null) {
            this.fTokenKeeper = requester;
            this.fPriority = priority;
            return true;
        }
        if (this.fTokenKeeper.equals(requester)) {
            this.fPriority = priority;
            return true;
        }
        if (priority > this.fPriority) {
            if (this.fTokenKeeper instanceof IWidgetTokenKeeperExtension) {
                if (((IWidgetTokenKeeperExtension)this.fTokenKeeper).requestWidgetToken((IWidgetTokenOwner)this, priority)) {
                    this.fTokenKeeper = requester;
                    this.fPriority = priority;
                    return true;
                }
            } else if (this.fTokenKeeper.requestWidgetToken((IWidgetTokenOwner)this)) {
                this.fTokenKeeper = requester;
                this.fPriority = priority;
                return true;
            }
        }
        return false;
    }

    public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
        if (this.fTokenKeeper == null || this.fTokenKeeper.equals(requester)) {
            this.fTokenKeeper = requester;
            return true;
        }
        return false;
    }

    public void releaseWidgetToken(IWidgetTokenKeeper tokenKeeper) {
        if (tokenKeeper.equals(this.fTokenKeeper)) {
            this.fTokenKeeper = null;
            this.fPriority = 0;
        }
    }
}

