/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.ruby;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ease.AbstractCodeFactory;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.Logger;
import org.eclipse.ease.lang.ruby.RubyHelper;
import org.eclipse.ease.modules.EnvironmentModule;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.tools.StringTools;

public class RubyCodeFactory
extends AbstractCodeFactory {
    public static List<String> RESERVED_KEYWORDS = new ArrayList<String>();

    public String getSaveVariableName(String variableName) {
        return RubyHelper.getSaveName(variableName);
    }

    public String createFunctionWrapper(IEnvironment environment, String moduleVariable, Method method) {
        String methodId = ((EnvironmentModule)environment).registerMethod(method);
        StringBuilder rubyScriptCode = new StringBuilder();
        List parameters = ModuleHelper.getParameters((Method)method);
        StringBuilder parameterList = new StringBuilder();
        for (ICodeFactory.Parameter parameter : parameters) {
            parameterList.append(", ").append(parameter.getName());
        }
        if (parameterList.length() > 2) {
            parameterList.delete(0, 2);
        }
        StringBuilder body = new StringBuilder();
        body.append((CharSequence)this.verifyParameters(parameters));
        body.append("\t$").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".preMethodCallback('").append(methodId).append("'").append(parameters.isEmpty() ? "" : ", ").append((CharSequence)parameterList).append(");").append(StringTools.LINE_DELIMITER);
        body.append("\t").append("__result").append(" = ").append('$').append(moduleVariable).append('.').append(method.getName()).append('(');
        body.append((CharSequence)parameterList);
        body.append(");\n");
        body.append("\t$").append(EnvironmentModule.getWrappedVariableName((Object)environment)).append(".postMethodCallback('").append(methodId).append("', ").append("__result").append(");").append(StringTools.LINE_DELIMITER);
        body.append("\treturn ").append("__result").append(";\n");
        for (String name : RubyCodeFactory.getMethodNames((Method)method)) {
            if (!RubyCodeFactory.isValidMethodName(name)) {
                Logger.error((String)"org.eclipse.ease.lang.ruby", (String)("The method name \"" + name + "\" from the module \"" + moduleVariable + "\" can not be wrapped because it's name is reserved"));
                continue;
            }
            if (name.isEmpty()) continue;
            rubyScriptCode.append("def ").append(name).append("(").append((CharSequence)parameterList).append(")\n");
            rubyScriptCode.append((CharSequence)body);
            rubyScriptCode.append("end\n");
        }
        return rubyScriptCode.toString();
    }

    private StringBuilder verifyParameters(List<ICodeFactory.Parameter> parameters) {
        StringBuilder data = new StringBuilder();
        return data;
    }

    public String classInstantiation(Class<?> clazz, String[] parameters) {
        StringBuilder code = new StringBuilder();
        code.append(clazz.getName());
        code.append(".new(");
        if (parameters != null) {
            String[] stringArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                code.append('\"');
                code.append(parameter);
                code.append('\"');
                code.append(", ");
                ++n2;
            }
            if (parameters.length > 0) {
                code.replace(code.length() - 2, code.length(), "");
            }
        }
        code.append(")");
        return code.toString();
    }

    private static boolean isValidMethodName(String methodName) {
        return RubyHelper.isSaveName(methodName) && !RESERVED_KEYWORDS.contains(methodName);
    }

    protected String getNullString() {
        return "nil";
    }

    protected String getSingleLineCommentToken() {
        return "#";
    }

    protected Object getLanguageIdentifier() {
        return "Ruby";
    }

    protected String toSafeName(String name) {
        return name;
    }
}

