/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.runtime.impl;

import java.util.Collection;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IReplEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.lang.unittest.definition.Flag;
import org.eclipse.ease.lang.unittest.definition.ICode;
import org.eclipse.ease.lang.unittest.definition.ITestSuiteDefinition;
import org.eclipse.ease.lang.unittest.execution.ITestExecutionStrategy;
import org.eclipse.ease.lang.unittest.runtime.IRuntimePackage;
import org.eclipse.ease.lang.unittest.runtime.ITest;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;
import org.eclipse.ease.lang.unittest.runtime.TestStatus;
import org.eclipse.ease.lang.unittest.runtime.impl.TestContainer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

public class TestSuite
extends TestContainer
implements ITestSuite {
    protected EList<ITestEntity> activeTests;
    protected ITestSuiteDefinition definition;
    protected static final IScriptEngine MASTER_ENGINE_EDEFAULT = null;
    protected IScriptEngine masterEngine = MASTER_ENGINE_EDEFAULT;
    private IScriptEngine fSetupEngine;

    protected TestSuite() {
    }

    @Override
    protected EClass eStaticClass() {
        return IRuntimePackage.Literals.TEST_SUITE;
    }

    @Override
    public EList<ITestEntity> getActiveTests() {
        if (this.activeTests == null) {
            this.activeTests = new EObjectResolvingEList(ITestEntity.class, (InternalEObject)this, 13);
        }
        return this.activeTests;
    }

    @Override
    public ITestSuiteDefinition getDefinition() {
        if (this.definition != null && this.definition.eIsProxy()) {
            InternalEObject oldDefinition = (InternalEObject)this.definition;
            this.definition = (ITestSuiteDefinition)this.eResolveProxy(oldDefinition);
            if (this.definition != oldDefinition && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 14, (Object)oldDefinition, (Object)this.definition));
            }
        }
        return this.definition;
    }

    public ITestSuiteDefinition basicGetDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(ITestSuiteDefinition newDefinition) {
        ITestSuiteDefinition oldDefinition = this.definition;
        this.definition = newDefinition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldDefinition, (Object)this.definition));
        }
    }

    @Override
    public IScriptEngine getMasterEngine() {
        return this.masterEngine;
    }

    @Override
    public void setMasterEngine(IScriptEngine newMasterEngine) {
        IScriptEngine oldMasterEngine = this.masterEngine;
        this.masterEngine = newMasterEngine;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldMasterEngine, (Object)this.masterEngine));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 13: {
                return this.getActiveTests();
            }
            case 14: {
                if (resolve) {
                    return this.getDefinition();
                }
                return this.basicGetDefinition();
            }
            case 15: {
                return this.getMasterEngine();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 13: {
                this.getActiveTests().clear();
                this.getActiveTests().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.setDefinition((ITestSuiteDefinition)newValue);
                return;
            }
            case 15: {
                this.setMasterEngine((IScriptEngine)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 13: {
                this.getActiveTests().clear();
                return;
            }
            case 14: {
                this.setDefinition(null);
                return;
            }
            case 15: {
                this.setMasterEngine(MASTER_ENGINE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 13: {
                return this.activeTests != null && !this.activeTests.isEmpty();
            }
            case 14: {
                return this.definition != null;
            }
            case 15: {
                return MASTER_ENGINE_EDEFAULT == null ? this.masterEngine != null : !MASTER_ENGINE_EDEFAULT.equals(this.masterEngine);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (masterEngine: ");
        result.append(this.masterEngine);
        result.append(')');
        return result.toString();
    }

    @Override
    public ITestSuite getTestSuite() {
        return this;
    }

    @Override
    public void run(ITestExecutionStrategy strategy) {
        this.setEntityStatus(TestStatus.RUNNING);
        try {
            this.runSetupTeardownCode("TestSuite Setup", strategy);
            if (!this.hasSetupError()) {
                Object[] objectArray = this.getChildren().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (!this.isTerminated() && child instanceof ITestContainer) {
                        strategy.execute((ITestEntity)child);
                    }
                    ++n2;
                }
            }
            if (!this.hasError() || this.getDefinition() != null && this.getDefinition().getFlag(Flag.RUN_TEARDOWN_ON_ERROR, true).booleanValue()) {
                this.runSetupTeardownCode("TestSuite Teardown", strategy);
            }
        }
        finally {
            if (this.getMasterEngine() != null) {
                this.setMasterEngine(null);
            }
            if (this.fSetupEngine != null) {
                this.fSetupEngine.terminate();
                this.fSetupEngine = null;
            }
            this.setEntityStatus(TestStatus.FINISHED);
        }
    }

    private boolean hasSetupError() {
        ITestEntity[] iTestEntityArray = (ITestEntity[])this.getChildren().toArray((Object[])new ITestEntity[0]);
        int n = iTestEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestEntity child = iTestEntityArray[n2];
            if (child instanceof ITest && child.hasError()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void runSetupTeardownCode(String codeLocation, ITestExecutionStrategy strategy) {
        ICode customCode;
        ITestSuiteDefinition definition = this.getDefinition();
        if (definition != null && (customCode = definition.getCustomCode(codeLocation)) != null && !customCode.getContent().trim().isEmpty()) {
            if (this.fSetupEngine == null) {
                this.fSetupEngine = strategy.createScriptEngine(this, null);
            }
            if (this.fSetupEngine != null) {
                ScriptResult result;
                if (this.fSetupEngine instanceof IReplEngine) {
                    ((IReplEngine)this.fSetupEngine).setTerminateOnIdle(false);
                }
                if (this.fSetupEngine instanceof AbstractScriptEngine) {
                    ((AbstractScriptEngine)this.fSetupEngine).setExecutionRootFile(this.getResource());
                }
                this.fSetupEngine.setVariable("__EASE_UnitTest_Suite", (Object)this);
                try {
                    result = this.fSetupEngine.executeSync((Object)new Script(customCode.getLocation(), (Object)customCode.getContent()));
                }
                catch (InterruptedException e) {
                    this.getTest("[user event]").addError("Aborted by user", this.fSetupEngine);
                    return;
                }
                if (result.hasException()) {
                    this.getTest("[" + codeLocation + "]").addError(result.getException().getMessage(), this.fSetupEngine);
                    return;
                }
            } else {
                this.getTest("[" + codeLocation + "]").addError("Could not create setup/teardown engine. Please select an appropriate engine on the Overview tab of the *.suite file.", null);
                return;
            }
        }
    }
}

