/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.py4j.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.debugging.dispatcher.EventDispatchJob;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.debugging.model.EaseDebugVariable;
import org.eclipse.ease.lang.python.debugger.IPythonDebugEngine;
import org.eclipse.ease.lang.python.debugger.PythonDebugger;
import org.eclipse.ease.lang.python.debugger.ResourceHelper;
import org.eclipse.ease.lang.python.debugger.model.PythonDebugTarget;
import org.eclipse.ease.lang.python.py4j.internal.Py4jScriptEngine;

public class Py4jDebuggerEngine
extends Py4jScriptEngine
implements IPythonDebugEngine {
    private PythonDebugger fDebugger = null;

    public void setDebugger(PythonDebugger debugger) {
        this.fDebugger = debugger;
    }

    @Override
    protected void setupEngine() throws ScriptEngineException {
        super.setupEngine();
        if (this.fDebugger != null) {
            try {
                InputStream stream = ResourceHelper.getResourceStream((String)"org.eclipse.ease.lang.python", (String)"pysrc/edb.py");
                this.internalSetVariable("_pyease_debugger", this.fDebugger);
                super.internalExecute(new Script("Load Python debugger", (Object)stream), null);
            }
            catch (Throwable e) {
                throw new ScriptEngineException("Failed to load Python Debugger", e);
            }
        }
    }

    @Override
    protected Object internalExecute(Script script, String fileName) throws Throwable {
        if (this.fDebugger != null) {
            return this.fDebugger.execute(script);
        }
        return super.internalExecute(script, fileName);
    }

    public void setupDebugger(ILaunch launch, boolean suspendOnStartup, boolean suspendOnScriptLoad, boolean showDynamicCode) {
        PythonDebugTarget target = new PythonDebugTarget(launch, suspendOnStartup, suspendOnScriptLoad, showDynamicCode);
        launch.addDebugTarget((IDebugTarget)target);
        PythonDebugger debugger = new PythonDebugger((IDebugEngine)this, showDynamicCode);
        this.setDebugger(debugger);
        new EventDispatchJob((IEventProcessor)target, (IEventProcessor)debugger);
    }

    public ScriptStackTrace getExceptionStackTrace() {
        return null;
    }

    public Object removeVariable(String name) {
        throw new UnsupportedOperationException();
    }

    public Collection<EaseDebugVariable> getVariables(Object scope) {
        ArrayList<EaseDebugVariable> variables = new ArrayList<EaseDebugVariable>();
        for (Map.Entry entry : this.getVariables().entrySet()) {
            variables.add(new EaseDebugVariable((String)entry.getKey(), entry.getValue(), "Python"));
        }
        return variables;
    }
}

