/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.view;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.view.IShellDropin;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class VariablesDropin
implements IShellDropin,
IExecutionListener {
    private TreeViewer fVariablesTree = null;
    private IScriptEngine fEngine;

    @Override
    public void setScriptEngine(IScriptEngine engine) {
        if (this.fEngine != null) {
            this.fEngine.removeExecutionListener((IExecutionListener)this);
        }
        this.fEngine = engine;
        if (this.fEngine != null) {
            this.fEngine.addExecutionListener((IExecutionListener)this);
        }
        if (this.fVariablesTree != null) {
            this.fVariablesTree.setInput((Object)engine);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    VariablesDropin.this.fVariablesTree.refresh();
                }
            });
        }
    }

    @Override
    public Composite createPartControl(IWorkbenchPartSite site, Composite parent) {
        Composite composite = new Composite(parent, 0);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        composite.setLayout((Layout)treeColumnLayout);
        this.fVariablesTree = new TreeViewer(composite, 2048);
        Tree tree = this.fVariablesTree.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.fVariablesTree.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !((Map.Entry)element).getKey().toString().startsWith("__MOD_");
            }
        }, new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Object name = ((Map.Entry)element).getKey();
                return !"wait()".equals(name) && !"notify()".equals(name) && !"notifyAll()".equals(name) && !"equals()".equals(name) && !"getClass()".equals(name) && !"hashCode()".equals(name) && !"toString()".equals(name);
            }
        }});
        this.fVariablesTree.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return ((Map.Entry)element).getKey().toString().endsWith("()") ? 2 : 1;
            }
        });
        this.fVariablesTree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IScriptEngine) {
                    return ((IScriptEngine)inputElement).getVariables().entrySet().toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                Object parent = ((Map.Entry)parentElement).getValue();
                HashMap<String, Object> children = new HashMap<String, Object>();
                if (parent != null && !((Map.Entry)parentElement).getKey().toString().endsWith("()")) {
                    AccessibleObject[] accessibleObjectArray = parent.getClass().getFields();
                    int n = accessibleObjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field field = accessibleObjectArray[n2];
                        try {
                            children.put(field.getName(), field.get(parent));
                        }
                        catch (Exception exception) {}
                        ++n2;
                    }
                    accessibleObjectArray = parent.getClass().getMethods();
                    n = accessibleObjectArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        AccessibleObject method = accessibleObjectArray[n2];
                        try {
                            children.put(String.valueOf(((Method)method).getName()) + "()", ((Method)method).getReturnType().getName());
                        }
                        catch (Exception exception) {}
                        ++n2;
                    }
                }
                return children.entrySet().toArray();
            }
        });
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.fVariablesTree, 0);
        TreeColumn column = treeViewerColumn.getColumn();
        treeColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1));
        column.setText("Variable");
        treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Map.Entry)element).getKey().toString();
            }

            public Image getImage(Object element) {
                if (((Map.Entry)element).getKey().toString().endsWith("()")) {
                    return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/function.png", true);
                }
                return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/field.png", true);
            }
        });
        TreeViewerColumn treeViewerColumn2 = new TreeViewerColumn(this.fVariablesTree, 0);
        TreeColumn column2 = treeViewerColumn2.getColumn();
        treeColumnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(1));
        column2.setText("Content");
        treeViewerColumn2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Object value = ((Map.Entry)element).getValue();
                return value != null ? value.toString() : "[null]";
            }
        });
        this.fVariablesTree.setInput((Object)this.fEngine);
        return composite;
    }

    @Override
    public String getTitle() {
        return "Variables";
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        switch (status) {
            case 4: 
            case 6: {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        VariablesDropin.this.fVariablesTree.refresh();
                    }
                });
                break;
            }
            case 2: {
                engine.removeExecutionListener((IExecutionListener)this);
            }
        }
    }
}

