/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.IModuleListener;
import org.eclipse.ease.modules.IScriptFunctionModifier;
import org.eclipse.ease.modules.IScriptModule;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractEnvironment
extends AbstractScriptModule
implements IEnvironment {
    private final List<Object> fModules = new ArrayList<Object>();
    private final Map<String, Object> fModuleNames = new HashMap<String, Object>();
    private final ListenerList fModuleListeners = new ListenerList();

    @Override
    @WrapToScript
    public final Object loadModule(String identifier) {
        IScriptService scriptService;
        Map<String, ModuleDefinition> availableModules;
        ModuleDefinition definition;
        String moduleName = ModuleHelper.resolveName(identifier);
        Object module = this.getModule(moduleName);
        if (module == null && (definition = (availableModules = (scriptService = ScriptService.getService()).getAvailableModules()).get(moduleName)) != null) {
            for (String dependencyId : definition.getDependencies()) {
                ModuleDefinition requiredModule = scriptService.getModuleDefinition(dependencyId);
                if (requiredModule != null && this.loadModule(requiredModule.getPath().toString()) != null) continue;
                Logger.logError("Dependency \"" + dependencyId + "\" could not be resolved.");
                return null;
            }
            module = definition.createModuleInstance();
            if (module instanceof IScriptModule) {
                ((IScriptModule)module).initialize(this.getScriptEngine(), this);
            }
            this.fModuleNames.put(moduleName, module);
            if (module instanceof IScriptFunctionModifier) {
                ArrayList<Object> reverseList = new ArrayList<Object>(this.fModules);
                Collections.reverse(reverseList);
                for (Object e : reverseList) {
                    this.wrap(e);
                }
            }
        }
        if (module == null) {
            this.getScriptEngine().getErrorStream().append("Unable to find module \"" + moduleName + "\"");
        } else {
            this.fModules.remove(module);
            this.fModules.add(0, module);
            this.wrap(module);
        }
        return module;
    }

    @Override
    public void initialize(IScriptEngine engine, IEnvironment environment) {
        super.initialize(engine, environment);
        this.fModules.add(this);
        this.fModuleNames.put("/System/Environment", this);
    }

    @WrapToScript
    public final String listModules() {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        Collection<ModuleDefinition> modules = scriptService.getAvailableModules().values();
        StringBuilder output = new StringBuilder();
        output.append("available modules\n=================\n\n");
        for (ModuleDefinition module : modules) {
            if (!module.isVisible()) continue;
            output.append('\t');
            output.append(module.getPath().toString());
            if (this.getModule(module.getPath().toString()) != null) {
                output.append(" [LOADED]");
            }
            output.append('\n');
        }
        this.print(output);
        return output.toString();
    }

    @Override
    @WrapToScript
    public final Object getModule(String name) {
        return this.fModuleNames.get(name);
    }

    @Override
    public <T, U extends Class<T>> T getModule(U clazz) {
        for (Object module : this.getModules()) {
            if (!clazz.isAssignableFrom(module.getClass())) continue;
            return (T)module;
        }
        return null;
    }

    @Override
    public List<Object> getModules() {
        return Collections.unmodifiableList(this.fModules);
    }

    @Override
    @WrapToScript
    public final void print(@ScriptParameter(defaultValue="") Object text) {
        this.getScriptEngine().getOutputStream().println(text);
    }

    @Override
    public void addModuleListener(IModuleListener listener) {
        this.fModuleListeners.add((Object)listener);
    }

    @Override
    public void removeModuleListener(IModuleListener listener) {
        this.fModuleListeners.remove((Object)listener);
    }

    protected void fireModuleEvent(Object module, int type) {
        Object[] objectArray = this.fModuleListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IModuleListener)listener).notifyModule(module, type);
            ++n2;
        }
    }

    public static IEnvironment getEnvironment(IScriptEngine engine) {
        for (Object variable : engine.getVariables().values()) {
            if (!(variable instanceof IEnvironment)) continue;
            return (IEnvironment)variable;
        }
        return null;
    }
}

