/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ease.IScriptEngineLaunchExtension;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.IModuleWrapper;
import org.eclipse.ease.modules.ModuleCategoryDefinition;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ui.PlatformUI;

public class ScriptService
implements IScriptService {
    private static final String ENGINE = "engine";
    private static final String ENGINE_ID = "engineID";
    private static final Object EXTENSION_MODULE = "module";
    private static final Object EXTENSION_CATEGORY = "category";
    private static final String EXTENSION_LANGUAGE_ID = "org.eclipse.ease.language";
    private static final String EXTENSION_MODULES_ID = "org.eclipse.ease.modules";
    private static final String EXTENSION_SCRIPTTYPE_ID = "org.eclipse.ease.scriptType";
    private static final String SCRIPTTYPE_NAME = "name";
    private static final String LAUNCH_EXTENSION = "launchExtension";
    private static final String MODULE_WRAPPER = "moduleWrapper";
    private static ScriptService fInstance = null;
    private Map<String, ModuleDefinition> fAvailableModules = null;
    private Map<String, EngineDescription> fEngineDescriptions = null;
    private Map<String, IModuleWrapper> fModuleWrappers = null;
    private Map<String, ScriptType> fScriptTypes = null;
    private Map<String, ModuleCategoryDefinition> fAvailableModuleCategories = null;

    public static IScriptService getService() {
        try {
            return (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        }
        catch (IllegalStateException illegalStateException) {
            return ScriptService.getInstance();
        }
    }

    public static synchronized ScriptService getInstance() {
        if (fInstance == null) {
            fInstance = new ScriptService();
        }
        return fInstance;
    }

    private ScriptService() {
    }

    @Override
    public EngineDescription getEngineByID(String engineID) {
        return this.getEngineDescriptions().get(engineID);
    }

    @Override
    public synchronized Map<String, ModuleDefinition> getAvailableModules() {
        if (this.fAvailableModules == null) {
            IConfigurationElement[] config;
            this.fAvailableModules = new HashMap<String, ModuleDefinition>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_MODULES_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (e.getName().equals(EXTENSION_MODULE)) {
                    ModuleDefinition definition = new ModuleDefinition(e);
                    if (definition.getModuleClass() != null) {
                        this.fAvailableModules.put(definition.getPath().toString(), definition);
                    } else {
                        Logger.logWarning("Module <" + definition.getName() + "> in plugin <" + definition.getBundleID() + "> could not be located!");
                    }
                }
                ++n2;
            }
        }
        return this.fAvailableModules;
    }

    @Override
    public Collection<EngineDescription> getEngines() {
        return this.getEngineDescriptions().values();
    }

    @Override
    public List<EngineDescription> getEngines(String scriptType) {
        ArrayList<EngineDescription> result = new ArrayList<EngineDescription>();
        for (EngineDescription description : this.getEngines()) {
            if (!description.supports(scriptType)) continue;
            result.add(description);
        }
        Collections.sort(result, new Comparator<EngineDescription>(){

            @Override
            public int compare(EngineDescription o1, EngineDescription o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        return result;
    }

    private Map<String, EngineDescription> getEngineDescriptions() {
        if (this.fEngineDescriptions == null) {
            IConfigurationElement[] config;
            this.fEngineDescriptions = new HashMap<String, EngineDescription>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_LANGUAGE_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (ENGINE.equals(e.getName())) {
                    EngineDescription engine = new EngineDescription(e);
                    this.fEngineDescriptions.put(engine.getID(), engine);
                }
                ++n2;
            }
        }
        return this.fEngineDescriptions;
    }

    @Override
    public IModuleWrapper getModuleWrapper(String engineID) {
        return this.getModuleWrappers().get(engineID);
    }

    private Map<String, IModuleWrapper> getModuleWrappers() {
        if (this.fModuleWrappers == null) {
            IConfigurationElement[] config;
            this.fModuleWrappers = new HashMap<String, IModuleWrapper>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_LANGUAGE_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    if (MODULE_WRAPPER.equals(e.getName())) {
                        Object extension = e.createExecutableExtension("class");
                        String engineID = e.getAttribute(ENGINE_ID);
                        if (extension instanceof IModuleWrapper && engineID != null) {
                            if (this.fModuleWrappers.containsKey(engineID)) {
                                Logger.logError("The engine id " + engineID + " is already used");
                            } else {
                                this.fModuleWrappers.put(engineID, (IModuleWrapper)extension);
                            }
                        }
                    }
                }
                catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                }
                catch (CoreException coreException) {}
                ++n2;
            }
        }
        return this.fModuleWrappers;
    }

    @Override
    public Collection<IScriptEngineLaunchExtension> getLaunchExtensions(String engineID) {
        IConfigurationElement[] config;
        HashSet<IScriptEngineLaunchExtension> extensions = new HashSet<IScriptEngineLaunchExtension>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_LANGUAGE_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object extension;
                if (LAUNCH_EXTENSION.equals(e.getName()) && e.getAttribute(ENGINE_ID).equals(engineID) && (extension = e.createExecutableExtension("class")) instanceof IScriptEngineLaunchExtension) {
                    extensions.add((IScriptEngineLaunchExtension)extension);
                }
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return extensions;
    }

    @Override
    public Map<String, ScriptType> getAvailableScriptTypes() {
        if (this.fScriptTypes == null) {
            IConfigurationElement[] config;
            this.fScriptTypes = new HashMap<String, ScriptType>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_SCRIPTTYPE_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if ("scriptType".equals(e.getName())) {
                    this.fScriptTypes.put(e.getAttribute(SCRIPTTYPE_NAME), new ScriptType(e));
                }
                ++n2;
            }
        }
        return this.fScriptTypes;
    }

    @Override
    public ScriptType getScriptType(String location) {
        int pos;
        Object resource = ResourceTools.getResource(location);
        try {
            IContentDescription description;
            if (resource instanceof IFile && (description = ((IFile)resource).getContentDescription()) != null) {
                IContentType contentType = description.getContentType();
                for (ScriptType scriptType : this.getAvailableScriptTypes().values()) {
                    if (!scriptType.getContentTypes().contains(contentType.getId())) continue;
                    return scriptType;
                }
            }
        }
        catch (CoreException coreException) {}
        if ((pos = location.lastIndexOf(46)) != -1) {
            String extension = location.substring(pos + 1);
            for (ScriptType scriptType : this.getAvailableScriptTypes().values()) {
                if (!scriptType.getDefaultExtension().equalsIgnoreCase(extension)) continue;
                return scriptType;
            }
        }
        return null;
    }

    @Override
    public EngineDescription getEngine(String scriptType) {
        List<EngineDescription> engines = this.getEngines(scriptType);
        if (!engines.isEmpty()) {
            return engines.get(0);
        }
        return null;
    }

    @Override
    public Map<String, ModuleCategoryDefinition> getAvailableModuleCategories() {
        if (this.fAvailableModuleCategories == null) {
            IConfigurationElement[] config;
            this.fAvailableModuleCategories = new HashMap<String, ModuleCategoryDefinition>();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_MODULES_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (e.getName().equals(EXTENSION_CATEGORY)) {
                    ModuleCategoryDefinition definition = new ModuleCategoryDefinition(e);
                    this.fAvailableModuleCategories.put(definition.getId(), definition);
                }
                ++n2;
            }
        }
        return this.fAvailableModuleCategories;
    }

    @Override
    public ModuleDefinition getModuleDefinition(String moduleId) {
        for (ModuleDefinition definition : this.getAvailableModules().values()) {
            if (!definition.getId().equals(moduleId)) continue;
            return definition;
        }
        return null;
    }
}

