/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineLaunchExtension;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.service.ScriptType;

public class EngineDescription {
    private static final String CLASS = "class";
    private static final String PRIORITY = "priority";
    private static final String BINDING = "binding";
    private static final String TYPE = "scriptType";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DEBUGGING = "debugger";
    private final IConfigurationElement fConfigurationElement;
    private List<ScriptType> fTypes = null;

    public EngineDescription(IConfigurationElement configurationElement) {
        this.fConfigurationElement = configurationElement;
    }

    public List<ScriptType> getSupportedScriptTypes() {
        if (this.fTypes == null) {
            this.fTypes = new ArrayList<ScriptType>();
            IScriptService scriptService = ScriptService.getService();
            IConfigurationElement[] iConfigurationElementArray = this.fConfigurationElement.getChildren(BINDING);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                String scriptTypeID = child.getAttribute(TYPE);
                if (scriptTypeID != null) {
                    ScriptType scriptType = scriptService.getAvailableScriptTypes().get(scriptTypeID);
                    if (scriptType == null) {
                        Logger.logError("Unknow scriptType " + scriptTypeID);
                    } else {
                        this.fTypes.add(scriptType);
                    }
                }
                ++n2;
            }
        }
        return this.fTypes;
    }

    public int getPriority() {
        try {
            return Integer.parseInt(this.fConfigurationElement.getAttribute(PRIORITY));
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public IScriptEngine createEngine() {
        try {
            Object object = this.fConfigurationElement.createExecutableExtension(CLASS);
            if (object instanceof IScriptEngine) {
                if (object instanceof AbstractScriptEngine) {
                    ((AbstractScriptEngine)object).setEngineDescription(this);
                }
                IScriptService scriptService = ScriptService.getService();
                for (IScriptEngineLaunchExtension extension : scriptService.getLaunchExtensions(this.getID())) {
                    extension.createEngine((IScriptEngine)object);
                }
                return (IScriptEngine)object;
            }
        }
        catch (CoreException e) {
            Logger.logError("Could not create script engine: " + this.getID(), e);
        }
        return null;
    }

    public String getID() {
        return this.fConfigurationElement.getAttribute(ID);
    }

    public String getName() {
        String name = this.fConfigurationElement.getAttribute(NAME);
        return name != null ? name : this.getID();
    }

    public boolean supports(String scriptType) {
        for (ScriptType type : this.getSupportedScriptTypes()) {
            if (!type.getName().equals(scriptType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public boolean supportsDebugging() {
        return Boolean.parseBoolean(this.fConfigurationElement.getAttribute(DEBUGGING));
    }
}

