/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.eclipse.dirigible.repository.ext.db.transfer.DBTableImporter;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.PermissionsUtils;
import org.eclipse.dirigible.runtime.content.ContentBaseServlet;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;

public class DataImporterServlet
extends ContentBaseServlet {
    private static final long serialVersionUID = 5844468087553458293L;
    private static final Logger logger = Logger.getLogger(DataImporterServlet.class);
    private static final String PARAMETER_TABLE = "table";
    public static final String PARAMETER_TABLE_ERR = "Parameter 'table' is not present while importing a single data file. Use .../data-import?table=TABLE_XXX";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block8: {
            if (!PermissionsUtils.isUserInRole((HttpServletRequest)request, (String)"Operator")) {
                String err = String.format("%s called, but the user does not have permissions to do this operation", "Data Import");
                logger.error(err);
                throw new ServletException(err);
            }
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            try {
                if (isMultipart) {
                    DiskFileItemFactory factory = new DiskFileItemFactory();
                    ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                    try {
                        List items = upload.parseRequest(request);
                        logger.debug("Importing multiple data files...");
                        for (FileItem fileItem : items) {
                            logger.debug("Importing " + fileItem.getFieldName());
                            InputStream in = fileItem.getInputStream();
                            this.importData(fileItem.getFieldName(), in, request);
                            logger.debug("Data imported.");
                        }
                        break block8;
                    }
                    catch (FileUploadException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        response.sendError(500);
                    }
                    break block8;
                }
                logger.debug("Importing single data file...");
                String tableName = request.getParameter(PARAMETER_TABLE);
                if (tableName == null || "".equals(tableName)) {
                    logger.error(PARAMETER_TABLE_ERR);
                    throw new ServletException(PARAMETER_TABLE_ERR);
                }
                ServletInputStream in = request.getInputStream();
                this.importData(String.valueOf(tableName) + ".dsv", (InputStream)in, request);
                logger.debug("Data imported.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                response.sendError(500);
            }
        }
    }

    public void importData(String tableName, InputStream content, HttpServletRequest request) throws Exception {
        byte[] data = IOUtils.toByteArray((InputStream)content);
        DBTableImporter dataInserter = new DBTableImporter(RepositoryFacade.getInstance().getDataSource(), data, tableName);
        dataInserter.insert();
    }
}

