/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.ed.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.common.CommonUtils;
import org.eclipse.dirigible.ide.datasource.DataSourceFacade;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.template.ui.ed.view.ExtensionsContentProvider;
import org.eclipse.dirigible.ide.template.ui.ed.view.ExtensionsLabelProvider;
import org.eclipse.dirigible.ide.template.ui.ed.wizard.Messages;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.commands.OpenHandler;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionDefinition;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionManager;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionPointDefinition;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class ExtensionsView
extends ViewPart {
    private static final Logger logger = Logger.getLogger(ExtensionsView.class);
    public static final String EXTENSIONS_ERROR = Messages.ExtensionsView_EXTENSIONS_ERROR;
    private TreeViewer viewer;
    private ExtensionManager extensionManager = new ExtensionManager(RepositoryFacade.getInstance().getRepository(), DataSourceFacade.getInstance().getDataSource(), CommonParameters.getRequest());

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 2564);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ExtensionsContentProvider(this.extensionManager, this.viewer.getControl().getShell()));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ExtensionsLabelProvider());
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput(this.getExtensionPoints());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object firstElement = selection.getFirstElement();
                if (firstElement != null) {
                    if (firstElement instanceof ExtensionPointDefinition) {
                        ExtensionPointDefinition extensionPoint = (ExtensionPointDefinition)firstElement;
                        ExtensionsView.this.openEditor(String.valueOf(CommonUtils.formatToIDEPath((String)"ExtensionDefinitions", (String)extensionPoint.getLocation())) + ".extensionpoint");
                    } else if (firstElement instanceof ExtensionDefinition) {
                        ExtensionDefinition extension = (ExtensionDefinition)firstElement;
                        ExtensionsView.this.openEditor(String.valueOf(CommonUtils.formatToIDEPath((String)"ExtensionDefinitions", (String)extension.getLocation())) + ".extension");
                    }
                }
            }
        });
    }

    private void openEditor(String path) {
        Path location = new Path(path);
        IWorkspace workspace = WorkspaceLocator.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile file = root.getFile((IPath)location);
        if (file.exists()) {
            OpenHandler.open((Object)file, (int)0);
        }
    }

    private List<ExtensionPointDefinition> getExtensionPoints() {
        ArrayList<ExtensionPointDefinition> extensionPoints = new ArrayList<ExtensionPointDefinition>();
        try {
            String[] stringArray = this.extensionManager.getExtensionPoints();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nextExtensionPoint = stringArray[n2];
                extensionPoints.add(this.extensionManager.getExtensionPoint(nextExtensionPoint));
                ++n2;
            }
        }
        catch (Exception e) {
            logger.error(EXTENSIONS_ERROR, (Throwable)e);
            MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)EXTENSIONS_ERROR, (String)e.getMessage());
        }
        return extensionPoints;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

