/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.db.wizard;

import java.util.Random;
import org.eclipse.dirigible.ide.datasource.DataSourceFacade;
import org.eclipse.dirigible.ide.db.export.DataExportDialog;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateModel;
import org.eclipse.dirigible.ide.template.ui.db.wizard.Messages;
import org.eclipse.dirigible.repository.ext.db.DBSupportedTypesMap;
import org.eclipse.dirigible.repository.ext.db.transfer.DBTableExporter;
import org.eclipse.dirigible.repository.ext.db.transfer.TableColumn;
import org.eclipse.dirigible.repository.ext.db.transfer.TableName;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DataStructureTemplateDSVPage
extends WizardPage {
    private static final long serialVersionUID = 7697608637259213988L;
    private static final String AVAILABLE_TABLES = Messages.DataStructureTemplateDSVPage_0;
    private static final String DSV = Messages.DataStructureTemplateDSVPage_1;
    private static final String PAGE_NAME = "org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateDSVPage";
    private static final String NO_TABLE_IS_SELECTED_PLEASE_SELECT_ONE = Messages.DataStructureTemplateDSVPage_2;
    private static final String GENERATE_DSV_SAMPLE_BASED_ON_TABLE = Messages.DataStructureTemplateDSVPage_3;
    private DataStructureTemplateModel model;
    private Label labelSelected;

    protected DataStructureTemplateDSVPage(DataStructureTemplateModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(DSV);
        this.setDescription(GENERATE_DSV_SAMPLE_BASED_ON_TABLE);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createTablesList(composite);
        this.checkPageStatus();
    }

    private void createTablesList(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(AVAILABLE_TABLES);
        label.setLayoutData((Object)new GridData(16384, 1024, false, false));
        final TableViewer typeViewer = DataExportDialog.createTableList((Composite)parent);
        typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (typeViewer.getTable().getSelection() != null && typeViewer.getTable().getSelection().length > 0) {
                    TableName selectedTableName = (TableName)typeViewer.getTable().getSelection()[0].getData();
                    if (selectedTableName != null) {
                        DataStructureTemplateDSVPage.this.model.setTableName(selectedTableName.getName());
                        DBTableExporter dataFinder = new DBTableExporter(DataSourceFacade.getInstance().getDataSource());
                        dataFinder.setTableName(selectedTableName.getName());
                        dataFinder.getTableData();
                        DataStructureTemplateDSVPage.this.model.setDsvSampleRows(this.generateDsvSamplesRows(dataFinder.getTableColumns()));
                        DataStructureTemplateDSVPage.this.labelSelected.setText(selectedTableName.getName());
                        DataStructureTemplateDSVPage.this.labelSelected.pack();
                    } else {
                        DataStructureTemplateDSVPage.this.model.setTableName(null);
                        DataStructureTemplateDSVPage.this.labelSelected.setText("");
                        DataStructureTemplateDSVPage.this.labelSelected.pack();
                    }
                } else {
                    DataStructureTemplateDSVPage.this.model.setTableName(null);
                }
                DataStructureTemplateDSVPage.this.checkPageStatus();
            }

            private String[] generateDsvSamplesRows(TableColumn[] tableColumns) {
                StringBuilder dsvSample = new StringBuilder();
                int columnsCount = tableColumns.length;
                int i = 0;
                while (i < 3) {
                    int columnIndex = 0;
                    while (columnIndex < columnsCount) {
                        TableColumn column = tableColumns[columnIndex];
                        String sampleValue = this.getSampleValue(column);
                        dsvSample.append(sampleValue);
                        if (columnIndex < columnsCount - 1) {
                            dsvSample.append("|");
                        }
                        ++columnIndex;
                    }
                    dsvSample.append(";");
                    ++i;
                }
                return dsvSample.toString().split(";");
            }

            private String getSampleValue(TableColumn column) {
                String type = DBSupportedTypesMap.getTypeName((int)column.getType());
                boolean numeric = type.equals("BIGINT") || type.equals("SMALLINT") || type.equals("BINARY") || type.equals("BIT") || type.equals("INTEGER") || type.equals("NUMERIC") || type.equals("TINYINT");
                boolean blob = type.equals("BLOB");
                boolean clob = type.equals("CLOB");
                boolean booleanType = type.equals("BOOLEAN");
                boolean textChar = type.equals("CHAR");
                boolean textVarchar = type.equals("NVARCHAR") || type.equals("VARCHAR");
                boolean date = type.equals("DATE");
                boolean floatingPoint = type.equals("REAL") || type.equals("DECIMAL") || type.equals("DOUBLE") || type.equals("FLOAT");
                boolean time = type.equals("TIME");
                boolean timeStamp = type.equals("TIMESTAMP");
                String value = null;
                Random rand = new Random();
                if (numeric) {
                    value = Integer.toString(rand.nextInt(100) + 1);
                } else if (!(blob || clob || booleanType)) {
                    value = time ? "10:30:45" : (timeStamp ? "2014-02-19 10:30:45" : (textChar ? "J" : (textVarchar ? "Test" + rand.nextInt(100) : (date ? "2014-02-19" : (floatingPoint ? Float.toString(rand.nextFloat()) : "Unsupported Type:")))));
                }
                return value;
            }
        });
        this.labelSelected = new Label(parent, 0);
        this.labelSelected.setText("");
        this.labelSelected.setLayoutData((Object)new GridData(16384, 1024, true, false));
    }

    private void checkPageStatus() {
        if (this.model.getTableName() == null || "".equals(this.model.getTableName())) {
            this.setErrorMessage(NO_TABLE_IS_SELECTED_PLEASE_SELECT_ONE);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

