/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import java.io.InputStream;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.common.CommonUtils;
import org.eclipse.dirigible.ide.template.ui.common.Messages;
import org.eclipse.dirigible.ide.template.ui.common.TemplateType;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;
import org.eclipse.dirigible.ide.ui.common.validation.ValidationStatus;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.repository.logging.Logger;

public abstract class GenerationModel {
    private static final String EMPTY_STRING = "";
    private static final String COULD_NOT_OPEN_INPUT_STREAM_FOR = Messages.GenerationModel_COULD_NOT_OPEN_INPUT_STREAM_FOR;
    private static final String TEMPLATE_LOCATION_IS_EMPTY = Messages.GenerationModel_TEMPLATE_LOCATION_IS_EMPTY;
    private static final String RESOURCE_ALREADY_EXISTS_IN_THE_WORKSPACE = Messages.GenerationModel_RESOURCE_ALREADY_EXISTS_IN_THE_WORKSPACE;
    private static final String NAME_IS_NOT_VALID_FOR_A_RESOURCE_OF_THE_GIVEN_TYPE_S = Messages.GenerationModel_NAME_IS_NOT_VALID_FOR_A_RESOURCE_OF_THE_GIVEN_TYPE_S;
    private static final String PATH_IS_NOT_VALID_FOR_A_RESOURCE_OF_THE_GIVEN_TYPE_S = Messages.GenerationModel_PATH_IS_NOT_VALID_FOR_A_RESOURCE_OF_THE_GIVEN_TYPE_S;
    private static final Logger logger = Logger.getLogger(GenerationModel.class);
    private IResource sourceResource;
    private String targetContainer;
    private String packageName;
    private String fileName;
    private TemplateType template;
    private Class<?> templateClassLoader;

    public IResource getSourceResource() {
        return this.sourceResource;
    }

    public void setSourceResource(IResource sourceResource) {
        this.sourceResource = sourceResource;
    }

    public String getTargetLocation() {
        if (this.targetContainer == null) {
            return null;
        }
        if (this.getPackageName() == null) {
            return this.targetContainer;
        }
        return String.valueOf(this.targetContainer) + "/" + this.getPackageName();
    }

    public String getTargetContainer() {
        return this.targetContainer;
    }

    public void setTargetContainer(String targetContainer) {
        this.targetContainer = targetContainer;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        if (this.packageName != null && this.packageName.length() > 1 && this.packageName.startsWith("/")) {
            this.packageName = this.packageName.substring(1);
        }
        this.packageName = packageName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getTemplateLocation() {
        if (this.template != null) {
            return this.template.getLocation();
        }
        return null;
    }

    public String getTemplateExtension() {
        if (this.template != null) {
            return this.template.getExtension();
        }
        return null;
    }

    public TemplateType getTemplate() {
        return this.template;
    }

    public void setTemplate(TemplateType template) {
        this.template = template;
    }

    public IValidationStatus validateLocationGeneric() {
        IWorkspace workspace = WorkspaceLocator.getWorkspace();
        return this.validateLocationGeneric(workspace);
    }

    public IValidationStatus validateLocationGeneric(IWorkspace workspace) {
        IStatus folderLocationValidation = workspace.validatePath(this.getTargetLocation(), 2);
        IStatus projectLocationValidation = workspace.validatePath(this.getTargetLocation(), 4);
        if (!folderLocationValidation.isOK() && !projectLocationValidation.isOK()) {
            return ValidationStatus.createError((String)PATH_IS_NOT_VALID_FOR_A_RESOURCE_OF_THE_GIVEN_TYPE_S);
        }
        if (this.getTargetLocation().contains("ScriptingServices")) {
            if (this.isValidScriptingServiceFileName(this.getFileName())) {
                IWorkspaceRoot root = workspace.getRoot();
                if (this.isResourceExist(root)) {
                    IResource res = this.extractResource(root);
                    return ValidationStatus.createError((String)String.format(RESOURCE_ALREADY_EXISTS_IN_THE_WORKSPACE, res.getFullPath().toString()));
                }
                return ValidationStatus.createOk();
            }
            return ValidationStatus.createError((String)NAME_IS_NOT_VALID_FOR_A_RESOURCE_OF_THE_GIVEN_TYPE_S);
        }
        IStatus nameValidation = workspace.validateName(this.getFileName(), 1);
        if (!nameValidation.isOK()) {
            return ValidationStatus.createError((String)NAME_IS_NOT_VALID_FOR_A_RESOURCE_OF_THE_GIVEN_TYPE_S);
        }
        IWorkspaceRoot root = workspace.getRoot();
        if (this.isResourceExist(root)) {
            IPath location = new Path(this.getTargetLocation()).append(this.getFileName());
            return ValidationStatus.createError((String)String.format(RESOURCE_ALREADY_EXISTS_IN_THE_WORKSPACE, location.toString()));
        }
        return ValidationStatus.createOk();
    }

    public IValidationStatus validateTemplate() {
        if (this.getTemplateLocation() == null || EMPTY_STRING.equals(this.getTemplateLocation())) {
            return ValidationStatus.createError((String)TEMPLATE_LOCATION_IS_EMPTY);
        }
        InputStream in = null;
        in = this.getTemplateClassLoader() != null ? this.getTemplateClassLoader().getResourceAsStream(this.getTemplateLocation()) : this.getClass().getResourceAsStream(this.getTemplateLocation());
        if (in == null) {
            logger.error(String.valueOf(COULD_NOT_OPEN_INPUT_STREAM_FOR) + this.getTemplateLocation());
            return ValidationStatus.createError((String)String.format(COULD_NOT_OPEN_INPUT_STREAM_FOR, this.getTemplateLocation()));
        }
        return ValidationStatus.createOk();
    }

    protected abstract IValidationStatus validate();

    public String getFileNameNoExtension() {
        return CommonUtils.getFileNameNoExtension((String)this.fileName);
    }

    public String getProjectName() {
        StringBuilder result = new StringBuilder();
        if (this.getTargetContainer() == null) {
            return null;
        }
        Path location = new Path(this.getTargetContainer());
        result.append(location.segment(0));
        return result.toString();
    }

    public Class<?> getTemplateClassLoader() {
        return this.templateClassLoader;
    }

    public void setTemplateClassLoader(Class<?> templateClassLoader) {
        this.templateClassLoader = templateClassLoader;
    }

    private boolean isValidScriptingServiceFileName(String fileName) {
        String scriptingServicefileRegExPattern = "([a-zA-Z_0-9]+)+([\\.]){0,1}(([a-zA-Z0-9]*)*)";
        return Pattern.matches(scriptingServicefileRegExPattern, fileName);
    }

    private boolean isResourceExist(IWorkspaceRoot root) {
        IResource resource = this.extractResource(root);
        return resource != null;
    }

    private IResource extractResource(IWorkspaceRoot root) {
        IPath location = new Path(this.getTargetLocation()).append(this.getFileName());
        IResource resource = root.findMember(location.toString());
        return resource;
    }
}

