/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.decorators.impl;

import java.util.Arrays;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.decorators.IBookmarkDecorationService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.providers.decorators.impl.AbstractDecorationService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.icons.ImageDescription;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.ElementIDUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IDecoration;

public class BookmarkDecorationService
extends AbstractDecorationService
implements IBookmarkDecorationService {
    private static final String ELEMENT_ID = "elementId";
    private static final String BLANK_ID = "";

    private String getElementId(Object object) {
        return ElementIDUtil.INSTANCE.getElementId(object);
    }

    private boolean hasBookmark(Object object) {
        IMarker[] bookmarks = null;
        Object resource = null;
        try {
            if (object instanceof EObject) {
                bookmarks = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.datatools.connectivity.sqm.core.ui.explorerBookmark", true, 2);
            } else if (object instanceof IAdaptable && (resource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) != null) {
                bookmarks = resource.isAccessible() ? resource.findMarkers("org.eclipse.datatools.connectivity.sqm.core.ui.explorerBookmark", true, 2) : null;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (bookmarks == null) {
            return false;
        }
        IMarker foundMarker = null;
        String elementID = this.getElementId(resource != null ? resource : object);
        for (IMarker marker : Arrays.asList(bookmarks)) {
            String attribute = marker.getAttribute(ELEMENT_ID, BLANK_ID);
            if (attribute.equals(BLANK_ID) || !attribute.equals(elementID)) continue;
            foundMarker = marker;
            break;
        }
        return foundMarker != null;
    }

    public void decorate(Object element, IDecoration decoration) {
        if (this.hasBookmark(element)) {
            decoration.addOverlay(ImageDescription.getBookmarkDescriptor());
        }
    }
}

