/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers.models;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.IDriverValuesProvider;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.MySafeRunnable;
import org.eclipse.datatools.connectivity.drivers.models.OverrideTemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class TemplateDescriptor
implements Comparable {
    public static final String TEMPLATE_TAG = "driverExtension";
    public static final String PLUGIN_LOC = "\\[\\%PLUGIN_LOC\\%\\]";
    private static final String EXTENSION_POINT_NAME = "driverExtension";
    private static final String DRIVERTEMPLATE_ELEMENT_TAG = "driverTemplate";
    private static final String PROPERTIES_ELEMENT_TAG = "properties";
    private static final String PROPERTY_ELEMENT_TAG = "property";
    private static final String CREATEDEFAULT_TAG = "createDefault";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String PARENTCATEGORY_ATTRIBUTE = "parentCategory";
    private static final String JARLIST_ATTRIBUTE = "jarList";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String EMPTYJARLISTOK_TAG = "emptyJarListIsOK";
    private static final String VALUESPROVIDER_ATTRIBUTE = "valuesProvider";
    private static final String DEFAULT_DEFINITION_NAME_ATTRIBUTE = "defaultDefinitionName";
    private IDriverValuesProvider driverValuesProvider = null;
    private static TemplateDescriptor[] fgDriverTemplateDescriptors;
    private IConfigurationElement fElement;

    protected TemplateDescriptor(IConfigurationElement element) {
        this.fElement = element;
        Assert.isNotNull((Object)this.getId(), (String)DriverMgmtMessages.getString("TemplateDescriptor.msg.id_missing"));
        Assert.isNotNull((Object)this.getName(), (String)DriverMgmtMessages.getString("TemplateDescriptor.msg.name_missing"));
    }

    public static TemplateDescriptor[] getDriverTemplateDescriptors() {
        if (fgDriverTemplateDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), "driverExtension");
            fgDriverTemplateDescriptors = TemplateDescriptor.createDriverTemplateDescriptors(elements);
        }
        return fgDriverTemplateDescriptors;
    }

    public static TemplateDescriptor getDriverTemplateDescriptor(String id) {
        if (fgDriverTemplateDescriptors == null) {
            fgDriverTemplateDescriptors = TemplateDescriptor.getDriverTemplateDescriptors();
        }
        int i = 0;
        while (i < fgDriverTemplateDescriptors.length) {
            TemplateDescriptor desc = fgDriverTemplateDescriptors[i];
            if (desc.getId().equals(id)) {
                return desc;
            }
            ++i;
        }
        return null;
    }

    public CategoryDescriptor getParent() {
        List<CategoryDescriptor> col = Arrays.asList(CategoryDescriptor.getCategoryDescriptors());
        for (CategoryDescriptor cat : col) {
            if (!cat.getId().equals(this.getParentCategory())) continue;
            return cat;
        }
        return null;
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public IDriverValuesProvider getValuesProviderClass() {
        if (this.fElement.getAttribute(VALUESPROVIDER_ATTRIBUTE) != null && this.driverValuesProvider == null) {
            try {
                this.driverValuesProvider = (IDriverValuesProvider)this.fElement.createExecutableExtension(VALUESPROVIDER_ATTRIBUTE);
                this.driverValuesProvider.setDriverTemplate(this);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return this.driverValuesProvider;
    }

    public String getParentCategory() {
        OverrideTemplateDescriptor[] overrides = OverrideTemplateDescriptor.getByDriverTemplate(this.getId());
        if (overrides != null && overrides.length > 0 && overrides[0].getParentCategory() != null) {
            return overrides[0].getParentCategory();
        }
        return this.fElement.getAttribute(PARENTCATEGORY_ATTRIBUTE);
    }

    public String getJarList() {
        String jarList;
        OverrideTemplateDescriptor[] overrides = OverrideTemplateDescriptor.getByDriverTemplate(this.getId());
        StringBuffer jarListBuf = new StringBuffer();
        if (overrides != null && overrides.length > 0 && overrides[0].getJarList() != null && overrides[0].getJarList().length() > 0) {
            jarListBuf.append(overrides[0].getJarList());
        }
        String string = jarList = jarListBuf.length() > 0 ? jarListBuf.toString() : this.fElement.getAttribute(JARLIST_ATTRIBUTE);
        if (jarList == null) {
            jarList = new String();
        }
        if (!jarList.matches(".*\\[\\%PLUGIN_LOC\\%\\].*")) {
            return jarList;
        }
        try {
            String pluginID = this.fElement.getContributor().getName();
            String pluginLoc = FileLocator.resolve((URL)Platform.getBundle((String)pluginID).getEntry("")).getFile();
            if (pluginLoc.charAt(0) == '/') {
                pluginLoc = pluginLoc.substring(1);
            }
            if (pluginLoc.charAt(pluginLoc.length() - 1) == '/') {
                pluginLoc = pluginLoc.substring(0, pluginLoc.length() - 1);
            }
            jarList = jarList.replaceAll(PLUGIN_LOC, pluginLoc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jarList;
    }

    public boolean getCreateDefaultFlag() {
        OverrideTemplateDescriptor[] overrides = OverrideTemplateDescriptor.getByDriverTemplate(this.getId());
        if (overrides != null && overrides.length > 0 && overrides[0].getCreateDefaultFlag() != null) {
            Boolean flag = Boolean.valueOf(overrides[0].getCreateDefaultFlag());
            return flag;
        }
        if (this.fElement.getAttribute(CREATEDEFAULT_TAG) != null) {
            Boolean flag = Boolean.valueOf(this.fElement.getAttribute(CREATEDEFAULT_TAG));
            return flag;
        }
        return true;
    }

    public boolean getEmptyJarListIsOKFlag() {
        OverrideTemplateDescriptor[] overrides = OverrideTemplateDescriptor.getByDriverTemplate(this.getId());
        if (overrides != null && overrides.length > 0 && overrides[0].getEmptyJarListIsOKFlag() != null) {
            Boolean flag = Boolean.valueOf(overrides[0].getEmptyJarListIsOKFlag());
            return flag;
        }
        if (this.fElement.getAttribute(EMPTYJARLISTOK_TAG) != null) {
            Boolean flag = Boolean.valueOf(this.fElement.getAttribute(EMPTYJARLISTOK_TAG));
            return flag;
        }
        return false;
    }

    public IConfigurationElement getElement() {
        return this.fElement;
    }

    public String getName() {
        String name;
        OverrideTemplateDescriptor[] overrides = OverrideTemplateDescriptor.getByDriverTemplate(this.getId());
        if (overrides != null && overrides.length > 0 && overrides[0].getName() != null && overrides[0].getName().length() > 0 && !(name = overrides[0].getName()).equals(this.getId())) {
            return name;
        }
        name = this.fElement.getAttribute(NAME_ATTRIBUTE);
        if (name == null && this.getId() != null) {
            name = this.getId();
        }
        return name;
    }

    public boolean getRemoveFlag() {
        OverrideTemplateDescriptor[] overrides = OverrideTemplateDescriptor.getByDriverTemplate(this.getId());
        if (overrides != null && overrides.length > 0 && overrides[0].getRemoveFlag()) {
            return overrides[0].getRemoveFlag();
        }
        return false;
    }

    public String getDefaultDefinitionName() {
        String overrideDefaultDefinitionName;
        OverrideTemplateDescriptor[] overrides = OverrideTemplateDescriptor.getByDriverTemplate(this.getId());
        if (overrides != null && overrides.length > 0 && overrides[0].getDefaultDefinitionName() != null && overrides[0].getDefaultDefinitionName().length() > 0 && !(overrideDefaultDefinitionName = overrides[0].getDefaultDefinitionName()).equals(this.getName())) {
            return overrideDefaultDefinitionName;
        }
        String defaultDefinitionName = this.fElement.getAttribute(DEFAULT_DEFINITION_NAME_ATTRIBUTE);
        if (defaultDefinitionName == null && this.getName() != null) {
            defaultDefinitionName = this.getName();
        }
        return defaultDefinitionName;
    }

    public IConfigurationElement[] getProperties() {
        IConfigurationElement[] propertyRoot = this.fElement.getChildren(PROPERTIES_ELEMENT_TAG);
        if (propertyRoot != null && propertyRoot.length == 1) {
            IConfigurationElement[] childElements = propertyRoot[0].getChildren(PROPERTY_ELEMENT_TAG);
            return childElements;
        }
        return new IConfigurationElement[0];
    }

    public String getPropertyValue(String propName) {
        String value = "";
        IConfigurationElement[] props = this.getProperties();
        int i = 0;
        while (i < props.length) {
            String id = props[i].getAttribute(ID_ATTRIBUTE);
            if (props[i].getAttribute(NAME_ATTRIBUTE) != null) {
                String name = props[i].getAttribute(NAME_ATTRIBUTE);
                String tempvalue = props[i].getAttribute(VALUE_ATTRIBUTE);
                OverrideTemplateDescriptor[] overrides = OverrideTemplateDescriptor.getByDriverTemplate(this.getId());
                if (overrides != null && overrides.length > 0 && overrides[0].getPropertyValueFromId(id) != null) {
                    tempvalue = overrides[0].getPropertyValueFromId(id);
                }
                if (name.equals(propName)) {
                    value = tempvalue;
                    break;
                }
            }
            ++i;
        }
        return value;
    }

    public String getPropertyValueFromId(String propId) {
        return this.getPropertyAttributeValueByID(propId, VALUE_ATTRIBUTE);
    }

    private String getPropertyAttributeValueByID(String propId, String attribute) {
        String attr_value = new String();
        IConfigurationElement[] props = this.getProperties();
        int i = 0;
        while (i < props.length) {
            if (props[i].getAttribute(ID_ATTRIBUTE) != null && propId.equals(props[i].getAttribute(ID_ATTRIBUTE))) {
                attr_value = props[i].getAttribute(attribute);
                break;
            }
            ++i;
        }
        return attr_value;
    }

    public String getPropertyIDFromName(String propName) {
        String id = new String();
        IConfigurationElement[] props = this.getProperties();
        int i = 0;
        while (i < props.length) {
            if (props[i].getAttribute(NAME_ATTRIBUTE) != null && propName.equals(props[i].getAttribute(NAME_ATTRIBUTE))) {
                id = props[i].getAttribute(ID_ATTRIBUTE);
                break;
            }
            ++i;
        }
        return id;
    }

    public String getDescription() {
        String description = this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        OverrideTemplateDescriptor[] overrides = OverrideTemplateDescriptor.getByDriverTemplate(this.getId());
        if (overrides != null && overrides.length > 0 && overrides[0].getDescription() != null) {
            description = overrides[0].getDescription();
        }
        if (description == null) {
            description = "";
        }
        return description;
    }

    public int compareTo(Object o) {
        if (o instanceof TemplateDescriptor) {
            return Collator.getInstance().compare(this.getName(), ((TemplateDescriptor)o).getName());
        }
        return Integer.MIN_VALUE;
    }

    private static TemplateDescriptor[] createDriverTemplateDescriptors(IConfigurationElement[] elements) {
        ArrayList<TemplateDescriptor> result = new ArrayList<TemplateDescriptor>(5);
        HashSet<String> descIds = new HashSet<String>(5);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (DRIVERTEMPLATE_ELEMENT_TAG.equals(element.getName())) {
                TemplateDescriptor[] desc = new TemplateDescriptor[1];
                SafeRunner.run((ISafeRunnable)new MySafeRunnable(desc, element));
                if (desc[0] != null && !descIds.contains(desc[0].getId())) {
                    result.add(desc[0]);
                    descIds.add(desc[0].getId());
                }
            }
            ++i;
        }
        Collections.sort(result);
        return result.toArray(new TemplateDescriptor[result.size()]);
    }

    public boolean hasVisibleProperties() {
        IConfigurationElement[] templateprops = this.getProperties();
        if (templateprops != null && templateprops.length > 0) {
            int i = 0;
            while (i < templateprops.length) {
                IConfigurationElement prop = templateprops[i];
                String id = prop.getAttribute(ID_ATTRIBUTE);
                String visible = prop.getAttribute("visible");
                OverrideTemplateDescriptor[] overrides = OverrideTemplateDescriptor.getByDriverTemplate(this.getId());
                if (overrides != null && overrides.length > 0 && overrides[0].getPropertyVisibleFromId(id) != null && overrides[0].getPropertyVisibleFromId(id).length() > 0) {
                    visible = overrides[0].getPropertyVisibleFromId(id);
                }
                if (visible == null || visible.equals("true")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TemplateDescriptor) {
            TemplateDescriptor compare = (TemplateDescriptor)obj;
            return this.getId().equals(compare.getId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return super.hashCode();
    }
}

