/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearch;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearchContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.actions.DeleteCaseClauseAction;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseElseClauseElement;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseSearchPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseSearchWhenContentElement;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BuilderUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.DynamicComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.NavigableTableViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CaseSearchTable
extends NavigableTableViewer
implements IMenuListener {
    public static final String P_WHEN = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_WHEN";
    public static final String P_LEFT_EXPRESSION = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_LEFT_EXPRESSION";
    public static final String P_OPERATOR = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_OPERATOR";
    public static final String P_RIGHT_EXPRESSION = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_RIGHT_EXPRESSION";
    public static final String P_ANDOR = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_ANDOR";
    public static final String P_THEN = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_THEN";
    public static final String P_RESULT_EXPRESSION = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_RESULT_EXPRESSION";
    private SQLDomainModel domainModel;
    private SQLQueryObject sqlStatement;
    private DynamicComboBoxCellEditor leftExpressionsComboBoxCellEditor;
    private DynamicComboBoxCellEditor rightExpressionsComboBoxCellEditor;
    private DynamicComboBoxCellEditor resultExpressionsComboBoxCellEditor;
    private ComboBoxCellEditor operatorsComboBoxCellEditor;
    private ComboBoxCellEditor andOrEditor;
    private CaseSearchPage caseSearchPage;
    private Table table;
    private TableColumn c1;
    private TableColumn c2;
    private TableColumn c3;
    private TableColumn c4;
    private TableColumn c5;
    private TableColumn c6;
    private CellEditor[] editors;
    private CellEditor[] editorsForElse;

    CaseSearchTable(CaseSearchPage searchPage, Composite parent, SQLDomainModel domainModel, SQLQueryObject sqlStmt) {
        super(new Table(parent, 65538));
        this.domainModel = domainModel;
        this.sqlStatement = sqlStmt;
        this.caseSearchPage = searchPage;
        this.table = this.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CaseSearchTable.this.refreshCellEditor(CaseSearchTable.this.getTable().getSelectionIndex() >= 0 ? CaseSearchTable.this.getTable().getSelectionIndex() : 0);
            }
        });
        this.c1 = new TableColumn(this.table, 0);
        this.c1.setText("CASE");
        this.leftExpressionsComboBoxCellEditor = new DynamicComboBoxCellEditor((Composite)this.table, null, (Object)this);
        this.c2 = new TableColumn(this.table, 0);
        this.c2.setText(Messages._UI_COLUMN_CASE_SEARCH_EXPRESSION);
        this.operatorsComboBoxCellEditor = new ComboBoxCellEditor((Composite)this.table, null);
        this.c3 = new TableColumn(this.table, 0);
        this.c3.setText(Messages._UI_COLUMN_CASE_SEARCH_OPERATOR);
        this.fillOperatorsComboBox();
        this.rightExpressionsComboBoxCellEditor = new DynamicComboBoxCellEditor((Composite)this.table, null, (Object)this);
        this.c4 = new TableColumn(this.table, 0);
        this.c4.setText(Messages._UI_COLUMN_CASE_SEARCH_EXPRESSION);
        this.andOrEditor = new ComboBoxCellEditor((Composite)this.table, null);
        this.c5 = new TableColumn(this.table, 0);
        this.c5.setText("AND/OR");
        this.fillAndOrComboBox();
        this.resultExpressionsComboBoxCellEditor = new DynamicComboBoxCellEditor((Composite)this.table, null, (Object)this);
        this.c6 = new TableColumn(this.table, 0);
        this.c6.setText("THEN");
        GC gc = new GC((Drawable)Display.getCurrent());
        Point p1 = gc.stringExtent(this.c1.getText());
        Point p5 = gc.stringExtent(this.c5.getText());
        int minWidthC1 = p1.x + 15;
        int minWidthC5 = p5.x + 15;
        if (minWidthC1 <= 0) {
            minWidthC1 = 45;
        }
        if (minWidthC5 <= 0) {
            minWidthC5 = 61;
        }
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(45, false));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(60, false));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(61, false));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(170, true));
        this.table.setLayout((Layout)layout);
        String[] properties = new String[]{P_WHEN, P_LEFT_EXPRESSION, P_OPERATOR, P_RIGHT_EXPRESSION, P_ANDOR, P_RESULT_EXPRESSION};
        this.setColumnProperties(properties);
        this.editors = new CellEditor[6];
        this.editors[0] = null;
        this.editors[1] = this.leftExpressionsComboBoxCellEditor;
        this.editors[2] = this.operatorsComboBoxCellEditor;
        this.editors[3] = this.rightExpressionsComboBoxCellEditor;
        this.editors[4] = this.andOrEditor;
        this.editors[5] = this.resultExpressionsComboBoxCellEditor;
        this.editorsForElse = new CellEditor[6];
        this.editorsForElse[0] = null;
        this.editorsForElse[1] = this.leftExpressionsComboBoxCellEditor;
        this.editorsForElse[2] = null;
        this.editorsForElse[3] = null;
        this.editorsForElse[4] = null;
        this.editorsForElse[5] = null;
        this.setCellEditors(this.editors);
        this.setCellModifier(new CaseSearchTableCellModifier(this));
        this.setLabelProvider((IBaseLabelProvider)new CaseSearchTableLabelProvider());
        this.setContentProvider((IContentProvider)new CaseSearchTableContentProvider());
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public CaseSearchPage getCaseSearchPage() {
        return this.caseSearchPage;
    }

    public SQLDomainModel getDomainModel() {
        return this.domainModel;
    }

    public SQLQueryObject getSQLStatement() {
        return this.sqlStatement;
    }

    public void refresh() {
        super.refresh();
    }

    public void refreshCellEditor(int row) {
        boolean leftExistsExpression = false;
        boolean rightExistsExpression = false;
        boolean resultExistsExpression = false;
        boolean elseExistsExpression = false;
        Object obj = this.getElementAt(row);
        if (obj instanceof CaseSearchWhenContentElement) {
            Object left = ((CaseSearchWhenContentElement)obj).getLeft();
            Object right = ((CaseSearchWhenContentElement)obj).getRight();
            Object result = ((CaseSearchWhenContentElement)obj).getResult();
            if (left instanceof QueryValueExpression) {
                leftExistsExpression = true;
                TableItem titem = this.table.getItem(row);
                String opr = titem.getText(2);
                if (left instanceof ValueExpressionColumn) {
                    if (opr.equalsIgnoreCase("") || opr.equalsIgnoreCase("=") || opr.equalsIgnoreCase("<") || opr.equalsIgnoreCase("<=") || opr.equalsIgnoreCase(">") || opr.equalsIgnoreCase(">=") || opr.equalsIgnoreCase("<>") || opr.equalsIgnoreCase("LIKE") || opr.equalsIgnoreCase("NOT LIKE")) {
                        this.rightExpressionsComboBoxCellEditor.setNeedQuotes(true);
                    } else {
                        this.rightExpressionsComboBoxCellEditor.setNeedQuotes(false);
                    }
                    ValueExpressionColumn sce = (ValueExpressionColumn)left;
                    this.rightExpressionsComboBoxCellEditor.setPairDataType(sce.getDataType());
                } else {
                    this.rightExpressionsComboBoxCellEditor.setNeedQuotes(false);
                }
            }
            if (right instanceof QueryValueExpression) {
                rightExistsExpression = true;
            }
            if (result instanceof QueryValueExpression) {
                resultExistsExpression = true;
            }
            BuilderUtility.fillColumnComboBox(this.leftExpressionsComboBoxCellEditor, this.sqlStatement, true, leftExistsExpression);
            BuilderUtility.fillColumnComboBox(this.rightExpressionsComboBoxCellEditor, this.sqlStatement, true, rightExistsExpression);
            BuilderUtility.fillColumnComboBox(this.resultExpressionsComboBoxCellEditor, this.sqlStatement, true, resultExistsExpression);
            this.editors[0] = null;
            this.editors[1] = this.leftExpressionsComboBoxCellEditor;
            this.editors[2] = this.operatorsComboBoxCellEditor;
            this.editors[3] = this.rightExpressionsComboBoxCellEditor;
            this.editors[4] = this.andOrEditor;
            this.editors[5] = this.resultExpressionsComboBoxCellEditor;
            this.setCellEditors(this.editors);
        } else if (obj instanceof CaseElseClauseElement) {
            Object expr = ((CaseElseClauseElement)obj).getResult();
            if (expr instanceof QueryValueExpression) {
                elseExistsExpression = true;
            }
            BuilderUtility.fillColumnComboBox(this.leftExpressionsComboBoxCellEditor, this.sqlStatement, true, elseExistsExpression);
            this.editorsForElse[0] = null;
            this.editorsForElse[1] = this.leftExpressionsComboBoxCellEditor;
            this.editorsForElse[2] = null;
            this.editorsForElse[3] = null;
            this.editorsForElse[4] = null;
            this.editorsForElse[5] = null;
            this.setCellEditors(this.editorsForElse);
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        DeleteCaseClauseAction deleteCaseClauseAction = new DeleteCaseClauseAction(this, this.caseSearchPage);
        if (this.table.getSelectionCount() > 0) {
            TableItem tableItem = this.table.getSelection()[0];
            Object data = tableItem.getData();
            if (data instanceof CaseSearchWhenContentElement) {
                CaseSearchWhenContentElement contentElement = (CaseSearchWhenContentElement)data;
                if (contentElement.getFirstClause()) {
                    deleteCaseClauseAction.setText(Messages._UI_ACTION_DELETE_WHEN_CLAUSE_SEARCH);
                } else {
                    deleteCaseClauseAction.setText(Messages._UI_ACTION_DELETE_SEARCH_CONDITION);
                }
            } else if (data instanceof CaseElseClauseElement) {
                deleteCaseClauseAction.setText(Messages._UI_ACTION_DELETE_ELSE_EXPRESSION_SEARCH);
            }
        }
        menu.add((IAction)deleteCaseClauseAction);
    }

    private void fillOperatorsComboBox() {
        LabelValuePair[] operatorItems = new LabelValuePair[]{new LabelValuePair("", ""), new LabelValuePair("=", "="), new LabelValuePair("<", "<"), new LabelValuePair("<=", "<="), new LabelValuePair(">", ">"), new LabelValuePair(">=", ">="), new LabelValuePair("<>", "<>"), new LabelValuePair("BETWEEN", "BETWEEN"), new LabelValuePair("NOT BETWEEN", "NOT BETWEEN"), new LabelValuePair("IS NULL", "IS NULL"), new LabelValuePair("IS NOT NULL", "IS NOT NULL"), new LabelValuePair("LIKE", "LIKE"), new LabelValuePair("NOT LIKE", "NOT LIKE"), new LabelValuePair("IN", "IN"), new LabelValuePair("NOT IN", "NOT IN"), new LabelValuePair("EXISTS", "EXISTS")};
        this.operatorsComboBoxCellEditor.createItems(operatorItems);
    }

    protected void fillAndOrComboBox() {
        LabelValuePair[] andOrItems = new LabelValuePair[]{new LabelValuePair("", ""), new LabelValuePair("AND", "AND"), new LabelValuePair("OR", "OR")};
        this.andOrEditor.createItems(andOrItems);
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
    }

    public class CaseSearchTableCellModifier
    implements ICellModifier {
        CaseSearchTable viewer;
        Object currentElement;
        Object currentValue;
        String currentProperty;
        CaseSearchWhenContentElement contentElement;
        CaseElseClauseElement elseElement;
        QueryValueExpression expr;

        public CaseSearchTableCellModifier(CaseSearchTable viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return property.equals(CaseSearchTable.P_LEFT_EXPRESSION) || property.equals(CaseSearchTable.P_OPERATOR) || property.equals(CaseSearchTable.P_RIGHT_EXPRESSION) || property.equals(CaseSearchTable.P_ANDOR) || property.equals(CaseSearchTable.P_RESULT_EXPRESSION);
        }

        public Object getValue(Object element, String property) {
            return element;
        }

        public void modify(Object element, String property, Object value) {
            this.currentElement = element;
            this.currentProperty = property;
            this.currentValue = value;
            if (property.equals(CaseSearchTable.P_LEFT_EXPRESSION) || property.equals(CaseSearchTable.P_RIGHT_EXPRESSION) || property.equals(CaseSearchTable.P_RESULT_EXPRESSION)) {
                Assert.isTrue((boolean)(this.currentElement instanceof TableItem));
                Object data = ((TableItem)this.currentElement).getData();
                if (this.currentValue == null) {
                    return;
                }
                if (data instanceof CaseSearchWhenContentElement) {
                    this.contentElement = (CaseSearchWhenContentElement)data;
                    if (this.currentValue instanceof QueryValueExpression) {
                        this.expr = this.currentValue instanceof ValueExpressionColumn ? ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)this.currentValue) : (this.currentValue instanceof ValueExpressionSimple ? (ValueExpressionSimple)this.currentValue : (QueryValueExpression)this.currentValue);
                        if (property.equals(CaseSearchTable.P_LEFT_EXPRESSION)) {
                            this.contentElement.setLeftExpression(this.expr);
                        } else if (property.equals(CaseSearchTable.P_RIGHT_EXPRESSION)) {
                            this.contentElement.setRightExpression(this.expr);
                        } else if (property.equals(CaseSearchTable.P_RESULT_EXPRESSION)) {
                            this.contentElement.setResultExpression(this.expr);
                        }
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                CaseSearchTableCellModifier.this.viewer.refresh();
                            }
                        });
                        CaseSearchTable.this.getCaseSearchPage().updateFinishButton();
                    } else if (this.currentValue instanceof String) {
                        String valueString = (String)this.currentValue;
                        if (this.contentElement.getPredicate() == null) {
                            this.contentElement.createSearchCondition();
                        }
                        Object currExpr = null;
                        if (property.equals(CaseSearchTable.P_LEFT_EXPRESSION)) {
                            currExpr = this.contentElement.getLeft();
                        } else if (property.equals(CaseSearchTable.P_RIGHT_EXPRESSION)) {
                            currExpr = this.contentElement.getRight();
                        } else if (property.equals(CaseSearchTable.P_RESULT_EXPRESSION)) {
                            currExpr = this.contentElement.getResult();
                        }
                        CaseSearchTable.this.getCaseSearchPage().setElementToUpdate(this.contentElement);
                        if (valueString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                            ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(CaseSearchTable.this.getDomainModel(), CaseSearchTable.this.getSQLStatement());
                            if (valueString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                                wizard.setInputExpression(null);
                            } else if (valueString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
                                wizard.setInputExpression((QueryValueExpression)currExpr);
                            }
                            wizard.setIsColumn(false);
                            ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
                            dialog.create();
                            dialog.setBlockOnOpen(true);
                            int result = dialog.open();
                            QueryValueExpression newExpr = null;
                            if (result == 0) {
                                newExpr = wizard.getSQLExpression();
                            }
                            if (newExpr != null) {
                                if (property.equals(CaseSearchTable.P_LEFT_EXPRESSION)) {
                                    this.contentElement.setLeftExpression(newExpr);
                                } else if (property.equals(CaseSearchTable.P_RIGHT_EXPRESSION)) {
                                    this.contentElement.setRightExpression(newExpr);
                                } else if (property.equals(CaseSearchTable.P_RESULT_EXPRESSION)) {
                                    this.contentElement.setResultExpression(newExpr);
                                }
                                Display.getCurrent().asyncExec(new Runnable(){

                                    public void run() {
                                        CaseSearchTableCellModifier.this.viewer.refresh();
                                    }
                                });
                            }
                            CaseSearchTable.this.getCaseSearchPage().updateFinishButton();
                        }
                    }
                } else if (data instanceof CaseElseClauseElement) {
                    this.elseElement = (CaseElseClauseElement)data;
                    if (this.currentValue instanceof QueryValueExpression) {
                        this.expr = this.currentValue instanceof ValueExpressionColumn ? ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)this.currentValue) : (this.currentValue instanceof ValueExpressionSimple ? (ValueExpressionSimple)this.currentValue : (QueryValueExpression)this.currentValue);
                        if (property.equals(CaseSearchTable.P_LEFT_EXPRESSION)) {
                            this.elseElement.setResult(this.expr);
                        }
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                CaseSearchTableCellModifier.this.viewer.refresh();
                            }
                        });
                        CaseSearchTable.this.getCaseSearchPage().updateFinishButton();
                    } else if (this.currentValue instanceof String) {
                        String valueString = (String)this.currentValue;
                        Object currExpr = null;
                        if (property.equals(CaseSearchTable.P_LEFT_EXPRESSION)) {
                            currExpr = this.elseElement.getResult();
                        }
                        CaseSearchTable.this.getCaseSearchPage().setElementToUpdate(this.contentElement);
                        if (valueString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                            ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(CaseSearchTable.this.getDomainModel(), CaseSearchTable.this.getSQLStatement());
                            if (valueString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                                wizard.setInputExpression(null);
                            } else if (valueString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
                                wizard.setInputExpression((QueryValueExpression)currExpr);
                            }
                            wizard.setIsColumn(false);
                            ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
                            dialog.create();
                            dialog.setBlockOnOpen(true);
                            int result = dialog.open();
                            QueryValueExpression newExpr = null;
                            if (result == 0) {
                                newExpr = wizard.getSQLExpression();
                            }
                            if (newExpr != null) {
                                if (property.equals(CaseSearchTable.P_LEFT_EXPRESSION)) {
                                    this.elseElement.setResult(newExpr);
                                }
                                Display.getCurrent().asyncExec(new Runnable(){

                                    public void run() {
                                        CaseSearchTableCellModifier.this.viewer.refresh();
                                    }
                                });
                            }
                            CaseSearchTable.this.getCaseSearchPage().updateFinishButton();
                        }
                    }
                }
            } else if (property.equals(CaseSearchTable.P_OPERATOR)) {
                Assert.isTrue((boolean)(element instanceof TableItem));
                Object data = ((TableItem)this.currentElement).getData();
                if (this.currentValue == null) {
                    return;
                }
                if (data instanceof CaseSearchWhenContentElement) {
                    this.contentElement = (CaseSearchWhenContentElement)data;
                    if (this.currentValue instanceof String) {
                        this.contentElement.setOperator((String)this.currentValue);
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                CaseSearchTableCellModifier.this.viewer.refresh();
                            }
                        });
                        CaseSearchTable.this.getCaseSearchPage().updateFinishButton();
                    }
                }
            } else if (property.equals(CaseSearchTable.P_ANDOR)) {
                Assert.isTrue((boolean)(element instanceof TableItem));
                Object data = ((TableItem)this.currentElement).getData();
                if (this.currentValue == null) {
                    return;
                }
                if (data instanceof CaseSearchWhenContentElement) {
                    this.contentElement = (CaseSearchWhenContentElement)data;
                    if (this.currentValue instanceof String) {
                        if (!((String)this.currentValue).equals("")) {
                            this.contentElement.setAndOr(this.currentValue);
                            Display.getCurrent().asyncExec(new Runnable(){

                                public void run() {
                                    CaseSearchTableCellModifier.this.viewer.refresh();
                                }
                            });
                        }
                        CaseSearchTable.this.getCaseSearchPage().updateFinishButton();
                    }
                }
            }
        }
    }

    public class CaseSearchTableContentProvider
    implements IStructuredContentProvider {
        protected Vector tableElements;
        protected ValueExpressionCaseSearch sqlCaseSearch;
        protected boolean firstClause;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public Object[] getElements(Object property) {
            if (property instanceof ValueExpressionCaseSearch) {
                this.tableElements = new Vector();
                this.sqlCaseSearch = (ValueExpressionCaseSearch)property;
                Iterator e = this.sqlCaseSearch.getSearchContentList().iterator();
                ValueExpressionCaseSearchContent content = null;
                QuerySearchCondition searchCondition = null;
                int clauseNumber = 0;
                while (e.hasNext()) {
                    content = (ValueExpressionCaseSearchContent)e.next();
                    searchCondition = content.getSearchCondition();
                    this.firstClause = true;
                    this.getAllPredicates(property, content, searchCondition, clauseNumber);
                    if (searchCondition == null) {
                        this.createNewContentElement(content, null, clauseNumber);
                    }
                    ++clauseNumber;
                }
                if (this.sqlCaseSearch.getCaseElse() != null) {
                    this.createCaseElseClauseElement();
                }
                CaseSearchTable.this.getCaseSearchPage().updateFinishButton();
                return this.tableElements.toArray();
            }
            return null;
        }

        private void getAllPredicates(Object property, ValueExpressionCaseSearchContent content, QuerySearchCondition cond, int clauseNumber) {
            if (cond instanceof Predicate) {
                this.createNewContentElement(content, (Predicate)cond, clauseNumber);
                this.firstClause = false;
            } else if (cond instanceof SearchConditionCombined) {
                QuerySearchCondition left = ((SearchConditionCombined)cond).getLeftCondition();
                this.getAllPredicates(property, content, left, clauseNumber);
                QuerySearchCondition right = ((SearchConditionCombined)cond).getRightCondition();
                this.getAllPredicates(property, content, right, clauseNumber);
            }
        }

        private void createNewContentElement(ValueExpressionCaseSearchContent content, Predicate predicate, int clauseNumber) {
            this.tableElements.add(new CaseSearchWhenContentElement(CaseSearchTable.this.getDomainModel(), CaseSearchTable.this.getSQLStatement(), this.sqlCaseSearch, content, predicate, clauseNumber, this.firstClause));
        }

        private void createCaseElseClauseElement() {
            this.tableElements.add(new CaseElseClauseElement(this.sqlCaseSearch));
        }
    }

    class CaseSearchTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        CaseSearchTableLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof CaseSearchWhenContentElement) {
                CaseSearchWhenContentElement contentElement = (CaseSearchWhenContentElement)object;
                return contentElement.getColumnText(columnIndex);
            }
            if (object instanceof CaseElseClauseElement) {
                CaseElseClauseElement elseElement = (CaseElseClauseElement)object;
                return elseElement.getColumnText(columnIndex);
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }
}

