/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.msft.internal.sqlserver.ddl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.core.rte.fe.GenericDdlGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCProcedure;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCUserDefinedFunction;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCView;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.ddl.SqlServer2000DdlBuilder;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.ddl.SqlServerDdlScript;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.models.SQLServerJdbcIndex;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.models.SQLServerTrigger;
import org.eclipse.datatools.modelbase.sql.constraints.Assertion;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;

public class SqlServer2000DdlGenerator
extends GenericDdlGenerator {
    private SqlServer2000DdlBuilder builder = new SqlServer2000DdlBuilder();

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor) {
        return super.generateDDL(elements, progressMonitor);
    }

    protected String[] dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        SqlServerDdlScript script = new SqlServerDdlScript();
        EngineeringOption[] options = this.getSelectedOptions(elements);
        HashSet allElements = this.getAllContainedDisplayableElementSet(elements);
        this.builder.setElements(allElements);
        allElements = new HashSet(allElements);
        this.filterElements(allElements);
        try {
            for (Object o : allElements) {
                String statement;
                if (o instanceof PersistentTable) {
                    if (!this.generateTables(options) || (statement = this.builder.dropTable((BaseTable)((PersistentTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addDropTableStatement(statement);
                    continue;
                }
                if (o instanceof ViewTable) {
                    if (!this.generateViews(options) || (statement = this.builder.dropView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addDropViewStatement(statement);
                    continue;
                }
                if (o instanceof Trigger) {
                    if (!this.generateTriggers(options) || (statement = this.builder.dropTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addDropTriggerStatement(statement);
                    continue;
                }
                if (o instanceof CheckConstraint) {
                    if (!this.generateCKConstraints(options) || (statement = this.builder.dropTableConstraint((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addAlterTableDropConstraintStatement(statement);
                    continue;
                }
                if (o instanceof UniqueConstraint) {
                    if (!this.generatePKConstraints(options) || this.builder.isImplicitConstraint((TableConstraint)((UniqueConstraint)o)) || (statement = this.builder.dropTableConstraint((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addAlterTableDropConstraintStatement(statement);
                    continue;
                }
                if (o instanceof ForeignKey) {
                    if (!this.generateFKConstraints(options) || this.builder.isImplicitConstraint((TableConstraint)((ForeignKey)o)) || (statement = this.builder.dropTableConstraint((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addAlterTableDropForeignKeyStatement(statement);
                    continue;
                }
                if (o instanceof Index) {
                    if (!this.generateIndexes(options)) continue;
                    if (((SQLServerJdbcIndex)((Object)o)).isUniqueConstraint()) {
                        statement = this.builder.dropTableConstraint((Index)o, quoteIdentifiers, qualifyNames);
                        if (statement == null) continue;
                        script.addAlterTableDropConstraintStatement(statement);
                        continue;
                    }
                    statement = this.builder.dropIndex((Index)o, quoteIdentifiers, qualifyNames);
                    if (statement == null) continue;
                    script.addDropIndexStatement(statement);
                    continue;
                }
                if (o instanceof Procedure) {
                    if (!this.generateStoredProcedures(options) || (statement = this.builder.dropProcedure((Procedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addDropStoredProcedureStatement(statement);
                    continue;
                }
                if (o instanceof UserDefinedFunction) {
                    if (!this.generateFunctions(options) || (statement = this.builder.dropFunction((UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addDropUserDefinedFunctionStatement(statement);
                    continue;
                }
                if (o instanceof Schema) {
                    if (!this.generateSchemas(options) || (statement = this.builder.dropSchema((Schema)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addDropSchemaStatement(statement);
                    continue;
                }
                if (o instanceof UserDefinedType) {
                    if (!this.generateUserDefinedTypes(options) || (statement = this.builder.dropUserDefinedType((UserDefinedType)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addDropUserDefinedTypeStatement(statement);
                    continue;
                }
                if (!(o instanceof Assertion) || !this.generateAssertions(options) || (statement = this.builder.dropAssertion((Assertion)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropAssertionStatement(statement);
            }
        }
        finally {
            this.builder.clear();
        }
        return script.getStatements();
    }

    protected String[] createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        SqlServerDdlScript script = new SqlServerDdlScript();
        EngineeringOption[] options = this.getSelectedOptions(elements);
        HashSet allElements = this.getAllContainedDisplayableElementSet(elements);
        this.builder.setElements(allElements);
        allElements = new HashSet(allElements);
        this.filterElements(allElements);
        try {
            String[] setOptions = this.builder.createSetOptions(elements);
            int i = 0;
            while (i < setOptions.length) {
                script.addSetOptionStatement(setOptions[i]);
                ++i;
            }
            for (Object o : allElements) {
                String statement;
                if (o instanceof TableConstraint && allElements.contains(((TableConstraint)o).getBaseTable())) continue;
                if (o instanceof PersistentTable) {
                    if (!this.generateTables(options) || (statement = this.builder.createTable((BaseTable)((PersistentTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addCreateTableStatement(statement);
                    continue;
                }
                if (o instanceof ViewTable) {
                    if (!this.generateViews(options)) continue;
                    statement = null;
                    if (o instanceof JDBCView) {
                        statement = this.executeQuery(((JDBCView)o).getConnection(), ((JDBCView)o).getName());
                    }
                    if (statement == null) continue;
                    script.addCreateViewStatement(statement);
                    continue;
                }
                if (o instanceof Trigger) {
                    if (!this.generateTriggers(options) || (statement = this.executeQuery(((SQLServerTrigger)((Object)o)).getConnection(), ((SQLServerTrigger)((Object)o)).getName())) == null) continue;
                    script.addCreateTriggerStatement(statement);
                    continue;
                }
                if (o instanceof CheckConstraint) {
                    if (!this.generateCKConstraints(options) || (statement = this.builder.addCheckConstraint((CheckConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addAlterTableAddConstraintStatement(statement);
                    continue;
                }
                if (o instanceof UniqueConstraint) {
                    if (!this.generatePKConstraints(options) || this.builder.isImplicitConstraint((TableConstraint)((UniqueConstraint)o)) || (statement = this.builder.addUniqueConstraint((UniqueConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addAlterTableAddConstraintStatement(statement);
                    continue;
                }
                if (o instanceof ForeignKey) {
                    if (!this.generateFKConstraints(options) || this.builder.isImplicitConstraint((TableConstraint)((ForeignKey)o)) || (statement = this.builder.addForeignKey((ForeignKey)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addAlterTableAddForeignKeyStatement(statement);
                    continue;
                }
                if (o instanceof Index) {
                    if (!this.generateIndexes(options)) continue;
                    if (((SQLServerJdbcIndex)((Object)o)).isUniqueConstraint()) {
                        statement = this.builder.addUniqueConstraint((Index)o, quoteIdentifiers, qualifyNames);
                        if (statement == null) continue;
                        script.addAlterTableAddConstraintStatement(statement);
                        continue;
                    }
                    statement = this.builder.createIndex((Index)o, quoteIdentifiers, qualifyNames);
                    if (statement == null) continue;
                    script.addCreateIndexStatement(statement);
                    continue;
                }
                if (o instanceof Procedure) {
                    if (!this.generateStoredProcedures(options)) continue;
                    statement = null;
                    if (o instanceof JDBCProcedure) {
                        statement = this.builder.createProcedure((Procedure)((JDBCProcedure)o), quoteIdentifiers, qualifyNames);
                    }
                    if (statement == null) continue;
                    script.addCreateStoredProcedureStatement(statement);
                    continue;
                }
                if (o instanceof UserDefinedFunction) {
                    if (!this.generateFunctions(options)) continue;
                    statement = null;
                    if (o instanceof JDBCUserDefinedFunction) {
                        statement = this.executeQuery(((JDBCUserDefinedFunction)o).getConnection(), ((JDBCUserDefinedFunction)o).getName());
                    }
                    if (statement == null) continue;
                    script.addCreateUserDefinedFunctionStatement(statement);
                    continue;
                }
                if (o instanceof Schema) {
                    if (!this.generateSchemas(options) || (statement = this.builder.createSchema((Schema)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addCreateSchemaStatement(statement);
                    continue;
                }
                if (o instanceof UserDefinedType) {
                    if (!this.generateUserDefinedTypes(options) || (statement = this.builder.createUserDefinedType((UserDefinedType)o, quoteIdentifiers, qualifyNames)) == null) continue;
                    script.addCreateUserDefinedTypeStatement(statement);
                    continue;
                }
                if (!(o instanceof Assertion) || !this.generateAssertions(options) || (statement = this.builder.createAssertion((Assertion)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateAssertionStatement(statement);
            }
            String[] unsetOptions = this.builder.createUnsetOptions(elements);
            int i2 = 0;
            while (i2 < unsetOptions.length) {
                script.addUnsetOptionStatement(unsetOptions[i2]);
                ++i2;
            }
        }
        finally {
            this.builder.clear();
        }
        return script.getStatements();
    }

    private void filterElements(Set allElements) {
        Iterator toFilter = allElements.iterator();
        while (toFilter.hasNext()) {
            Object obj = toFilter.next();
            if (!(obj instanceof Index)) continue;
            ReferenceConstraint constr = this.builder.findConstraintByIndex((Index)obj);
            if (constr != null) {
                toFilter.remove();
                continue;
            }
            if (!((SQLServerJdbcIndex)((Object)obj)).isPrimaryKey()) continue;
            toFilter.remove();
        }
    }

    private String executeQuery(Connection connection, String name) {
        try {
            PreparedStatement stmt = connection.prepareStatement("execute sp_helptext ?");
            stmt.setString(1, name);
            ResultSet r = stmt.executeQuery();
            StringBuffer statement = new StringBuffer();
            while (r.next()) {
                statement.append(r.getString(1));
            }
            return statement.toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

