/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasePrivilege;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasesqlmodelFactory;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class AuthorizedObjectPrivilegeASALoader {
    protected SQLObject object;
    protected Connection conn;
    protected ICatalogObject catalogObj;

    public AuthorizedObjectPrivilegeASALoader(SQLObject catalogAuthId) {
        this.object = catalogAuthId;
        this.catalogObj = (ICatalogObject)catalogAuthId;
        this.conn = this.catalogObj.getConnection();
    }

    public final void loadPrivilegs(EList privileges) {
        boolean deliver = this.object.eDeliver();
        this.object.eSetDeliver(false);
        privileges.clear();
        if (this.object instanceof Table) {
            this.loadTablePrivilegs((List)privileges);
        } else if (this.object instanceof Routine) {
            this.loadRoutinePrivileges((List)privileges);
        }
        this.object.eSetDeliver(deliver);
    }

    public HashMap loadTableColumnPrivilege() {
        HashMap<String, ArrayList<SybasePrivilege>> privileges;
        block12: {
            privileges = new HashMap<String, ArrayList<SybasePrivilege>>();
            Table table = ((Column)this.object).getTable();
            Schema schema = table.getSchema();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = this.conn.prepareStatement("select P.privilege_type,P.is_grantable,Grantor=G.user_name,Grantee=E.user_name, trim(C.column_name) from sys.systable as T,sys.SYSUSERPERMS as U,sys.syscolperm as P,sys.sysuserperms as E,sys.syscolumn as C,sysuserperms as G where U.user_name = ? and T.table_name = ? and T.creator = U.user_id and G.user_id = P.grantor and C.column_id = P.column_id and P.table_id = T.table_id and P.grantee = E.user_id and C.table_id = T.table_id");
                    stmt.setString(1, schema.getName());
                    stmt.setString(2, table.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        int privilegeType = rs.getInt(1);
                        boolean isGrantable = rs.getString(2).equals("Y");
                        String grantorName = rs.getString(3);
                        String granteeName = rs.getString(4);
                        String columnName = rs.getString(5);
                        SybasePrivilege p = SybasesqlmodelFactory.eINSTANCE.createSybasePrivilege();
                        AuthorizationIdentifier grantor = (AuthorizationIdentifier)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getAuthorizationIds(), grantorName.trim());
                        AuthorizationIdentifier grantee = (AuthorizationIdentifier)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getAuthorizationIds(), granteeName.trim());
                        String action = null;
                        switch (privilegeType) {
                            case 1: {
                                action = "select";
                                break;
                            }
                            case 8: {
                                action = "update";
                                break;
                            }
                            case 16: {
                                action = "reference";
                            }
                        }
                        p.setAction(action);
                        p.setGrantable(isGrantable);
                        p.setGrantor(grantor);
                        p.setGrantee(grantee);
                        ArrayList<SybasePrivilege> privilegeList = (ArrayList<SybasePrivilege>)privileges.get(columnName);
                        if (privilegeList == null) {
                            privilegeList = new ArrayList<SybasePrivilege>();
                            privileges.put(columnName, privilegeList);
                        }
                        privilegeList.add(p);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
        return privileges;
    }

    protected void loadRoutinePrivileges(List privileges) {
        block6: {
            Routine r = (Routine)this.object;
            Schema schema = r.getSchema();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = this.conn.prepareStatement("select executeauth=IFNULL(P.grantee,'N','Y'),Grantee=E.user_name from SYS.SYSPROCEDURE as F,SYS.SYSUSERPERMS as U,SYS.SYSUSERPERMS as E,SYS.SYSPROCPERM as P where U.user_name = ? and F.proc_name = ? and U.user_id = F.creator and P.proc_id = F.proc_id and P.grantee = E.user_id order by E.user_name asc");
                    stmt.setString(1, schema.getName());
                    stmt.setString(2, r.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        boolean isExcutable = rs.getString(1).equals("Y");
                        String granteeName = rs.getString(2);
                        if (!isExcutable) continue;
                        SybasePrivilege p = SybasesqlmodelFactory.eINSTANCE.createSybasePrivilege();
                        AuthorizationIdentifier grantee = (AuthorizationIdentifier)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getAuthorizationIds(), granteeName.trim());
                        p.setAction("execute");
                        p.setGrantee(grantee);
                        privileges.add(p);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
    }

    protected void loadTablePrivilegs(List privileges) {
        block11: {
            Table table = (Table)this.object;
            Schema schema = table.getSchema();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = this.conn.prepareStatement("select P.selectauth,P.insertauth,P.deleteauth,P.updateauth,P.alterauth,P.referenceauth,Grantor=G.user_name,P.updatecols,P.stable_id,Grantee=E.user_name from SYS.SYSTABLEPERM as P,SYS.SYSUSERPERMS as E,SYS.SYSTABLE as T,SYS.SYSUSERPERMS as G,SYS.SYSUSERPERMS as U where U.user_name = ? and T.table_name = ? and P.stable_id = T.table_id and P.grantee = E.user_id and P.grantor = G.user_id and U.user_id = T.creator order by E.user_name asc");
                    stmt.setString(1, schema.getName());
                    stmt.setString(2, table.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        Privilege p;
                        char selectAuth = SybaseASACatalogUtils.getCharValue(rs.getString(1));
                        char insertAuth = SybaseASACatalogUtils.getCharValue(rs.getString(2));
                        char deleteAuth = SybaseASACatalogUtils.getCharValue(rs.getString(3));
                        char updateAuth = SybaseASACatalogUtils.getCharValue(rs.getString(4));
                        char alterAuth = SybaseASACatalogUtils.getCharValue(rs.getString(5));
                        char referenceAuth = SybaseASACatalogUtils.getCharValue(rs.getString(6));
                        String grantorName = rs.getString(7);
                        SybaseASACatalogUtils.getCharValue(rs.getString(8));
                        String granteeName = rs.getString(10);
                        AuthorizationIdentifier grantor = (AuthorizationIdentifier)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getAuthorizationIds(), grantorName.trim());
                        AuthorizationIdentifier grantee = (AuthorizationIdentifier)SybaseASACatalogUtils.findElement((Collection)this.catalogObj.getCatalogDatabase().getAuthorizationIds(), granteeName.trim());
                        Table obj = table;
                        if (selectAuth == 'Y' || selectAuth == 'G') {
                            p = this.createTablePrivilege(selectAuth, "select", grantor, grantee, (SQLObject)obj);
                            privileges.add(p);
                        }
                        if (insertAuth == 'Y' || insertAuth == 'G') {
                            p = this.createTablePrivilege(insertAuth, "insert", grantor, grantee, (SQLObject)obj);
                            privileges.add(p);
                        }
                        if (deleteAuth == 'Y' || deleteAuth == 'G') {
                            p = this.createTablePrivilege(deleteAuth, "delete", grantor, grantee, (SQLObject)obj);
                            privileges.add(p);
                        }
                        if (updateAuth == 'Y' || updateAuth == 'G') {
                            p = this.createTablePrivilege(updateAuth, "update", grantor, grantee, (SQLObject)obj);
                            privileges.add(p);
                        }
                        if (alterAuth == 'Y' || alterAuth == 'G') {
                            p = this.createTablePrivilege(alterAuth, "alter", grantor, grantee, (SQLObject)obj);
                            privileges.add(p);
                        }
                        if (referenceAuth != 'Y' && referenceAuth != 'G') continue;
                        p = this.createTablePrivilege(referenceAuth, "reference", grantor, grantee, (SQLObject)obj);
                        privileges.add(p);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
    }

    private Privilege createTablePrivilege(char authChar, String action, AuthorizationIdentifier grantor, AuthorizationIdentifier grantee, SQLObject obj) {
        SybasePrivilege result = SybasesqlmodelFactory.eINSTANCE.createSybasePrivilege();
        result.setGrantable(authChar == 'G');
        result.setAction(action);
        result.setGrantor(grantor);
        result.setGrantee(grantee);
        return result;
    }
}

