/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultSetViewerDescriptor;
import org.eclipse.datatools.sqltools.result.ui.ExternalResultSetViewerProvider;

public class ResultSetViewerRegistryReader {
    public static final String EXTERNAL_RESULT_VIEWER = "org.eclipse.datatools.sqltools.result.ui.resultSetViewer";
    public static final String EXTERNAL_RESULT_VIEWER_CLASS = "class";
    public static final String EXTERNAL_RESULT_VIEWER_VENDOR = "vendor";
    public static final String EXTERNAL_RESULT_VIEWER_ID = "id";
    public static final String EXTERNAL_RESULT_VIEWER_DEFAULTVIEWER = "default_viewer_name";
    private static ResultSetViewerRegistryReader myInstance;
    private List myViewers;

    private ResultSetViewerRegistryReader() {
    }

    public static synchronized ResultSetViewerRegistryReader getInstance() {
        if (myInstance == null) {
            myInstance = new ResultSetViewerRegistryReader();
        }
        return myInstance;
    }

    public synchronized List getResultSetViewers() {
        if (this.myViewers == null) {
            this.myViewers = new ArrayList();
            this.retrieveViewers();
        }
        return this.myViewers;
    }

    public ExternalResultSetViewerProvider getResultSetViewerExecutable(String viewerName) {
        ExternalResultSetViewerProvider exe = null;
        List viewers = this.getResultSetViewers();
        if (viewerName != null) {
            for (ResultSetViewerDescriptor desc : viewers) {
                if (!viewerName.equalsIgnoreCase(desc.getViewerID())) continue;
                exe = desc.getViewerProvider();
                break;
            }
        }
        return exe;
    }

    private void retrieveViewers() {
        try {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTERNAL_RESULT_VIEWER);
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension ext = extensions[i];
                    IConfigurationElement[] configElements = ext.getConfigurationElements();
                    int config = 0;
                    while (config < configElements.length) {
                        ExternalResultSetViewerProvider viewer = (ExternalResultSetViewerProvider)configElements[config].createExecutableExtension(EXTERNAL_RESULT_VIEWER_CLASS);
                        String vendor = configElements[config].getAttribute(EXTERNAL_RESULT_VIEWER_VENDOR);
                        String id = configElements[config].getAttribute(EXTERNAL_RESULT_VIEWER_ID);
                        String defaultViewerName = configElements[config].getAttribute(EXTERNAL_RESULT_VIEWER_DEFAULTVIEWER);
                        ResultSetViewerDescriptor descriptor = new ResultSetViewerDescriptor(viewer, vendor, id, defaultViewerName);
                        this.myViewers.add(descriptor);
                        ++config;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }
}

