/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.modelvalidity;

import org.eclipse.datatools.modelbase.sql.datatypes.BinaryStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.BooleanDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.IntegerDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.IntervalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.NumberDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.NumericalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.XMLDataType;
import org.eclipse.datatools.sqltools.core.modelvalidity.ISQLDataOfflineValidator;
import org.eclipse.datatools.sqltools.core.modelvalidity.Messages;

public class DefaultSQLDataOfflineValidator
implements ISQLDataOfflineValidator {
    public String validate(DataType type, String strValue) {
        if (type instanceof PredefinedDataType) {
            if (type instanceof BooleanDataType) {
                return this.validateBooleanDataType(type, strValue);
            }
            if (type instanceof CharacterStringDataType) {
                return this.validateCharacterStringDataType(type, strValue);
            }
            if (type instanceof DateDataType) {
                return this.validateDateDataType(type, strValue);
            }
            if (type instanceof IntervalDataType) {
                return this.validateIntervalDataType(type, strValue);
            }
            if (type instanceof NumberDataType) {
                return this.validateNumberDataType(type, strValue);
            }
            if (type instanceof NumericalDataType) {
                return this.validateNumericalDataType(type, strValue);
            }
            if (type instanceof TimeDataType) {
                return this.validateTimeDataType(type, strValue);
            }
            if (type instanceof XMLDataType) {
                return this.validateXMLDataType(type, strValue);
            }
            if (type instanceof BinaryStringDataType) {
                return this.validateBinaryStringDataType(type, strValue);
            }
        } else if (type instanceof DistinctUserDefinedType) {
            return this.validateDistinctUserDefinedType(type, strValue);
        }
        return null;
    }

    public String validateBinaryStringDataType(DataType type, String strValue) {
        return null;
    }

    public String validateBooleanDataType(DataType type, String strValue) {
        try {
            Boolean.getBoolean(strValue);
        }
        catch (Exception exception) {
            return String.valueOf(Messages.DefaultSQLDataOfflineValidator_not_a_valid_boolean) + strValue;
        }
        return null;
    }

    public String validateCharacterStringDataType(DataType type, String strValue) {
        return null;
    }

    public String validateDateDataType(DataType type, String strValue) {
        return null;
    }

    public String validateIntervalDataType(DataType type, String strValue) {
        return null;
    }

    public String validateNumberDataType(DataType type, String strValue) {
        try {
            Integer.parseInt(strValue);
        }
        catch (Exception exception) {
            return String.valueOf(Messages.DefaultSQLDataOfflineValidator_not_a_valid_number) + strValue;
        }
        return null;
    }

    public String validateNumericalDataType(DataType type, String strValue) {
        try {
            if (type instanceof IntegerDataType) {
                Integer.parseInt(strValue);
            }
            Double.parseDouble(strValue);
        }
        catch (Exception exception) {
            return String.valueOf(Messages.DefaultSQLDataOfflineValidator_not_a_valid_numeric) + strValue;
        }
        return null;
    }

    public String validateTimeDataType(DataType type, String strValue) {
        return null;
    }

    public String validateXMLDataType(DataType type, String strValue) {
        return null;
    }

    public String validateDistinctUserDefinedType(DataType type, String strValue) {
        DistinctUserDefinedType dudt = (DistinctUserDefinedType)type;
        PredefinedDataType pType = dudt.getPredefinedRepresentation();
        if (pType != null) {
            return this.validate((DataType)pType, strValue);
        }
        return null;
    }
}

