/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ecore.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.enablement.oda.ecore.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ecore.impl.ColumnDefinitionUtil;
import org.eclipse.datatools.enablement.oda.ecore.impl.ResultSet;
import org.eclipse.datatools.enablement.oda.ecore.impl.ResultSetMetaData;
import org.eclipse.datatools.enablement.oda.ecore.util.StringUtil;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.ocl.conditions.BooleanOCLCondition;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.OCL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query
implements IQuery {
    private int maxRows = 0;
    private final EClassifier contextClassifier;
    private boolean isPrepared;
    private boolean isClosed;
    private IQueryResult queryResult;
    private final Collection<EObject> eObjects;
    private final Map<String, String> properties;
    private ColumnDefinition[] columnDefinitions;
    private Object[] inputParameters;
    private IExecutionStrategy executionStrategy;

    public Query(Collection<EObject> eObjects, EClassifier contextClassifier) {
        this.contextClassifier = contextClassifier;
        this.eObjects = eObjects;
        this.properties = new HashMap<String, String>();
    }

    public void prepare(String queryText) throws OdaException {
        this.verifyNotClosed();
        if (queryText == null) {
            throw new OdaException("Query text is null");
        }
        this.inputParameters = new Object[StringUtil.countChars('?', queryText) + 1];
        this.executionStrategy = new BooleanOCLQueryExecutionStrategy(queryText);
        this.isPrepared = true;
    }

    public void prepare(SELECT statement) throws OdaException {
        this.verifyNotClosed();
        if (statement == null) {
            throw new OdaException("The statement is null");
        }
        this.executionStrategy = new StatementExecutionStrategy(statement);
        this.isPrepared = true;
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.verifyIsPrepared();
        this.isClosed = true;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        this.verifyIsPrepared();
        this.verifyNotClosed();
        return new ResultSetMetaData(this.getColumnDefinitions());
    }

    public IResultSet executeQuery() throws OdaException {
        this.verifyIsPrepared();
        this.verifyNotClosed();
        return this.executionStrategy.executeQuery();
    }

    public IQueryResult getQueryResult() {
        return this.queryResult;
    }

    public void setProperty(String name, String value) throws OdaException {
        if (value != null) {
            this.properties.put(name, value);
        }
    }

    public void setMaxRows(int max) throws OdaException {
        this.maxRows = max > 0 ? max : 0;
    }

    public int getMaxRows() throws OdaException {
        this.verifyNotClosed();
        return this.maxRows;
    }

    public void clearInParameters() throws OdaException {
        this.inputParameters = null;
    }

    public void setInt(String parameterName, int value) throws OdaException {
        int parameterId = this.findInParameter(parameterName);
        this.verifyParameterIndex(parameterId);
        this.inputParameters[this.findInParameter((String)parameterName)] = value;
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.verifyParameterIndex(parameterId);
        this.inputParameters[parameterId] = value;
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        int parameterId = this.findInParameter(parameterName);
        this.verifyParameterIndex(parameterId);
        this.inputParameters[this.findInParameter((String)parameterName)] = value;
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.verifyParameterIndex(parameterId);
        this.inputParameters[parameterId] = value;
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        int parameterId = this.findInParameter(parameterName);
        this.verifyParameterIndex(parameterId);
        this.inputParameters[this.findInParameter((String)parameterName)] = value;
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.verifyParameterIndex(parameterId);
        this.inputParameters[parameterId] = value;
    }

    public void setString(String parameterName, String value) throws OdaException {
        int parameterId = this.findInParameter(parameterName);
        this.verifyParameterIndex(parameterId);
        this.inputParameters[this.findInParameter((String)parameterName)] = value;
    }

    public void setString(int parameterId, String value) throws OdaException {
        this.verifyParameterIndex(parameterId);
        this.inputParameters[parameterId] = value;
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        int parameterId = this.findInParameter(parameterName);
        this.verifyParameterIndex(parameterId);
        this.inputParameters[this.findInParameter((String)parameterName)] = value;
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.verifyParameterIndex(parameterId);
        this.inputParameters[parameterId] = value;
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        int parameterId = this.findInParameter(parameterName);
        this.verifyParameterIndex(parameterId);
        this.inputParameters[this.findInParameter((String)parameterName)] = value;
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        this.verifyParameterIndex(parameterId);
        this.inputParameters[parameterId] = value;
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        int parameterId = this.findInParameter(parameterName);
        this.verifyParameterIndex(parameterId);
        this.inputParameters[this.findInParameter((String)parameterName)] = value;
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        this.verifyParameterIndex(parameterId);
        this.inputParameters[parameterId] = value;
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        int parameterId = this.findInParameter(parameterName);
        this.verifyParameterIndex(parameterId);
        this.inputParameters[this.findInParameter((String)parameterName)] = value;
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        this.verifyParameterIndex(parameterId);
        this.inputParameters[parameterId] = value;
    }

    public void setObject(int parameterId, Object value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setObject(String parameterName, Object value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setNull(String parameterName) throws OdaException {
        int parameterId = this.findInParameter(parameterName);
        this.verifyParameterIndex(parameterId);
        this.inputParameters[parameterId] = null;
    }

    public void setNull(int parameterId) throws OdaException {
        this.verifyParameterIndex(parameterId);
        this.inputParameters[parameterId] = null;
    }

    public int findInParameter(String parameterName) throws OdaException {
        return 0;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        return null;
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        return null;
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getEffectiveQueryText() {
        return null;
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private void verifyParameterIndex(int parameterId) throws OdaException {
        if (parameterId >= this.inputParameters.length) {
            throw new OdaException("There are more parameters specified for input than the query can handle.");
        }
    }

    private void verifyIsPrepared() throws OdaException {
        if (!this.isPrepared) {
            throw new OdaException("Query has not been prepared");
        }
    }

    private void verifyNotClosed() throws OdaException {
        if (this.isClosed) {
            throw new OdaException(Messages.query_alreadyClosed);
        }
    }

    private ColumnDefinition[] getColumnDefinitions() {
        if (this.columnDefinitions != null) {
            return this.columnDefinitions;
        }
        ArrayList<ColumnDefinition> definitions = new ArrayList<ColumnDefinition>();
        String columnsList = this.properties.get("COLUMN_DEFINITIONS");
        if (columnsList != null) {
            String[] columnNames;
            String[] stringArray = columnNames = columnsList.split(",");
            int n = columnNames.length;
            int n2 = 0;
            while (n2 < n) {
                String columnName = stringArray[n2];
                definitions.add(ColumnDefinitionUtil.createFor(columnName));
                ++n2;
            }
        }
        this.columnDefinitions = definitions.toArray(new ColumnDefinition[definitions.size()]);
        return this.columnDefinitions;
    }

    private final class BooleanOCLQueryExecutionStrategy
    implements IExecutionStrategy {
        private final String queryText;

        BooleanOCLQueryExecutionStrategy(String queryText) {
            this.queryText = queryText;
        }

        public IResultSet executeQuery() throws OdaException {
            BooleanOCLCondition condition;
            OCL ocl = OCL.newInstance();
            try {
                condition = new BooleanOCLCondition(ocl.getEnvironment(), this.parameterizeQuery(), (Object)Query.this.contextClassifier);
            }
            catch (ParserException e) {
                throw new OdaException((Throwable)e);
            }
            SELECT statement = new SELECT(Query.this.maxRows, false, new FROM(Query.this.eObjects), new WHERE((EObjectCondition)condition));
            Query.this.queryResult = statement.execute();
            ResultSet resultSet = new ResultSet(Query.this, Query.this.getColumnDefinitions(), Query.this.maxRows);
            resultSet.setMaxRows(Query.this.getMaxRows());
            return resultSet;
        }

        private String parameterizeQuery() {
            String parameterizedQuery = this.queryText;
            int i = 1;
            while (i < Query.this.inputParameters.length) {
                parameterizedQuery = parameterizedQuery.replaceFirst("\\?", String.valueOf(Query.this.inputParameters[i]));
                ++i;
            }
            return parameterizedQuery;
        }
    }

    static interface IExecutionStrategy {
        public IResultSet executeQuery() throws OdaException;
    }

    private final class StatementExecutionStrategy
    implements IExecutionStrategy {
        private final SELECT statement;

        StatementExecutionStrategy(SELECT statement) {
            this.statement = statement;
        }

        public IResultSet executeQuery() throws OdaException {
            Query.this.queryResult = this.statement.execute();
            ResultSet resultSet = new ResultSet(Query.this, Query.this.getColumnDefinitions(), Query.this.maxRows);
            resultSet.setMaxRows(Query.this.getMaxRows());
            return resultSet;
        }
    }
}

