/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.codegen.jet.JETDirectiveItem;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETItem;
import org.eclipse.emf.codegen.jet.JETJavaItem;
import org.eclipse.emf.codegen.jet.JETLiteralItem;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETRootItem;
import org.eclipse.emf.codegen.jet.JETSubItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JETCompilationUnit {
    private static boolean trace;
    private final String className;
    private final String javaCompilationUnit;
    private final List<JETJavaRange> ranges = new ArrayList<JETJavaRange>();
    private final List<String> templateURIs;
    private final List<JETItem> jetItems;
    private final List<JETException> problems;

    public JETCompilationUnit(List<String> templateURIs, String className, String javaCompilationUnit, List<JETItem> jetItems, List<JETException> problems) {
        this.problems = problems;
        this.jetItems = Collections.unmodifiableList(jetItems);
        this.templateURIs = Collections.unmodifiableList(templateURIs);
        this.className = className;
        this.javaCompilationUnit = javaCompilationUnit;
    }

    public String getClassName() {
        return this.className;
    }

    public String getJavaCompilationUnit() {
        return this.javaCompilationUnit;
    }

    public List<JETJavaRange> getRanges() {
        return this.ranges;
    }

    public List<String> getTemplateURIs() {
        return this.templateURIs;
    }

    public List<JETItem> getItems() {
        return this.jetItems;
    }

    public List<JETException> getProblems() {
        return this.problems;
    }

    public JETDirectiveItem getJETJETDirectiveItem() {
        for (JETItem jetItem : this.jetItems) {
            JETDirectiveItem jetDirectiveItem;
            JETItem nameItem;
            String name;
            if (!(jetItem instanceof JETDirectiveItem) || !"jet".equals(name = (nameItem = (jetDirectiveItem = (JETDirectiveItem)jetItem).getNameItem()).getText())) continue;
            return jetDirectiveItem;
        }
        return null;
    }

    public JETItem getJETItem(int fileID, int templateOffset, boolean leaf) {
        for (JETItem jetItem : this.jetItems) {
            JETSubItem leafItem;
            if (jetItem.getFileID() != fileID || jetItem.getStartOffset() > templateOffset || jetItem.getStopOffset() < templateOffset) continue;
            JETItem result = jetItem;
            if (leaf && (leafItem = jetItem.getLeaf(fileID, templateOffset)) != null) {
                result = leafItem;
            }
            return result;
        }
        return null;
    }

    public int[] getCorrespondingJavaPoint(int fileID, int templateOffset, int templateLength) {
        int templateStop = templateOffset + templateLength;
        for (JETJavaRange range : this.ranges) {
            if (trace) {
                String java = this.javaCompilationUnit.substring(range.getJavaOffset(), range.getJavaOffset() + range.getJavaLength());
                System.out.println("java > " + java);
            }
            if (range.getFileID() != fileID) continue;
            int rangeStartOffset = range.getStartOffset();
            int rangeStopOffset = range.getStopOffset();
            if (rangeStopOffset < templateOffset || templateStop < rangeStartOffset) continue;
            int javaOffset = range.getJavaOffset();
            int javaLength = range.getJavaLength();
            int javaStop = javaOffset + javaLength;
            if (templateLength == -1 || !range.isDirectMapping()) {
                return new int[]{javaOffset, javaLength};
            }
            int delta = javaOffset - rangeStartOffset;
            int templateJavaStop = templateStop + delta;
            int javaStopBoundary = Math.min(javaStop, templateJavaStop);
            int javaStart = Math.max(javaOffset, templateOffset + delta);
            return new int[]{javaStart, javaStopBoundary - javaStart};
        }
        return null;
    }

    public int getCorrespondingTemplateFileID(int javaOffset) {
        for (JETJavaRange range : this.ranges) {
            if (trace) {
                this.dump(range);
            }
            if (range.getJavaOffset() > javaOffset || javaOffset > range.getJavaOffset() + range.getJavaLength()) continue;
            return range.getFileID();
        }
        return -1;
    }

    public int[] getCorrespondingTemplatePoint(int fileID, int javaOffset, int javaLength) {
        for (JETJavaRange range : this.ranges) {
            int rangeJavaOffset = range.getJavaOffset();
            int rangeJavaLength = range.getJavaLength();
            if (rangeJavaOffset <= javaOffset + javaLength && javaOffset <= rangeJavaOffset + rangeJavaLength) {
                JETMark initialStart;
                JETMark start = initialStart = range.getStart();
                while (start != null) {
                    if (start.getFileId() == fileID) {
                        JETItem jetItem = start == initialStart ? range.getJETItem() : this.getJETItem(fileID, start.getCursor(), true);
                        int templateStart = jetItem.getStartOffset();
                        int templateStop = jetItem.getStopOffset();
                        if (jetItem instanceof JETJavaItem && !(jetItem instanceof JETLiteralItem)) {
                            JETJavaItem jetJavaItem = (JETJavaItem)jetItem;
                            int itemJavaOffset = jetJavaItem.getJavaOffset();
                            int itemJavaLength = jetJavaItem.getJavaLength();
                            int templateOffset = Math.max(0, javaOffset - itemJavaOffset);
                            int length = Math.max(0, Math.min(itemJavaLength - templateOffset, javaLength));
                            return new int[]{jetJavaItem.getStartOffset() + templateOffset, length};
                        }
                        return new int[]{templateStart, templateStop - templateStart};
                    }
                    start = start.getParentMark();
                }
                break;
            }
            if (rangeJavaOffset + rangeJavaLength > javaOffset) break;
        }
        return null;
    }

    public int[] getClosestCorrespondingTemplatePoint(int fileID, int javaOffset, int javaLength) {
        JETJavaRange jetRange = this.getJETRange(javaOffset, javaLength);
        if (jetRange != null) {
            JETMark start;
            JETMark jetMark = start = jetRange.getStart();
            while (jetMark != null) {
                if (jetMark.getFileId() == fileID) {
                    if (jetMark == start) {
                        int rangeJavaOffset = jetRange.getJavaOffset();
                        int offset = javaOffset - rangeJavaOffset;
                        int templateOffset = start.getCursor();
                        int templateJavaOffset = templateOffset + offset;
                        int templateJavaLength = Math.min(javaLength, jetRange.getStopOffset() - templateJavaOffset);
                        return new int[]{templateJavaOffset, templateJavaLength};
                    }
                    JETItem jetItem = this.getJETItem(fileID, jetMark.getCursor(), false);
                    if (jetItem == null) {
                        int[] nArray = new int[2];
                        nArray[0] = jetMark.getCursor();
                        return nArray;
                    }
                    int templateOffset = jetItem.getStartOffset();
                    return new int[]{templateOffset, jetItem.getStopOffset() - templateOffset};
                }
                jetMark = jetMark.getParentMark();
            }
        }
        if (this.javaCompilationUnit.length() >= javaOffset + javaLength) {
            block23: {
                JETJavaRange stopRange;
                block24: {
                    if (trace) {
                        System.out.println("java > " + this.javaCompilationUnit.substring(javaOffset, javaOffset + javaLength));
                    }
                    if (fileID == 0) break block23;
                    JETJavaRange startRange = null;
                    stopRange = null;
                    for (JETJavaRange range : this.ranges) {
                        if (range.getFileID() != fileID) continue;
                        if (startRange == null) {
                            startRange = range;
                        }
                        stopRange = range;
                    }
                    if (startRange == null) break block23;
                    if (startRange.getJavaOffset() <= javaOffset + javaLength) break block24;
                    return null;
                }
                int stop = stopRange.getJavaOffset() + stopRange.getJavaLength();
                if (stop >= javaOffset) break block23;
                return null;
            }
            try {
                JETItem previousRange = null;
                for (JETJavaRange range : this.ranges) {
                    if (trace) {
                        this.dump(range);
                    }
                    int rangeJavaOffset = range.getJavaOffset();
                    if (previousRange == null && javaOffset < rangeJavaOffset) {
                        return new int[2];
                    }
                    int rangeJavaLength = range.getJavaLength();
                    int offset = javaOffset - rangeJavaOffset;
                    if (offset >= 0 && javaOffset <= rangeJavaOffset + rangeJavaLength) {
                        if (range.getFileID() == fileID) {
                            int templateOffset = range.getStartOffset();
                            int templateJavaOffset = templateOffset + offset;
                            int templateJavaLength = Math.min(javaLength, range.getStopOffset() - templateJavaOffset);
                            if (templateJavaLength < 0) {
                                if ((templateJavaOffset += templateJavaLength) < 0) {
                                    templateJavaOffset = 0;
                                }
                                templateJavaLength = 0;
                            }
                            return new int[]{templateJavaOffset, templateJavaLength};
                        }
                    } else if (offset < 0 && range.getFileID() == fileID) {
                        int templateOffset = range.getStartOffset();
                        return new int[]{templateOffset - 1, 1};
                    }
                    if (range.getFileID() != fileID) continue;
                    previousRange = range;
                }
                if (previousRange != null) {
                    int templateOffsetOfStop = previousRange.getStopOffset();
                    return new int[]{templateOffsetOfStop - 2, 2};
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return new int[2];
    }

    public JETItem getJETItem(int javaOffset, int javaLength) {
        JETJavaRange jetRange = this.getJETRange(javaOffset, javaLength);
        return jetRange == null ? null : jetRange.getJETItem();
    }

    public JETJavaRange getJETRange(int javaOffset, int javaLength) {
        for (JETJavaRange range : this.ranges) {
            int rangeJavaOffset = range.getJavaOffset();
            int rangeJavaLength = range.getJavaLength();
            if (rangeJavaOffset > javaOffset || javaOffset + javaLength > rangeJavaOffset + rangeJavaLength) continue;
            return range;
        }
        return null;
    }

    public List<JETJavaItem> getJavaItems(int fileID) {
        return this.getJavaItems(fileID, -1, -1);
    }

    public List<JETJavaItem> getJavaItems(int fileID, int templateOffset, int templateLength) {
        return this.accumulate(new JETItemIterator<JETJavaItem>(this.jetItems, JETJavaItem.class, fileID));
    }

    public List<JETRootItem> getSkippedItems(int fileID) {
        return this.getSkippedItems(fileID, -1, -1);
    }

    public List<JETRootItem> getSkippedItems(int fileID, int templateOffset, int templateLength) {
        return this.accumulate(new JETItemIterator<JETRootItem>(this, this.jetItems, JETRootItem.class, fileID, templateOffset, templateLength){

            @Override
            protected boolean isIncluded(JETRootItem item) {
                return item.isSkipped();
            }
        });
    }

    JETJavaRange addRange(JETMark start, JETMark stop, int javaOffset, int javaLength, JETItem jetItem) {
        JETJavaRange jetRange = new JETJavaRange(start, stop, javaOffset, javaLength, jetItem);
        this.ranges.add(jetRange);
        return jetRange;
    }

    private <E extends JETItem> List<E> accumulate(Iterator<E> contents) {
        ArrayList<JETItem> result = new ArrayList<JETItem>();
        while (contents.hasNext()) {
            result.add((JETItem)contents.next());
        }
        return result;
    }

    private void dump(JETJavaRange range) {
        String java = this.javaCompilationUnit.substring(range.getJavaOffset(), range.getJavaOffset() + range.getJavaLength());
        System.out.println("scanning > " + java);
    }

    private void dumpRanges() {
        for (JETJavaRange range : this.ranges) {
            String text = range.getText();
            System.out.println(">>" + text.replaceAll("\r?\n", "<<\n>>") + "<<\n");
            String javaText = this.javaCompilationUnit.substring(range.getJavaOffset(), range.getJavaOffset() + range.getJavaLength());
            System.out.println("%>" + javaText.replaceAll("\r?\n", "<%\n%>") + "<%\n");
            if (text.equals(javaText)) continue;
            System.err.println("####mismatch");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JETItemIterator<E extends JETItem>
    implements Iterator<E> {
        private final Iterator<JETItem> delegate;
        private final Class<E> type;
        private final int fileID;
        private final int offset;
        private final int endOffset;
        private E nextItem;
        private boolean isPrepared;

        public JETItemIterator(Iterable<JETItem> delegate, Class<E> type, int fileID) {
            this(delegate.iterator(), type, fileID);
        }

        public JETItemIterator(Iterator<JETItem> delegate, Class<E> type, int fileID) {
            this(delegate, type, fileID, -1, -1);
        }

        public JETItemIterator(Iterable<JETItem> delegate, Class<E> type, int fileID, int offset, int length) {
            this(delegate.iterator(), type, fileID, offset, length);
        }

        public JETItemIterator(Iterator<JETItem> delegate, Class<E> type, int fileID, int offset, int length) {
            this.delegate = delegate;
            this.type = type;
            this.fileID = fileID;
            this.offset = offset;
            this.endOffset = offset + length;
        }

        private boolean basicIsIncluded(E item) {
            if (this.fileID == -1) {
                return this.isIncluded(item);
            }
            if (((JETItem)item).getFileID() != this.fileID) {
                return false;
            }
            if (this.offset < 0) {
                return this.isIncluded(item);
            }
            if (((JETItem)item).getStartOffset() > this.endOffset) {
                return false;
            }
            JETMark stop = ((JETItem)item).getStop();
            int stopCursor = stop.getCursor();
            if (stopCursor < this.offset) {
                return false;
            }
            return this.isIncluded(item);
        }

        protected boolean isIncluded(E item) {
            return true;
        }

        @Override
        public boolean hasNext() {
            while (this.delegate.hasNext()) {
                JETItem typedItem;
                JETItem item = this.delegate.next();
                if (!this.type.isInstance(item) || !this.basicIsIncluded(typedItem = (JETItem)this.type.cast(item))) continue;
                this.nextItem = typedItem;
                this.isPrepared = true;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.isPrepared && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextItem;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static final class JETJavaRange
    extends JETItem {
        private int javaOffset;
        private int javaLength;
        private JETItem jetItem;

        private JETJavaRange(JETMark start, JETMark stop, int javaOffset, int javaLength, JETItem jetItem) {
            super(start, stop);
            this.javaOffset = javaOffset;
            this.javaLength = javaLength;
            this.jetItem = jetItem;
        }

        public final int getJavaOffset() {
            return this.javaOffset;
        }

        public final int getJavaLength() {
            return this.javaLength;
        }

        public final JETItem getJETItem() {
            return this.jetItem;
        }

        public final JETJavaRange subrange(int startOffset) {
            return new JETJavaRange(this.getStart(), this.getStop(), this.javaOffset + startOffset, this.javaLength - startOffset, this.jetItem);
        }

        public boolean isDirectMapping() {
            return this.jetItem == null || !(this.jetItem instanceof JETLiteralItem);
        }
    }
}

