/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.refactoring.descriptors;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.DescriptorMessages;
import org.eclipse.jdt.internal.core.refactoring.descriptors.JavaRefactoringDescriptorUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class UseSupertypeDescriptor
extends JavaRefactoringDescriptor {
    private static final String ATTRIBUTE_INSTANCEOF = "instanceof";
    private boolean fInstanceof = false;
    private IType fSubType = null;
    private IType fSupertype = null;

    public UseSupertypeDescriptor() {
        super("org.eclipse.jdt.ui.use.supertype");
    }

    public UseSupertypeDescriptor(String project, String description, String comment, Map<String, String> arguments, int flags) {
        super("org.eclipse.jdt.ui.use.supertype", project, description, comment, arguments, flags);
        this.fInstanceof = JavaRefactoringDescriptorUtil.getBoolean(arguments, ATTRIBUTE_INSTANCEOF, this.fInstanceof);
        this.fSubType = (IType)JavaRefactoringDescriptorUtil.getJavaElement(arguments, "input", project);
        this.fSupertype = (IType)JavaRefactoringDescriptorUtil.getJavaElement(arguments, JavaRefactoringDescriptorUtil.getAttributeName("element", 1), project);
    }

    @Override
    protected void populateArgumentMap() {
        super.populateArgumentMap();
        JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, ATTRIBUTE_INSTANCEOF, this.fInstanceof);
        JavaRefactoringDescriptorUtil.setJavaElement(this.fArguments, "input", this.getProject(), (IJavaElement)this.fSubType);
        JavaRefactoringDescriptorUtil.setJavaElement(this.fArguments, JavaRefactoringDescriptorUtil.getAttributeName("element", 1), this.getProject(), (IJavaElement)this.fSupertype);
    }

    public void setReplaceInstanceof(boolean replace) {
        this.fInstanceof = replace;
    }

    public void setSubtype(IType type) {
        Assert.isNotNull((Object)type);
        this.fSubType = type;
    }

    public void setSupertype(IType type) {
        Assert.isNotNull((Object)type);
        this.fSupertype = type;
    }

    @Override
    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = super.validateDescriptor();
        if (this.fSubType == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.UseSupertypeDescriptor_no_subtype));
        }
        if (this.fSupertype == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.UseSupertypeDescriptor_no_supertype));
        }
        return status;
    }
}

