/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.views.actions;

import net.sourceforge.plantuml.eclipse.utils.WorkbenchUtil;
import net.sourceforge.plantuml.eclipse.views.DiagramImageControl;
import net.sourceforge.plantuml.eclipse.views.actions.DiagramImageAction;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class PrintAction
extends DiagramImageAction {
    public PrintAction(DiagramImageControl control) {
        super(control);
        this.setText("Print");
    }

    public void run() {
        PrintDialog pDialog = new PrintDialog(this.getControl().getShell(), 65536);
        pDialog.setText("UML Printing.");
        pDialog.setScope(0);
        PrinterData pData = pDialog.open();
        try {
            Printer printer = null;
            if (pData != null) {
                printer = new Printer(pData);
            }
            if (printer != null && printer.startJob("PlantUml Image") && printer.startPage()) {
                int coef = 5;
                Rectangle trim = printer.computeTrim(0, 0, 0, 0);
                Point dpi = printer.getDPI();
                int horizontalMargin = dpi.x / 4 + trim.x;
                int verticalMargin = dpi.y / 4 + trim.y;
                ImageData image = this.getImage();
                int displayWidth = image.width * 5;
                int displayHeigth = image.height * 5;
                Rectangle pageSize = printer.getBounds();
                int widthWithoutMargin = pageSize.width - 2 * horizontalMargin;
                int heigthWithoutMargin = pageSize.height - 2 * verticalMargin;
                if (displayWidth > widthWithoutMargin) {
                    displayWidth = widthWithoutMargin;
                    if ((displayHeigth = displayHeigth * displayWidth / widthWithoutMargin) > heigthWithoutMargin) {
                        displayHeigth = heigthWithoutMargin;
                        displayWidth = displayWidth * heigthWithoutMargin / displayHeigth;
                    }
                } else if (displayHeigth > heigthWithoutMargin && (displayWidth = displayWidth * heigthWithoutMargin / (displayHeigth = heigthWithoutMargin)) > widthWithoutMargin) {
                    displayWidth = widthWithoutMargin;
                    displayHeigth = displayHeigth * widthWithoutMargin / displayWidth;
                }
                this.printImage(image, printer, horizontalMargin, verticalMargin, displayWidth, displayHeigth);
            }
            if (printer != null) {
                printer.endJob();
                printer.dispose();
            }
        }
        catch (Throwable e) {
            WorkbenchUtil.errorBox("OutOfMemoryError", "Image to print is too big to be printed in one page.", e);
        }
    }

    private void printImage(ImageData iData, Printer printer, int horizontalMargin, int verticalMargin, int displayWidth, int displayHeigth) throws Throwable {
        GC gc = new GC((Drawable)printer);
        Image printerImage = new Image((Device)printer, iData);
        gc.drawImage(printerImage, 0, 0, iData.width, iData.height, horizontalMargin, verticalMargin, displayWidth, displayHeigth);
        printerImage.dispose();
        gc.dispose();
        printer.endPage();
    }
}

