/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.modelqualitychecks;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.petrinet.PetrinetBuilder;
import org.eclipse.xtext.scoping.IScopeProvider;

public class ModelQualityChecksGenerator {
    public static String generate(Interface itf, Parameters params, IScopeProvider scopeProvider, int maxDepth, List<List<State>> homeStates, String plantumlJar) throws IOException, URISyntaxException {
        String code = "SELF_CONTAINED = True\n" + PetrinetBuilder.getModelCode() + PetrinetBuilder.getReachabilityGraphCode();
        code = String.valueOf(code) + "## verification_report.py\n" + ModelQualityChecksGenerator.getResourceText("/verification_report.py") + "\n\n";
        code = String.valueOf(code) + PetrinetBuilder.forInterface((Interface)itf, (Parameters)params, (IScopeProvider)scopeProvider, (PetrinetBuilder.Mode)PetrinetBuilder.Mode.NOT_INTERACTIVE) + "\n\n";
        if (homeStates == null || homeStates.isEmpty()) {
            List initialStates = itf.getMachines().stream().map(m -> m.getStates().stream().filter(s -> s.isInitial()).findFirst().get()).collect(Collectors.toList());
            homeStates = new ArrayList<List<State>>();
            homeStates.add(initialStates);
        }
        String homeStatesStr = homeStates.stream().map(l -> l.stream().map(s -> String.format("'%s'", s.getName())).collect(Collectors.joining(","))).map(s -> String.format("[%s]", s)).collect(Collectors.joining(", "));
        Path javaExecutable = Paths.get(System.getProperty("java.home"), "bin", "java");
        ByteArrayOutputStream itfOS = new ByteArrayOutputStream();
        itf.eResource().save((OutputStream)itfOS, new HashMap());
        String itfBase64 = Base64.getEncoder().encodeToString(itfOS.toByteArray());
        code = String.valueOf(code) + "## Parameters\n";
        code = String.valueOf(code) + String.format("MAX_DEPTH = %d\n", maxDepth);
        code = String.valueOf(code) + String.format("HOME_STATES = [%s]\n", homeStatesStr);
        code = String.valueOf(code) + String.format("JAVA = r'%s'\n", javaExecutable);
        code = String.valueOf(code) + String.format("PLANTUML = r'%s'\n", plantumlJar);
        code = String.valueOf(code) + String.format("INTERFACE = r'%s'\n", itfBase64);
        code = String.valueOf(code) + "OUTPUT_FILE = 'report.json'\n";
        code = String.valueOf(code) + "\n";
        code = String.valueOf(code) + "## generator_mqc.py\n" + ModelQualityChecksGenerator.getResourceText("/generator_mqc.py") + "\n\n";
        return code;
    }

    public static InputStream getDashboardHTML() throws IOException {
        return ModelQualityChecksGenerator.class.getResourceAsStream("/dashboard.html");
    }

    private static String getResourceText(String resource) {
        InputStream stream = ModelQualityChecksGenerator.class.getResourceAsStream(resource);
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n"));
    }
}

