/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.pr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xpand2.pr.ProtectedRegion;
import org.eclipse.internal.xpand2.pr.ProtectedRegionResolver;
import org.eclipse.internal.xpand2.pr.ProtectedRegionSyntaxException;
import org.eclipse.internal.xpand2.pr.util.BASE64;
import org.eclipse.internal.xpand2.pr.util.FSIO;
import org.eclipse.internal.xpand2.pr.util.GenericFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectedRegionResolverImpl
implements ProtectedRegionResolver {
    private static final Log LOG = LogFactory.getLog(ProtectedRegionResolverImpl.class);
    private static final String ENABLED = "ENABLED";
    private static final String PROTECT_AFTER_ID = ")";
    private static final String PROTECT_B64_AFTER_ID = "]";
    private static final String PROTECT_B64_BEFORE_ID = "[";
    private static final String PROTECT_BEFORE_ID = "(";
    private static final String PROTECT_BEGIN = "PROTECTED REGION ID";
    private static final String PROTECT_END = "PROTECTED REGION END";
    private static final String PROTECT_START_END = "START";
    private final Log log = LogFactory.getLog(this.getClass());
    private File[] srcPaths = null;
    private boolean defaultExcludes = true;
    protected boolean useBASE64 = false;
    protected String encoding;
    private String ignoreList = null;
    private Map<String, ProtectedRegionImpl> regionMap = null;
    private Set<String> usedSet = null;

    protected Collection<ProtectedRegionImpl> getAllRegions(File file) throws ProtectedRegionSyntaxException, IOException {
        ArrayList<ProtectedRegionImpl> regions = new ArrayList<ProtectedRegionImpl>();
        String source = FSIO.readSingleFile(file, this.encoding);
        int beginLength = PROTECT_BEGIN.length();
        int startEndLength = PROTECT_START_END.length();
        int idBeginLength = PROTECT_BEFORE_ID.length();
        int idEndLength = PROTECT_AFTER_ID.length();
        int start = source.indexOf(PROTECT_BEGIN);
        while (start >= 0) {
            int startEnd;
            int blockStart = start + beginLength;
            boolean isB64 = false;
            int idStart = source.indexOf(PROTECT_BEFORE_ID, blockStart);
            if (idStart != blockStart) {
                idStart = source.indexOf(PROTECT_B64_BEFORE_ID, blockStart);
                isB64 = true;
            }
            int end = source.indexOf(PROTECT_END, idStart += idBeginLength);
            int next = source.indexOf(PROTECT_BEGIN, idStart);
            if (end < 0 || next >= 0 && next < end) {
                throw new ProtectedRegionSyntaxException("Protected region at index " + start + " in file '" + file + "' is incomplete");
            }
            int idEnd = source.indexOf(isB64 ? PROTECT_B64_AFTER_ID : PROTECT_AFTER_ID, idStart);
            if (idEnd <= idStart || end < idEnd) {
                throw new ProtectedRegionSyntaxException("Protected region Id at index " + start + " in file '" + file + "' is incomplete");
            }
            String id = new String(source.substring(idStart, idEnd));
            if (isB64) {
                try {
                    id = new String(BASE64.toByteArray(id));
                }
                catch (IOException ie) {
                    throw new ProtectedRegionSyntaxException("Protected region Id at index " + start + " in file '" + file + "' is incomplete", ie);
                }
            }
            if (end < (startEnd = source.indexOf(PROTECT_START_END, idEnd + idEndLength))) {
                throw new ProtectedRegionSyntaxException("Protected region start at index " + start + " in file '" + file + "' is incomplete");
            }
            String type = new String(source.substring(idEnd + idEndLength, startEnd).trim().toUpperCase());
            if (type.startsWith(ENABLED) && type.substring(ENABLED.length()).contains("\n*")) {
                type = ENABLED;
            }
            if (!type.equals("") && !type.equals(ENABLED)) {
                throw new ProtectedRegionSyntaxException("Protected region start at index " + start + " in file " + file + " has illegal type '" + type + "'");
            }
            if (type.equals(ENABLED)) {
                String body = new String(source.substring(startEnd + startEndLength, end));
                regions.add(new ProtectedRegionImpl(id, false, file, this.encoding, this.useBASE64, startEnd + startEndLength, end, body));
            }
            start = next;
        }
        return regions;
    }

    @Override
    public ProtectedRegion createProtectedRegion(String id, boolean disabled) {
        return new ProtectedRegionImpl(id, disabled, null, null, this.useBASE64, 0, 0, null);
    }

    @Override
    public ProtectedRegion getProtectedRegion(String id) {
        this.init();
        if (!this.usedSet.add(id)) {
            this.log.warn((Object)("Protected region with ID '" + id + "' referenced more than once"));
        }
        return this.regionMap.get(id);
    }

    public void init() throws IllegalStateException {
        if (this.regionMap != null) {
            return;
        }
        this.regionMap = new HashMap<String, ProtectedRegionImpl>();
        this.usedSet = new HashSet<String>();
        if (this.srcPaths == null) {
            this.log.warn((Object)"No source paths configured for scanning.");
            return;
        }
        long time = 0L;
        long fileCount = 0L;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Source scan started ...");
            time = System.currentTimeMillis();
        }
        GenericFileFilter filter = new GenericFileFilter(this.ignoreList, this.defaultExcludes);
        int i = 0;
        while (i < this.srcPaths.length) {
            try {
                File[] files = FSIO.getAllFiles(this.srcPaths[i], (FilenameFilter)filter);
                fileCount += (long)files.length;
                int j = 0;
                while (j < files.length) {
                    for (ProtectedRegionImpl region : this.getAllRegions(files[j])) {
                        String id = region.getId();
                        if (this.regionMap.containsKey(id)) {
                            throw new IllegalStateException("Id '" + id + "' occuring in files " + region.getFile() + " and " + this.regionMap.get(id).getFile() + " is not unique");
                        }
                        this.regionMap.put(id, region);
                    }
                    ++j;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected I/O exception", e);
            }
            catch (ProtectedRegionSyntaxException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            ++i;
        }
        if (this.log.isInfoEnabled()) {
            time = System.currentTimeMillis() - time;
            this.log.info((Object)("Source scan finished in " + (double)time / 1000.0 + "s"));
            this.log.info((Object)("Files scanned: " + fileCount));
            this.log.info((Object)("Regions found: " + this.regionMap.size()));
        }
    }

    public void reportRegions(File dumpPath) {
        int unused = this.regionMap.size() - this.usedSet.size();
        if (unused > 0) {
            this.log.warn((Object)("There are " + unused + " unused Regions:"));
            if (dumpPath != null) {
                dumpPath.mkdirs();
            }
            for (ProtectedRegionImpl region : this.regionMap.values()) {
                String id = region.getId();
                if (this.usedSet.contains(id)) continue;
                this.log.warn((Object)("File: " + region.getFile()));
                this.log.warn((Object)("ID: " + id));
                try {
                    if (dumpPath == null) continue;
                    File file = new File(dumpPath, BASE64.toString(id));
                    OutputStreamWriter writer = this.encoding == null ? new FileWriter(file) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding);
                    writer.write(region.getStartString("", ""));
                    writer.write(region.getBody("", ""));
                    writer.write(region.getEndString("", ""));
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected I/O exception", e);
                }
                catch (ProtectedRegionSyntaxException e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void setDefaultExcludes(boolean defaultExcludes) {
        this.defaultExcludes = defaultExcludes;
    }

    public void setFileEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setIgnoreList(String ignoreList) {
        this.ignoreList = ignoreList;
    }

    public void setSrcPathes(String srcPathsAsString) throws IllegalArgumentException {
        if ("".equals(srcPathsAsString)) {
            this.srcPaths = new File[0];
        } else {
            String[] s = srcPathsAsString.split(",");
            ArrayList<File> validPaths = new ArrayList<File>(s.length);
            int i = 0;
            while (i < s.length) {
                File dir = new File(s[i].trim());
                if (!dir.isDirectory()) {
                    String msg = "Ignoring non-existing protected region path " + dir.getAbsolutePath();
                    LOG.warn((Object)msg);
                    throw new IllegalArgumentException(msg);
                }
                validPaths.add(dir);
                ++i;
            }
            this.srcPaths = validPaths.toArray(new File[0]);
        }
    }

    public void setUseBASE64(boolean useBASE64) {
        this.useBASE64 = useBASE64;
    }

    public static class ProtectedRegionImpl
    implements ProtectedRegion {
        private SoftReference<String> body;
        private String fileEncoding;
        private int endIndex;
        private File file;
        private String id;
        private int startIndex;
        private boolean disabled = true;
        private boolean useBASE64;

        public ProtectedRegionImpl(String id, boolean disabled, File file, String fileEncoding, boolean useBASE64, int startIndex, int endIndex, String body) {
            this.id = id;
            this.disabled = disabled;
            this.file = file;
            this.fileEncoding = fileEncoding;
            this.useBASE64 = useBASE64;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.body = new SoftReference<String>(body);
        }

        public void setBody(String body) {
            this.body = new SoftReference<String>(body);
        }

        public String getBody(String startComment, String endComment) throws ProtectedRegionSyntaxException {
            int endCommentIndex;
            String body = this.body.get();
            if (body == null) {
                try {
                    body = FSIO.readSingleFile(this.file, this.fileEncoding).substring(this.startIndex, this.endIndex);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected I/O exception (source files removed?)", e);
                }
            }
            if ((endCommentIndex = body.indexOf(endComment)) < 0 || body.substring(0, endCommentIndex).trim().length() > 0) {
                throw new ProtectedRegionSyntaxException("Start of protected region " + this.id + " does not end with comment " + endComment);
            }
            int startCommentIndex = body.lastIndexOf(startComment);
            if (startCommentIndex < 0 || body.substring(startCommentIndex + startComment.length()).trim().length() > 0) {
                throw new ProtectedRegionSyntaxException("End of protected region " + this.id + " does not start with comment " + startComment);
            }
            return body.substring(endCommentIndex + endComment.length(), startCommentIndex);
        }

        public String getEndString(String startComment, String endComment) {
            return String.valueOf(startComment) + ProtectedRegionResolverImpl.PROTECT_END + endComment;
        }

        public File getFile() {
            return this.file;
        }

        public String getId() {
            return this.id;
        }

        public String getFileEncoding() {
            return this.fileEncoding;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public boolean isUseBASE64() {
            return this.useBASE64;
        }

        public String getStartString(String startComment, String endComment) {
            if (this.useBASE64) {
                try {
                    return String.valueOf(startComment) + ProtectedRegionResolverImpl.PROTECT_BEGIN + ProtectedRegionResolverImpl.PROTECT_B64_BEFORE_ID + BASE64.toString(this.id) + ProtectedRegionResolverImpl.PROTECT_B64_AFTER_ID + " " + (!this.disabled ? "ENABLED " : "") + ProtectedRegionResolverImpl.PROTECT_START_END + endComment;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return String.valueOf(startComment) + ProtectedRegionResolverImpl.PROTECT_BEGIN + ProtectedRegionResolverImpl.PROTECT_BEFORE_ID + this.id + ProtectedRegionResolverImpl.PROTECT_AFTER_ID + " " + (!this.disabled ? "ENABLED " : "") + ProtectedRegionResolverImpl.PROTECT_START_END + endComment;
        }
    }
}

