/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.reachabilitygraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.comma.evaluator.EAction;
import org.eclipse.comma.evaluator.EArgument;
import org.eclipse.comma.evaluator.ECommand;
import org.eclipse.comma.evaluator.ENotification;
import org.eclipse.comma.evaluator.EReply;
import org.eclipse.comma.evaluator.ESignal;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableType;
import org.eclipse.comma.reachabilitygraph.Edge;
import org.eclipse.comma.reachabilitygraph.GsonHelper;
import org.eclipse.comma.reachabilitygraph.Node;
import org.eclipse.comma.reachabilitygraph.ReachabilityGraph;

public class DeterministicScenarios {
    final List<List<Edge>> scenarios = new ArrayList<List<Edge>>();
    final ReachabilityGraph graph;
    final HashMap<Node, List<Edge>> sourceEdgeLookup = new HashMap();

    private DeterministicScenarios(ReachabilityGraph graph) {
        this.graph = graph;
    }

    public static DeterministicScenarios fromGraph(ReachabilityGraph graph) {
        DeterministicScenarios deterministicScenarios = new DeterministicScenarios(graph);
        deterministicScenarios.createSourceEdgeLookup();
        deterministicScenarios.walkRecursive(graph);
        deterministicScenarios.validateGeneratedScenarios();
        return deterministicScenarios;
    }

    private boolean edgeCanLoop(Edge edge) {
        return edge.target.trigger == null ? edge.target == edge.source : this.sourceEdgeLookup.get(edge.target).stream().anyMatch(e -> e.target == edge.source);
    }

    private void createSourceEdgeLookup() {
        this.graph.nodes.values().forEach(n -> {
            ArrayList arrayList = this.sourceEdgeLookup.put((Node)n, new ArrayList());
        });
        this.graph.edges.forEach(e -> {
            boolean bl = this.sourceEdgeLookup.get(e.source).add((Edge)e);
        });
        this.sourceEdgeLookup.values().forEach(edges -> Collections.sort(edges, new Comparator<Edge>(){

            @Override
            public int compare(Edge e1, Edge e2) {
                return (DeterministicScenarios.this.edgeCanLoop(e1) ? 0 : 1) - (DeterministicScenarios.this.edgeCanLoop(e2) ? 0 : 1);
            }
        }));
    }

    private List<Edge> forkScenarioIfNecessary(List<List<Edge>> queue, List<Edge> scenarioStart, List<Edge> scenario, Edge edge1) {
        if (scenario.size() != 0 && scenario.get((int)(scenario.size() - 1)).target != edge1.source) {
            scenario = new ArrayList<Edge>(scenarioStart);
            queue.add(scenario);
            int i = scenario.size() - 1;
            while (i >= 0) {
                Edge edge = scenario.get(i);
                int removeFrom = -1;
                int ii = i - 2;
                while (ii >= 0) {
                    if (scenario.get((int)ii).source == edge.source) {
                        removeFrom = ii;
                    }
                    --ii;
                }
                if (removeFrom != -1) {
                    int counter = 0;
                    while (counter < i - removeFrom) {
                        scenario.remove(removeFrom);
                        ++counter;
                    }
                    i = removeFrom;
                }
                --i;
            }
        }
        return scenario;
    }

    private void validateGeneratedScenarios() {
        for (List<Edge> scenario : this.scenarios) {
            if (scenario.get((int)0).source != this.graph.initial) {
                throw new RuntimeException("Corrupt scenario detected");
            }
            int i = 1;
            while (i < scenario.size()) {
                if (scenario.get((int)(i - 1)).target != scenario.get((int)i).source) {
                    throw new RuntimeException("Corrupt scenario detected");
                }
                ++i;
            }
        }
    }

    private void walkRecursive(ReachabilityGraph graph) {
        ArrayList<List<Edge>> queue = new ArrayList<List<Edge>>();
        HashSet<Edge> visitedEdges = new HashSet<Edge>();
        queue.add(new ArrayList());
        while (!queue.isEmpty()) {
            int scenarioIndex = queue.size() - 1;
            while (scenarioIndex >= 0) {
                List<Edge> scenario = (List<Edge>)queue.get(scenarioIndex);
                ArrayList<Edge> scenarioStart = new ArrayList<Edge>(scenario);
                Node node = scenarioStart.size() == 0 ? graph.initial : ((Edge)scenarioStart.get((int)(scenarioStart.size() - 1))).target;
                boolean scenarioComplete = true;
                for (Edge edge1 : this.sourceEdgeLookup.get(node)) {
                    if (edge1.target.trigger != null) {
                        for (Edge edge2 : this.sourceEdgeLookup.get(edge1.target)) {
                            if (visitedEdges.contains(edge2)) continue;
                            visitedEdges.add(edge2);
                            scenario = this.forkScenarioIfNecessary(queue, scenarioStart, scenario, edge1);
                            scenario.add(edge1);
                            scenario.add(edge2);
                            scenarioComplete = false;
                        }
                        continue;
                    }
                    if (visitedEdges.contains(edge1)) continue;
                    visitedEdges.add(edge1);
                    scenario = this.forkScenarioIfNecessary(queue, scenarioStart, scenario, edge1);
                    scenario.add(edge1);
                    scenarioComplete = false;
                }
                if (scenarioComplete) {
                    queue.remove(scenarioIndex);
                    this.scenarios.add(scenario);
                }
                --scenarioIndex;
            }
        }
    }

    public List<List<Object>> getScenariosEntries() {
        ArrayList<List<Object>> scenariosEntries = new ArrayList<List<Object>>();
        for (List<Edge> scenario : this.scenarios) {
            ArrayList<EAction> scenarioEntries = new ArrayList<EAction>();
            Iterator<Edge> iterator = scenario.iterator();
            while (iterator.hasNext()) {
                Edge nodeOrEdge;
                Edge edge = nodeOrEdge = iterator.next();
                scenarioEntries.addAll(edge.entries);
            }
            scenariosEntries.add(scenarioEntries);
        }
        return scenariosEntries;
    }

    private static String variableToString(EVariable variable) {
        if (variable.type == EVariableType.ANY) {
            return "*";
        }
        if (variable.value == null) {
            return "null";
        }
        if (variable.type == EVariableType.VECTOR) {
            String value = variable.getValueVector().stream().map(v -> DeterministicScenarios.variableToString(v)).collect(Collectors.joining("_"));
            return String.format("[%s]", value);
        }
        if (variable.type == EVariableType.RECORD) {
            String value = variable.getValueRecord().entrySet().stream().map(e -> String.format("%s_%s", e.getKey(), DeterministicScenarios.variableToString((EVariable)e.getValue()))).collect(Collectors.joining("_"));
            return String.format("{%s}", value);
        }
        if (variable.type == EVariableType.MAP) {
            String value = variable.getValueMap().entrySet().stream().map(e -> String.format("%s_%s", DeterministicScenarios.variableToString((EVariable)e.getKey()), DeterministicScenarios.variableToString((EVariable)e.getValue()))).collect(Collectors.joining("_"));
            return String.format("{%s}", value);
        }
        return variable.value.toString();
    }

    private static String argumentsToString(List<EArgument> arguments, String mask) {
        return arguments.stream().map(a -> a.direction.equals(mask) ? "_" : DeterministicScenarios.variableToString((EVariable)a)).collect(Collectors.joining(", "));
    }

    public String toJSON(boolean pretty) {
        return GsonHelper.toJSON(this, pretty);
    }

    public String debugText() {
        LinkedHashMap nodeCount = new LinkedHashMap();
        this.graph.nodes.values().forEach(n -> {
            Integer n2 = nodeCount.put(n, 0);
        });
        this.scenarios.forEach(s -> {
            nodeCount.put(((Edge)s.get((int)0)).source, (Integer)nodeCount.get(((Edge)s.get((int)0)).source) + 1);
            s.forEach(e -> {
                Integer n = nodeCount.put(e.target, (Integer)nodeCount.get(e.target) + 1);
            });
        });
        this.scenarios.forEach(s -> {
            Edge last = (Edge)s.get(s.size() - 1);
            s.stream().forEach(e -> {
                nodeCount.put(e.source, (Integer)nodeCount.get(e.source) + 1);
                if (e == last) {
                    nodeCount.put(e.target, (Integer)nodeCount.get(e.target) + 1);
                }
            });
        });
        LinkedHashMap edgeCount = new LinkedHashMap();
        this.graph.edges.forEach(e -> {
            Integer n = edgeCount.put(e, 0);
        });
        this.scenarios.forEach(s -> s.stream().filter(e -> e instanceof Edge).forEach(e -> {
            Integer n = edgeCount.put(e, (Integer)edgeCount.get(e) + 1);
        }));
        String result = "Depth: " + this.graph.depth + " (max depth: " + this.graph.maxDepth + ")\n" + "Scenarios: " + this.scenarios.size() + "\n" + "Transitions: " + this.scenarios.stream().map(s -> s.stream().filter(e -> e instanceof Edge).collect(Collectors.toList()).size()).reduce(0, Integer::sum) + "\n" + "Nodes hit: " + (float)nodeCount.values().stream().filter(v -> v != 0).collect(Collectors.toList()).size() / (float)nodeCount.values().size() * 100.0f + "%" + "\n" + "Edges hit: " + (float)edgeCount.values().stream().filter(v -> v != 0).collect(Collectors.toList()).size() / (float)edgeCount.values().size() * 100.0f + "%" + "\n" + "\n";
        result = String.valueOf(result) + "Nodes\n";
        ArrayList nodeCountSorted = new ArrayList(nodeCount.entrySet());
        nodeCountSorted.sort(Map.Entry.comparingByValue().reversed());
        for (Map.Entry entry : nodeCountSorted) {
            result = String.valueOf(result) + entry.getValue() + " ".repeat(4 - ((Integer)entry.getValue()).toString().length()) + ": " + ((Node)entry.getKey()).name + "\n";
        }
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "Edges\n";
        ArrayList arrayList = new ArrayList(edgeCount.entrySet());
        arrayList.sort(Map.Entry.comparingByValue().reversed());
        for (Map.Entry entry : arrayList) {
            result = String.valueOf(result) + entry.getValue() + " ".repeat(4 - ((Integer)entry.getValue()).toString().length()) + ": " + ((Edge)entry.getKey()).source.name + " to " + ((Edge)entry.getKey()).target.name + "\n";
        }
        result = String.valueOf(result) + "\n\nLegend: C = Command, R = CommandReply, N = Notification, S = Signal\n";
        result = String.valueOf(result) + "Not applicable arguments are masked with '_ , e.g. for a Command all out parameters will be masked with '_'\n";
        result = String.valueOf(result) + "In case scenarios are generated for component all actions are in the form of PORT.CONNECTION.ACTION (e.g. myPort.myConnection.myMethod())\n";
        for (List list : this.scenarios) {
            result = String.valueOf(result) + String.format("\nScenario %d:\n", this.scenarios.indexOf(list) + 1);
            for (Edge edge : list) {
                for (EAction action : edge.entries) {
                    ECommand a;
                    String prefix = "";
                    if (action.connection != null) {
                        prefix = String.valueOf(action.connection.port) + "." + action.connection.id + ".";
                    }
                    if (action instanceof ECommand) {
                        a = (ECommand)action;
                        result = String.valueOf(result) + String.format("C: %s%s(%s)\n", prefix, a.method, DeterministicScenarios.argumentsToString(a.arguments, "out"));
                        continue;
                    }
                    if (action instanceof EReply) {
                        a = (EReply)action;
                        String returnValue = a.returnValue != null ? DeterministicScenarios.variableToString(a.returnValue) : "void";
                        result = String.valueOf(result) + String.format("R: %s%s(%s) -> %s\n", prefix, a.method, DeterministicScenarios.argumentsToString(a.arguments, "in"), returnValue);
                        continue;
                    }
                    if (action instanceof ENotification) {
                        a = (ENotification)action;
                        result = String.valueOf(result) + String.format("N: %s%s(%s)\n", prefix, a.method, DeterministicScenarios.argumentsToString(a.arguments, ""));
                        continue;
                    }
                    if (action instanceof ESignal) {
                        a = (ESignal)action;
                        result = String.valueOf(result) + String.format("S: %s%s(%s)\n", prefix, a.method, DeterministicScenarios.argumentsToString(a.arguments, ""));
                        continue;
                    }
                    throw new RuntimeException("Not supported");
                }
            }
        }
        return result.strip();
    }
}

