/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.reachabilitygraph;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.parameters.parameters.Params;
import org.eclipse.comma.parameters.parameters.StateParams;
import org.eclipse.comma.parameters.parameters.TriggerParams;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;

class InputParameters {
    final LinkedHashMap<String, List<EVariableCollection>> lookup = new LinkedHashMap();

    InputParameters(List<Parameters> parametersInputSpecifications) {
        for (Parameters parametersInputSpecification : parametersInputSpecifications) {
            EVariableCollection variables = new EVariableCollection();
            String itf = parametersInputSpecification.getInterface().getName();
            if (parametersInputSpecification == null) continue;
            for (Variable var : parametersInputSpecification.getVars()) {
                variables.add(var.getName(), null);
            }
            for (Action action : parametersInputSpecification.getInitActions()) {
                if (action instanceof AssignmentAction) {
                    variables.put(((AssignmentAction)action).getAssignment().getName(), EVariable.fromExpression((Expression)((AssignmentAction)action).getExp(), null));
                    continue;
                }
                throw new RuntimeException("Not supported");
            }
            for (TriggerParams triggerParams : parametersInputSpecification.getTriggerParams()) {
                String trigger = triggerParams.getEvent().getName();
                List inParameterNames = triggerParams.getEvent().getParameters().stream().filter(p -> p.getDirection() == DIRECTION.IN || p.getDirection() == DIRECTION.INOUT).map(p -> p.getName()).collect(Collectors.toList());
                for (StateParams entry : triggerParams.getStateParams()) {
                    String state = entry.getState().getName();
                    String key = String.valueOf(itf) + "_" + trigger + "_" + state;
                    this.lookup.put(key, new ArrayList());
                    for (Params params : entry.getParams()) {
                        EVariableCollection parameters = new EVariableCollection();
                        for (Expression param : params.getValue()) {
                            parameters.add((String)inParameterNames.get(params.getValue().indexOf((Object)param)), EVariable.fromExpression((Expression)param, (EVariableCollection)variables));
                        }
                        this.lookup.get(key).add(parameters);
                    }
                }
            }
        }
    }

    List<EVariableCollection> getParametersSet(String itf, String trigger, String state) {
        String key = String.valueOf(itf) + "_" + trigger + "_" + state;
        return this.lookup.get(key);
    }

    boolean hasParametersSet(String itf, String trigger, String state) {
        String key = String.valueOf(itf) + "_" + trigger + "_" + state;
        return this.lookup.containsKey(key);
    }
}

