/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.comma.project.project.CompoundInterface;
import org.eclipse.comma.project.project.CompoundInterfaceBlock;
import org.eclipse.comma.project.project.DocumentationGenerationBlock;
import org.eclipse.comma.project.project.DocumentationGenerationTask;
import org.eclipse.comma.project.project.FilePath;
import org.eclipse.comma.project.project.GeneratorBlock;
import org.eclipse.comma.project.project.MonitoringBlock;
import org.eclipse.comma.project.project.MonitoringTask;
import org.eclipse.comma.project.project.Project;
import org.eclipse.comma.project.project.ReachabilityGraphGenerationBlock;
import org.eclipse.comma.project.project.ReachabilityGraphGenerationTask;
import org.eclipse.comma.project.project.TestGenerationBlock;
import org.eclipse.comma.project.project.TestGenerationTask;
import org.eclipse.comma.project.project.TypeMappings;
import org.eclipse.comma.project.project.TypeMappingsBlock;
import org.eclipse.comma.project.project.UMLBlock;
import org.eclipse.comma.project.project.UMLTask;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;

public class ProjectUtility {
    public static List<TypeMappings> getTypeMappings(Project prj) {
        List<TypeMappings> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof TypeMappingsBlock)) continue;
            return ((TypeMappingsBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<MonitoringTask> getMonitorTasks(Project prj) {
        List<MonitoringTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof MonitoringBlock)) continue;
            return ((MonitoringBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<CompoundInterface> getCompoundInterfaces(Project prj) {
        List<CompoundInterface> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof CompoundInterfaceBlock)) continue;
            return ((CompoundInterfaceBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<DocumentationGenerationTask> getDocumentationTasks(Project prj) {
        List<DocumentationGenerationTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof DocumentationGenerationBlock)) continue;
            return ((DocumentationGenerationBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<UMLTask> getUMLTasks(Project prj) {
        List<UMLTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof UMLBlock)) continue;
            return ((UMLBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<ReachabilityGraphGenerationTask> getReachabilityGraphGeneratorTasks(Project prj) {
        List<ReachabilityGraphGenerationTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof ReachabilityGraphGenerationBlock)) continue;
            return ((ReachabilityGraphGenerationBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<TestGenerationTask> getTestGeneratorTasks(Project prj) {
        List<TestGenerationTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof TestGenerationBlock)) continue;
            return ((TestGenerationBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static URI resolveUri(Resource context, String path) {
        URI contextURI = context.getURI();
        URI uri = URI.createFileURI((String)path);
        if (contextURI.isHierarchical() && !contextURI.isRelative() && uri.isRelative() && !uri.isEmpty()) {
            uri = uri.resolve(contextURI);
        }
        return uri;
    }

    public static TraceResources getTraceResourcesFromDirs(List<FilePath> directories) {
        TraceResources _xblockexpression = null;
        TraceResources result = new TraceResources();
        HashSet<String> fileNames = new HashSet<String>();
        HashSet<String> directoryNames = new HashSet<String>();
        for (FilePath location : directories) {
            URI uri = ProjectUtility.resolveUri(location.eResource(), location.getPath());
            boolean uriOk = true;
            File dir = null;
            boolean _isPlatform = uri.isPlatform();
            if (_isPlatform) {
                String platform = uri.toPlatformString(true);
                IResource eclipseResource = ResourcesPlugin.getWorkspace().getRoot().findMember(platform);
                if (eclipseResource != null) {
                    File _file;
                    uri = URI.createFileURI((String)eclipseResource.getRawLocation().toOSString());
                    String _fileString = uri.toFileString();
                    dir = _file = new File(_fileString);
                } else {
                    uriOk = false;
                }
            } else {
                File _file_1;
                String _fileString_1 = uri.toFileString();
                dir = _file_1 = new File(_fileString_1);
            }
            FilenameFilter traceFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".traces") || name.endsWith(".events");
                }
            };
            if (uriOk && dir.exists() && dir.isDirectory()) {
                File[] _listFiles;
                boolean _not;
                boolean _add = directoryNames.add(dir.toString());
                boolean bl = _not = !_add;
                if (_not) {
                    result.duplicateDirectories.add(location);
                    continue;
                }
                File[] fileArray = _listFiles = dir.listFiles(traceFilter);
                int n = _listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    URI fileUri = URI.createFileURI((String)file.getPath()).resolve(location.eResource().getURI());
                    boolean _isValidUri = EcoreUtil2.isValidUri((Resource)location.eResource(), (URI)fileUri);
                    if (_isValidUri) {
                        boolean _not_1;
                        String fileName = fileUri.trimFileExtension().lastSegment();
                        boolean _isValidFileName = ProjectUtility.isValidFileName(fileName);
                        boolean bl2 = _not_1 = !_isValidFileName;
                        if (_not_1) {
                            result.wrongnamedTraceFiles.add(fileUri.toString());
                        } else {
                            boolean _not_2;
                            boolean _add_1 = fileNames.add(fileName);
                            boolean bl3 = _not_2 = !_add_1;
                            if (_not_2) {
                                result.duplicateTraceFiles.add(fileUri.toString());
                            } else {
                                result.validURIs.add(fileUri);
                            }
                        }
                    }
                    ++n2;
                }
                continue;
            }
            result.nonexistentDirectories.add(location);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static TraceResources getTraceResourcesFromFiles(List<FilePath> traceSources) {
        TraceResources _xblockexpression = null;
        TraceResources result = new TraceResources();
        HashSet<String> names = new HashSet<String>();
        for (FilePath traceSource : traceSources) {
            boolean _not_3;
            boolean _not_2;
            boolean _not_1;
            boolean _not;
            String path = traceSource.getPath();
            URI uri = URI.createURI((String)path).resolve(traceSource.eResource().getURI());
            boolean _isValidUri = EcoreUtil2.isValidUri((Resource)traceSource.eResource(), (URI)uri);
            boolean bl = _not = !_isValidUri;
            if (_not) {
                result.invalidTraceSources.add(traceSource);
                continue;
            }
            String fileExtension = uri.fileExtension();
            boolean bl2 = _not_1 = !fileExtension.equals("traces") && !fileExtension.equals("events");
            if (_not_1) {
                result.invalidTraceSources.add(traceSource);
                continue;
            }
            String fileName = uri.trimFileExtension().lastSegment();
            boolean _isValidFileName = ProjectUtility.isValidFileName(fileName);
            boolean bl3 = _not_2 = !_isValidFileName;
            if (_not_2) {
                result.wrongnamedTraceSources.add(traceSource);
                continue;
            }
            boolean _add = names.add(fileName);
            boolean bl4 = _not_3 = !_add;
            if (_not_3) {
                result.duplicateTraceSources.add(traceSource);
                continue;
            }
            result.validURIs.add(uri);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static boolean isValidFileName(String fileName) {
        return Pattern.matches("[a-zA-Z][a-zA-Z0-9_]*", fileName);
    }

    public static class TraceResources {
        public List<FilePath> invalidTraceSources;
        public List<FilePath> wrongnamedTraceSources;
        public List<FilePath> duplicateTraceSources;
        public List<FilePath> nonexistentDirectories;
        public List<FilePath> duplicateDirectories;
        public List<String> wrongnamedTraceFiles;
        public List<String> duplicateTraceFiles;
        public List<String> invalidTraceFiles;
        public List<URI> validURIs;

        public TraceResources() {
            ArrayList<FilePath> _arrayList = new ArrayList<FilePath>();
            this.invalidTraceSources = _arrayList;
            ArrayList<FilePath> _arrayList_1 = new ArrayList<FilePath>();
            this.wrongnamedTraceSources = _arrayList_1;
            ArrayList<FilePath> _arrayList_2 = new ArrayList<FilePath>();
            this.duplicateTraceSources = _arrayList_2;
            ArrayList<URI> _arrayList_3 = new ArrayList<URI>();
            this.validURIs = _arrayList_3;
            ArrayList<String> _arrayList_4 = new ArrayList<String>();
            this.wrongnamedTraceFiles = _arrayList_4;
            ArrayList<String> _arrayList_5 = new ArrayList<String>();
            this.duplicateTraceFiles = _arrayList_5;
            ArrayList<String> _arrayList_6 = new ArrayList<String>();
            this.invalidTraceFiles = _arrayList_6;
            ArrayList<FilePath> _arrayList_7 = new ArrayList<FilePath>();
            this.nonexistentDirectories = _arrayList_7;
            ArrayList<FilePath> _arrayList_8 = new ArrayList<FilePath>();
            this.duplicateDirectories = _arrayList_8;
        }
    }
}

