/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.ui.handler;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.comma.project.ui.handler.ProjectUIGeneratorJob;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.util.ResourceUtil;
import org.eclipse.xtext.validation.IResourceValidator;

public class GenerationHandler
extends AbstractHandler {
    private static final String FILE_EXT = "prj";
    @Inject
    private IGenerator2 generator;
    @Inject
    private Provider<EclipseResourceFileSystemAccess2> fileAccessProvider;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    private EclipseOutputConfigurationProvider outputConfigurationProvider;
    @Inject
    private IResourceValidator validator;

    @Inject
    public void setOutputConfigurationProvider(EclipseOutputConfigurationProvider outputConfigurationProvider) {
        this.outputConfigurationProvider = outputConfigurationProvider;
    }

    protected Set<IContainer> getOutputs(IProject project, OutputConfiguration outputConfiguration) {
        LinkedHashSet outputs = Sets.newLinkedHashSet();
        for (String outputPath : outputConfiguration.getOutputDirectories()) {
            IContainer output = ResourceUtil.getContainer((IProject)project, (String)outputPath);
            outputs.add(output);
        }
        return outputs;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object firstElement;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IFile file = null;
        if (selection instanceof TextSelection) {
            IFile tFile;
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (editor.getEditorInput() instanceof FileEditorInput && (tFile = ((FileEditorInput)editor.getEditorInput()).getFile()).getFileExtension().equals(FILE_EXT)) {
                file = tFile;
            }
        } else if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            file = (IFile)firstElement;
        }
        if (file != null) {
            ProjectUIGeneratorJob job = new ProjectUIGeneratorJob(file, this.generator, (EclipseResourceFileSystemAccess2)this.fileAccessProvider.get(), this.resourceSetProvider, this.outputConfigurationProvider, this.validator, activeShell);
            job.schedule();
        }
        return null;
    }
}

