/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.list.primitive.ShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseShortIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableShortSingletonList
implements ImmutableShortList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final short element1;

    ImmutableShortSingletonList(short element) {
        this.element1 = element;
    }

    public short get(int index) {
        if (index == 0) {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
    }

    public short getFirst() {
        return this.element1;
    }

    public short getLast() {
        return this.element1;
    }

    public int indexOf(short value) {
        return this.element1 == value ? 0 : -1;
    }

    public int lastIndexOf(short value) {
        return this.element1 == value ? 0 : -1;
    }

    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator((ShortIterator)ShortArrayList.newListWith(this.element1).shortIterator());
    }

    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        procedure.value(this.element1);
    }

    public void forEachWithIndex(ShortIntProcedure procedure) {
        procedure.value(this.element1, 0);
    }

    public int count(ShortPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public ImmutableShortList select(ShortPredicate predicate) {
        return predicate.accept(this.element1) ? ShortArrayList.newListWith(this.element1).toImmutable() : new ShortArrayList().toImmutable();
    }

    public ImmutableShortList reject(ShortPredicate predicate) {
        return predicate.accept(this.element1) ? new ShortArrayList().toImmutable() : ShortArrayList.newListWith(this.element1).toImmutable();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableList<V> collect(ShortToObjectFunction<? extends V> function) {
        return FastList.newListWith(function.valueOf(this.element1)).toImmutable();
    }

    public long sum() {
        return this.element1;
    }

    public short max() {
        return this.element1;
    }

    public short maxIfEmpty(short defaultValue) {
        return this.element1;
    }

    public short min() {
        return this.element1;
    }

    public short minIfEmpty(short defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public short[] toSortedArray() {
        return new short[]{this.element1};
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newListWith(this.element1);
    }

    public int binarySearch(short value) {
        if (this.element1 == value) {
            return 0;
        }
        if (this.element1 < value) {
            return -2;
        }
        return -1;
    }

    public long dotProduct(ShortList list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return (long)this.element1 * (long)list.getFirst();
    }

    public short[] toArray() {
        return new short[]{this.element1};
    }

    public boolean contains(short value) {
        return this.element1 == value;
    }

    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public LazyShortIterable asReversed() {
        return ReverseShortIterable.adapt((ShortList)this);
    }

    public MutableShortList toList() {
        return ShortArrayList.newListWith(this.element1);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSetWith(this.element1);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBagWith(this.element1);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public ImmutableShortList toImmutable() {
        return this;
    }

    public ImmutableShortSingletonList toReversed() {
        return this;
    }

    public ImmutableShortList newWith(short element) {
        return ShortLists.immutable.with(new short[]{this.element1, element});
    }

    public ImmutableShortList newWithout(short element) {
        return this.element1 == element ? ShortLists.immutable.with() : this;
    }

    public ImmutableShortList newWithAll(ShortIterable elements) {
        ShortArrayList arrayList = ShortArrayList.newListWith(this.element1);
        arrayList.addAll(elements);
        return arrayList.toImmutable();
    }

    public ImmutableShortList newWithoutAll(ShortIterable elements) {
        return elements.contains(this.element1) ? ShortLists.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectShortIntToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1, 0);
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof ShortList)) {
            return false;
        }
        ShortList list = (ShortList)otherList;
        if (list.size() != 1) {
            return false;
        }
        return this.element1 == list.get(0);
    }

    public int hashCode() {
        return 31 + this.element1;
    }

    public String toString() {
        return "[" + this.element1 + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImmutableShortList distinct() {
        return this;
    }

    public ImmutableShortList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}

