/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.MARTE.MARTE_Foundations.Alloc.Assign;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.polarsys.chess.chessmlprofile.ComponentModel.ComponentImplementation;
import org.polarsys.chess.chessmlprofile.Core.CHESS;
import org.polarsys.chess.chessmlprofile.Core.CHESSViews.DeploymentView;
import org.polarsys.chess.chessmlprofile.Core.CHGaResourcePlatform;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Propagation;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import org.polarsys.chess.commands.AssignCopy;
import org.polarsys.chess.core.profiles.CHESSProfileManager;
import org.polarsys.chess.core.util.uml.ResourceUtils;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.service.utils.CHESSEditorUtils;

public class BuildModelInstanceCommand
extends AbstractHandler
implements IHandler {
    private static final String CHESS = "CHESS::Core::CHESS";
    private static final String CHESS_CHRTSPEC = "CHESS::Predictability::RTComponentModel::CHRtSpecification";
    private static final String CHESS_RESPLATFORM = "CHESS::Core::CHGaResourcePlatform";
    private static final String MARTE_CSP = "MARTE::MARTE_DesignModel::GCM::ClientServerPort";
    private static final String MARTE_RESOURCE = "MARTE::MARTE_Foundations::GRM::Resource";
    private static final String MARTE_ASSIGN = "MARTE::MARTE_Foundations::Alloc::Assign";
    private static ArrayList<AssignCopy> acList;
    private static EList<Comment> assigns;
    private static ArrayList<InstanceSpecification> instancesList;
    private static ArrayList<Slot> slotList;

    static {
        instancesList = new ArrayList();
        slotList = new ArrayList();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        final Shell shell = window.getShell();
        PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
        final DiagramStatus ds = CHESSEditorUtils.getDiagramStatus((PapyrusMultiDiagramEditor)editor);
        ArrayList<Component> compImplList = new ArrayList<Component>();
        try {
            Resource res = ResourceUtils.getUMLResource((ServicesRegistry)editor.getServicesRegistry());
            final Model umlModel = ResourceUtils.getModel((Resource)res);
            CHESS chess = (CHESS)umlModel.getStereotypeApplication(umlModel.getAppliedStereotype(CHESS));
            for (Element elem : chess.getComponentView().getBase_Package().allOwnedElements()) {
                if (UMLUtils.getStereotypeApplication((Element)elem, ComponentImplementation.class) == null) continue;
                compImplList.add((Component)elem);
            }
            for (Element elem : chess.getDeploymentView().getBase_Package().allOwnedElements()) {
                if (!(elem instanceof Component)) continue;
                compImplList.add((Component)elem);
            }
            ListDialog selectionDialog = new ListDialog(shell);
            selectionDialog.setInput(compImplList);
            selectionDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            selectionDialog.setLabelProvider((ILabelProvider)new UMLLabelProvider());
            selectionDialog.setTitle("Select the Component for Build Instances");
            Object[] selection = null;
            if (selectionDialog.open() == 0) {
                selection = selectionDialog.getResult();
            }
            if (selection != null && selection.length > 0) {
                Object obj = selection[0];
                final Component comp = (Component)obj;
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)comp);
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        ds.setUserAction(false);
                        BuildModelInstanceCommand.saveAssignAllocations(umlModel);
                        Package instPkg = null;
                        for (Element elem : comp.getOwner().getOwnedElements()) {
                            if (!(elem instanceof Package) || !((Package)elem).getName().equals(String.valueOf(comp.getName()) + "_instSpec")) continue;
                            instPkg = (Package)elem;
                        }
                        if (instPkg != null) {
                            EList elems = instPkg.getPackagedElements();
                            int size = elems.size();
                            int i = 0;
                            while (i < size) {
                                PackageableElement pe = (PackageableElement)elems.get(0);
                                pe.destroy();
                                ++i;
                            }
                        } else {
                            Package pkg = comp.getNearestPackage();
                            instPkg = pkg.createNestedPackage(String.valueOf(comp.getName()) + "_instSpec");
                            UMLUtils.applyStereotype((Element)instPkg, (String)BuildModelInstanceCommand.CHESS_RESPLATFORM);
                        }
                        instancesList.clear();
                        slotList.clear();
                        BuildModelInstanceCommand.this.buildComponentInstance(instPkg, comp, null, null, null, new HashMap(), (List)comp.getOwnedComments());
                        BuildModelInstanceCommand.regenerateAssignAllocations(umlModel);
                        MessageDialog.openInformation((Shell)shell, (String)"CHESS", (String)"BuildInstance command completed");
                    }
                });
            }
        }
        catch (Exception e) {
            ds.setUserAction(false);
            e.printStackTrace();
            MessageDialog.openError((Shell)shell, (String)"CHESS", (String)("Problems while executing BuildInstance command: " + e.getMessage()));
        }
        ds.setUserAction(false);
        return null;
    }

    private InstanceSpecification buildComponentInstance(Package pkg, Component comp, CHGaResourcePlatform resPlatform, InstanceSpecification parentInstance, Property theProp, Map<Property, InstanceSpecification> property2InstMap, List<Comment> commList) {
        InstanceSpecification inst = UMLFactory.eINSTANCE.createInstanceSpecification();
        if (theProp != null) {
            String name = String.valueOf(parentInstance.getName()) + "." + theProp.getName();
            inst.setName(name);
        } else {
            inst.setName(comp.getName());
        }
        inst.getClassifiers().add((Object)comp);
        pkg.getPackagedElements().add((Object)inst);
        if (parentInstance != null) {
            UMLUtils.applyStereotype((Element)inst, (String)MARTE_RESOURCE);
            org.eclipse.papyrus.MARTE.MARTE_Foundations.GRM.Resource res = (org.eclipse.papyrus.MARTE.MARTE_Foundations.GRM.Resource)inst.getStereotypeApplication(inst.getAppliedStereotype(MARTE_RESOURCE));
            resPlatform.getResources().add((Object)res);
        } else {
            Stereotype stereo = UMLUtils.applyStereotype((Element)inst, (String)CHESS_RESPLATFORM);
            resPlatform = (CHGaResourcePlatform)inst.getStereotypeApplication(stereo);
        }
        if (theProp != null) {
            BuildModelInstanceCommand.mapStereotypesFromPropertyToInstance(theProp, inst);
        }
        for (Property subProp : comp.getAttributes()) {
            if (subProp.getType() instanceof Component) {
                Component subCompImpl = (Component)subProp.getType();
                commList.addAll((Collection<Comment>)subCompImpl.getOwnedComments());
                InstanceSpecification subInst = this.buildComponentInstance(pkg, subCompImpl, resPlatform, inst, subProp, property2InstMap, commList);
                Slot slot = UMLFactory.eINSTANCE.createSlot();
                slot.setDefiningFeature((StructuralFeature)subProp);
                inst.getSlots().add((Object)slot);
                InstanceValue instValue = (InstanceValue)slot.createValue(subProp.getName(), null, UMLPackage.Literals.INSTANCE_VALUE);
                instValue.setInstance(subInst);
            }
            if (subProp.getAppliedStereotype(MARTE_CSP) == null) continue;
            Slot slot = UMLFactory.eINSTANCE.createSlot();
            slot.setDefiningFeature((StructuralFeature)subProp);
            inst.getSlots().add((Object)slot);
            slotList.add(slot);
            ArrayList<CHRtSpecification> tmpList = new ArrayList<CHRtSpecification>();
            for (Comment comm : commList) {
                if (comm.getAppliedStereotype(CHESS_CHRTSPEC) == null || !comm.getAnnotatedElements().contains((Object)subProp)) continue;
                Stereotype chrtStereo = comm.getAppliedStereotype(CHESS_CHRTSPEC);
                CHRtSpecification chrt = (CHRtSpecification)comm.getStereotypeApplication(chrtStereo);
                tmpList.add(chrt);
            }
            if (tmpList.size() <= 0) continue;
            Stereotype portSlotStereo = CHESSProfileManager.applyChRTPortSlotStereotype((Slot)slot);
            CHRtPortSlot portSlot = (CHRtPortSlot)slot.getStereotypeApplication(portSlotStereo);
            portSlot.getCH_RtSpecification().addAll(tmpList);
        }
        for (Connector conn : comp.getOwnedConnectors()) {
            this.buildConnectorInstance(pkg, conn, resPlatform, inst, property2InstMap);
        }
        instancesList.add(inst);
        if (theProp != null) {
            property2InstMap.put(theProp, inst);
        }
        return inst;
    }

    public static void mapStereotypesFromPropertyToInstance(Property property, InstanceSpecification instance) {
        Stereotype chHwComputingRes;
        Type type = property.getType();
        EObject stereo = property.getStereotypeApplication(CHESSProfileManager.getCH_HWBus((Element)property));
        Property elem = property;
        if (stereo == null) {
            stereo = type.getStereotypeApplication(CHESSProfileManager.getCH_HWBus((Element)type));
            elem = type;
        }
        if (stereo != null) {
            Stereotype chHwBus = CHESSProfileManager.applyCH_HwBusStereotype((Element)instance);
            instance.setValue(chHwBus, "transmMode", elem.getValue(chHwBus, "transmMode"));
            instance.setValue(chHwBus, "blockT", elem.getValue(chHwBus, "blockT"));
            instance.setValue(chHwBus, "packetT", elem.getValue(chHwBus, "packetT"));
            instance.setValue(chHwBus, "speedFactor", elem.getValue(chHwBus, "speedFactor"));
            instance.setValue(chHwBus, "resMult", elem.getValue(chHwBus, "resMult"));
        }
        stereo = property.getStereotypeApplication(CHESSProfileManager.getCH_HWComputingResource((Element)property));
        elem = property;
        if (stereo == null) {
            stereo = type.getStereotypeApplication(CHESSProfileManager.getCH_HWComputingResource((Element)type));
            elem = type;
        }
        if (stereo != null) {
            chHwComputingRes = CHESSProfileManager.applyCH_HwComputingResourceStereotype((Element)instance);
            instance.setValue(chHwComputingRes, "speedFactor", elem.getValue(chHwComputingRes, "speedFactor"));
            instance.setValue(chHwComputingRes, "resMult", elem.getValue(chHwComputingRes, "resMult"));
        }
        stereo = property.getStereotypeApplication(CHESSProfileManager.getCH_HWProcessor((Element)property));
        elem = property;
        if (stereo == null) {
            stereo = type.getStereotypeApplication(CHESSProfileManager.getCH_HWProcessor((Element)type));
            elem = type;
        }
        if (stereo != null) {
            chHwComputingRes = CHESSProfileManager.applyCH_HwProcessorStereotype((Element)instance);
            instance.setValue(chHwComputingRes, "speedFactor", elem.getValue(chHwComputingRes, "speedFactor"));
            instance.setValue(chHwComputingRes, "resMult", elem.getValue(chHwComputingRes, "resMult"));
        }
    }

    private void buildConnectorInstance(Package pkg, Connector conn, CHGaResourcePlatform resPlatform, InstanceSpecification parentInstance, Map<Property, InstanceSpecification> property2InstMap) {
        InstanceSpecification connInst = UMLFactory.eINSTANCE.createInstanceSpecification();
        String name = String.valueOf(parentInstance.getName()) + "." + conn.getName();
        connInst.setName(name);
        pkg.getPackagedElements().add((Object)connInst);
        UMLUtils.applyStereotype((Element)connInst, (String)MARTE_RESOURCE);
        org.eclipse.papyrus.MARTE.MARTE_Foundations.GRM.Resource res = (org.eclipse.papyrus.MARTE.MARTE_Foundations.GRM.Resource)UMLUtils.getStereotypeApplication((Element)connInst, org.eclipse.papyrus.MARTE.MARTE_Foundations.GRM.Resource.class);
        resPlatform.getResources().add((Object)res);
        Slot sourceSlot = connInst.createSlot();
        Slot targetSlot = connInst.createSlot();
        Port sourcePort = (Port)((ConnectorEnd)conn.getEnds().get(0)).getRole();
        sourceSlot.setDefiningFeature((StructuralFeature)sourcePort);
        InstanceValue value = (InstanceValue)sourceSlot.createValue("partWithPort", null, UMLPackage.Literals.INSTANCE_VALUE);
        Property sourceProperty = ((ConnectorEnd)conn.getEnds().get(0)).getPartWithPort();
        InstanceSpecification sourceInstance = property2InstMap.get(sourceProperty);
        value.setInstance(sourceInstance);
        targetSlot.setDefiningFeature((StructuralFeature)((ConnectorEnd)conn.getEnds().get(1)).getRole());
        value = (InstanceValue)targetSlot.createValue("partWithPort", null, UMLPackage.Literals.INSTANCE_VALUE);
        Property targetProperty = ((ConnectorEnd)conn.getEnds().get(1)).getPartWithPort();
        InstanceSpecification targetInstance = property2InstMap.get(targetProperty);
        value.setInstance(targetInstance);
        Propagation origPropagation = (Propagation)UMLUtils.getStereotypeApplication((Element)conn, Propagation.class);
        if (origPropagation != null) {
            CHESSProfileManager.applyPropagationStereotype((InstanceSpecification)connInst);
            Propagation newPropagation = (Propagation)UMLUtils.getStereotypeApplication((Element)connInst, Propagation.class);
            newPropagation.setProb(origPropagation.getProb());
            newPropagation.setPropDelay(origPropagation.getPropDelay());
            newPropagation.getTransfFunct().addAll((Collection)origPropagation.getTransfFunct());
            newPropagation.setWeight(origPropagation.getWeight());
        }
    }

    private static void saveAssignAllocations(Model umlModel) {
        CHESS chess = (CHESS)UMLUtils.getStereotypeApplication((Element)umlModel, CHESS.class);
        DeploymentView deplView = chess.getDeploymentView();
        EList tmp = deplView.getAssignList();
        assigns = new BasicEList();
        int i = 0;
        while (i < tmp.size()) {
            if (((Comment)tmp.get(i)).getAppliedStereotype(MARTE_ASSIGN) != null) {
                assigns.add((Object)((Comment)tmp.get(i)));
            }
            ++i;
        }
        acList = AssignCopy.toAssignCopyList(assigns);
    }

    private static void regenerateAssignAllocations(Model umlModel) {
        int i = 0;
        while (i < acList.size()) {
            String slotName;
            Slot tmpSlot;
            Iterator<Slot> slotIt;
            InstanceSpecification tmpInst;
            Iterator<InstanceSpecification> instIt;
            Comment com = (Comment)assigns.get(i);
            Assign assign = (Assign)UMLUtils.getStereotypeApplication((Element)com, Assign.class);
            EList from = assign.getFrom();
            EList to = assign.getTo();
            AssignCopy ac = acList.get(i);
            for (String fromName : ac.getFrom()) {
                instIt = instancesList.iterator();
                InstanceSpecification isFrom = null;
                while (instIt.hasNext()) {
                    tmpInst = instIt.next();
                    if (!tmpInst.getName().equals(fromName)) continue;
                    isFrom = tmpInst;
                    break;
                }
                if (isFrom != null && !from.contains(isFrom)) {
                    from.add(isFrom);
                    continue;
                }
                slotIt = slotList.iterator();
                Slot slFrom = null;
                while (slotIt.hasNext()) {
                    tmpSlot = slotIt.next();
                    slotName = String.valueOf(tmpSlot.getOwningInstance().getQualifiedName()) + "::" + tmpSlot.getDefiningFeature().getName();
                    if (!slotName.equals(fromName)) continue;
                    slFrom = tmpSlot;
                    break;
                }
                if (slFrom == null || from.contains(slFrom)) continue;
                from.add(slFrom);
            }
            for (String toName : ac.getTo()) {
                instIt = instancesList.iterator();
                InstanceSpecification isTo = null;
                while (instIt.hasNext()) {
                    tmpInst = instIt.next();
                    if (!tmpInst.getName().equals(toName)) continue;
                    isTo = tmpInst;
                    break;
                }
                if (isTo != null && !to.contains(isTo)) {
                    to.add(isTo);
                    continue;
                }
                slotIt = slotList.iterator();
                Slot slTo = null;
                while (slotIt.hasNext()) {
                    tmpSlot = slotIt.next();
                    slotName = String.valueOf(tmpSlot.getOwningInstance().getQualifiedName()) + "::" + tmpSlot.getDefiningFeature().getName();
                    if (!slotName.equals(toName)) continue;
                    slTo = tmpSlot;
                    break;
                }
                if (slTo == null || to.contains(slTo)) continue;
                to.add(slTo);
            }
            ++i;
        }
    }
}

