/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.managers;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Model;
import org.polarsys.chess.core.constraint.ConstraintList;
import org.polarsys.chess.core.constraint.DynamicConstraint;
import org.polarsys.chess.core.preferences.FilterableConstraint;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.validator.libs.ConstraintsLib;
import org.polarsys.chess.validator.messages.Messages;

public class ModelParser {
    private IStatus modelOutsideView = new Status(4, "org.polarsys.chess.validator", Messages.NullViewMsg);

    public IPreferencePage getId(String id) {
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        List list = pm.getElements(0);
        int i = 0;
        while (i < list.size()) {
            PreferenceNode node = (PreferenceNode)list.get(i);
            IPreferencePage p = node.getPage();
            if (p != null && node.getId().equals(id)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public ModelParser() {
        PlatformUI.getWorkbench().getPreferenceManager();
        new ConstraintsLib();
    }

    public Command check(Notification notification, Object _notifier, DiagramStatus.DesignView currentView, boolean superuser) throws RollbackException {
        Object notifier = notification.getNotifier();
        Command command = null;
        if (currentView == null) {
            if (notifier instanceof Model && notification.getFeature() instanceof EAttribute && ((EAttribute)notification.getFeature()).getName().equals("name")) {
                return command;
            }
            CHESSProjectSupport.printlnToCHESSConsole((String)this.modelOutsideView.getMessage());
            return command;
        }
        if (!superuser && !ConstraintsLib.E_S_1_NEW.check(notification, currentView).isOK()) {
            CHESSProjectSupport.printlnToCHESSConsole((String)ConstraintsLib.E_S_1_NEW.getMessage());
            throw new RollbackException((IStatus)ConstraintsLib.E_S_1_NEW.getStatus());
        }
        for (FilterableConstraint fC : ConstraintList.getList()) {
            DynamicConstraint constr;
            if (!fC.isActive() || (constr = (DynamicConstraint)fC.getConstraint()).check(notification, currentView).isOK()) continue;
            CHESSProjectSupport.printlnToCHESSConsole((String)constr.getMessage());
            throw new RollbackException((IStatus)constr.getStatus());
        }
        return command;
    }
}

