/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.core.internal.application;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.cft.server.standalone.core.internal.application.StandaloneRuntimeResolver;
import org.eclipse.cft.server.standalone.core.internal.startcommand.JavaStartCommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ModuleFolder;
import org.eclipse.wst.server.core.util.ProjectModule;

public class StandaloneModuleDelegate
extends ProjectModule {
    public StandaloneModuleDelegate(IProject project) {
        super(project);
    }

    protected IModuleResource[] collectResources(String localResourceLocation, IPath relativeModuleResourcePath) throws CoreException {
        IProject project = this.getProject();
        if (project.isAccessible()) {
            IPath projectPath = project.getLocation();
            if (projectPath != null && localResourceLocation.equals(projectPath.toOSString())) {
                return this.getModuleResources(relativeModuleResourcePath, (IContainer)project);
            }
            IFile workspaceResource = null;
            Path resourcePath = new Path(localResourceLocation);
            File publishableFile = resourcePath.toFile();
            if (projectPath != null && publishableFile != null && publishableFile.exists()) {
                IPath relativeResourcepath = resourcePath.makeRelativeTo(projectPath);
                if (publishableFile.isFile()) {
                    workspaceResource = project.getFile(relativeResourcepath);
                } else if (publishableFile.isDirectory()) {
                    workspaceResource = project.getFolder(relativeResourcepath);
                }
            } else {
                workspaceResource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)resourcePath);
                if (workspaceResource == null || !workspaceResource.exists()) {
                    workspaceResource = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)resourcePath);
                }
            }
            if (workspaceResource != null && workspaceResource.exists()) {
                if (workspaceResource instanceof IContainer) {
                    return this.getModuleResources(relativeModuleResourcePath, (IContainer)workspaceResource);
                }
                if (workspaceResource instanceof IFile) {
                    return new IModuleResource[]{new ModuleFile(workspaceResource, workspaceResource.getName(), relativeModuleResourcePath)};
                }
            } else if (publishableFile != null && publishableFile.exists() && publishableFile.isFile()) {
                return new IModuleResource[]{new ModuleFile(publishableFile, publishableFile.getName(), relativeModuleResourcePath)};
            }
        }
        return null;
    }

    public IModuleResource[] members() throws CoreException {
        return this.computeRuntimeClasspathMembers();
    }

    protected IModuleResource[] computeRuntimeClasspathMembers() throws CoreException {
        ArrayList<IModuleResource> members = new ArrayList<IModuleResource>();
        IJavaProject javaProject = CloudFoundryProjectUtil.getJavaProject((IProject)this.getProject());
        if (javaProject != null) {
            StandaloneRuntimeResolver resolver = new StandaloneRuntimeResolver(javaProject, true);
            List<String> resolvedSource = resolver.getRuntimeSourceLocations();
            if (resolvedSource != null) {
                for (String path : resolvedSource) {
                    this.addModuleResources(path, members, (IPath)Path.EMPTY);
                }
            }
            if (resolver.hasRuntimeDependencies()) {
                ModuleFolder libFolder = this.createLibFolder(members);
                List<String> dependencies = resolver.getRuntimeDependencyLocations();
                ArrayList<IModuleResource> libMembers = new ArrayList<IModuleResource>();
                for (String path : dependencies) {
                    this.addModuleResources(path, libMembers, JavaStartCommand.DEFAULT_LIB_PATH);
                }
                if (!libMembers.isEmpty()) {
                    libFolder.setMembers(libMembers.toArray(new IModuleResource[0]));
                }
            }
        }
        return members.toArray(new IModuleResource[0]);
    }

    protected ModuleFolder createLibFolder(List<IModuleResource> moduleResources) {
        for (IModuleResource resource : moduleResources) {
            if (!(resource instanceof ModuleFolder) || !JavaStartCommand.DEFAULT_LIB_PATH.equals((Object)resource.getName())) continue;
            return (ModuleFolder)resource;
        }
        ModuleFolder folder = new ModuleFolder(null, "lib", (IPath)Path.EMPTY);
        moduleResources.add((IModuleResource)folder);
        return folder;
    }

    protected void addModuleResources(String resourceLocation, Collection<IModuleResource> members, IPath moduleRelativePath) throws CoreException {
        IModuleResource[] containerResources;
        if (resourceLocation != null && (containerResources = this.collectResources(resourceLocation, moduleRelativePath)) != null) {
            IModuleResource[] iModuleResourceArray = containerResources;
            int n = containerResources.length;
            int n2 = 0;
            while (n2 < n) {
                IModuleResource resource = iModuleResourceArray[n2];
                if (resource != null && !members.contains(resource)) {
                    members.add(resource);
                }
                ++n2;
            }
        }
    }
}

