/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.net.MalformedURLException;
import java.net.URL;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;

public class CloudFoundryClientFactory {
    private static CloudFoundryClientFactory sessionFactory = null;

    public static CloudFoundryClientFactory getDefault() {
        if (sessionFactory == null) {
            sessionFactory = new CloudFoundryClientFactory();
        }
        return sessionFactory;
    }

    public CloudFoundryOperations getCloudFoundryOperations(CloudCredentials credentials, URL url, boolean selfSigned) {
        return this.getCloudFoundryOperations(credentials, url, null, selfSigned);
    }

    public CloudFoundryOperations getCloudFoundryOperations(CloudCredentials credentials, URL url, CloudSpace session, boolean selfSigned) {
        HttpProxyConfiguration proxyConfiguration = CloudFoundryClientFactory.getProxy(url);
        return session != null ? new CloudFoundryClient(credentials, url, session, selfSigned) : new CloudFoundryClient(credentials, url, proxyConfiguration, selfSigned);
    }

    public CloudFoundryOperations getCloudFoundryOperations(CloudCredentials credentials, URL url, String orgName, String spaceName, boolean selfsigned) {
        HttpProxyConfiguration proxyConfiguration = CloudFoundryClientFactory.getProxy(url);
        return new CloudFoundryClient(credentials, url, orgName, spaceName, proxyConfiguration, selfsigned);
    }

    public CloudFoundryOperations getCloudFoundryOperations(String cloudControllerUrl) throws MalformedURLException {
        return this.getCloudFoundryOperations(cloudControllerUrl, false);
    }

    public CloudFoundryOperations getCloudFoundryOperations(String cloudControllerUrl, boolean selfSigned) throws MalformedURLException {
        URL url = new URL(cloudControllerUrl);
        HttpProxyConfiguration proxyConfiguration = CloudFoundryClientFactory.getProxy(url);
        return new CloudFoundryClient(url, proxyConfiguration, selfSigned);
    }

    protected static CloudCredentials getCredentials(String userName, String password) {
        return new CloudCredentials(userName, password);
    }

    protected static String getNormalisedProtocol(String protocol) {
        return protocol.toUpperCase();
    }

    public static HttpProxyConfiguration getProxy(URL url) {
        IProxyData[] existingProxies;
        IProxyService proxyService;
        if (url == null || url.getProtocol() == null) {
            return null;
        }
        CloudFoundryPlugin plugin = CloudFoundryPlugin.getDefault();
        if (plugin != null && (proxyService = plugin.getProxyService()) != null && proxyService.isProxiesEnabled() && (existingProxies = proxyService.getProxyData()) != null) {
            String normalisedURLProtocol = CloudFoundryClientFactory.getNormalisedProtocol(url.getProtocol());
            String[] proxyDataTypes = new String[]{"HTTP", "HTTPS", "SOCKS"};
            String matchedProxyData = null;
            String[] stringArray = proxyDataTypes;
            int n = proxyDataTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String proxyDataType = stringArray[n2];
                String normalised = CloudFoundryClientFactory.getNormalisedProtocol(proxyDataType);
                if (normalised.equals(normalisedURLProtocol)) {
                    matchedProxyData = proxyDataType;
                    break;
                }
                ++n2;
            }
            if (matchedProxyData != null) {
                stringArray = existingProxies;
                n = existingProxies.length;
                n2 = 0;
                while (n2 < n) {
                    String data = stringArray[n2];
                    if (matchedProxyData.equals(data.getType())) {
                        int proxyPort = data.getPort();
                        String proxyHost = data.getHost();
                        String user = data.getUserId();
                        String password = data.getPassword();
                        return proxyHost != null ? new HttpProxyConfiguration(proxyHost, proxyPort, data.isRequiresAuthentication(), user, password) : null;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }
}

