/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.client.BehaviourRequest;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.SubMonitor;

abstract class ApplicationRequest<T>
extends BehaviourRequest<T> {
    public ApplicationRequest(String label, CloudFoundryServerBehaviour behaviour) {
        super(label, behaviour);
    }

    @Override
    protected long waitOnErrorInterval(Throwable exception, SubMonitor monitor) throws CoreException {
        if (CloudErrorUtil.is503Error(exception)) {
            return 2000L;
        }
        return super.waitOnErrorInterval(exception, monitor);
    }

    @Override
    protected long getTotalTimeWait() {
        return 60000L;
    }

    @Override
    protected CoreException getErrorOnLastFailedAttempt(Throwable error) {
        if (CloudErrorUtil.is503Error(error)) {
            return CloudErrorUtil.asCoreException(this.get503Error(error), error, true);
        }
        return super.getErrorOnLastFailedAttempt(error);
    }

    protected abstract String get503Error(Throwable var1);
}

