/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.InstanceState;
import org.cloudfoundry.client.lib.domain.InstanceStats;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ApplicationInstanceRunningTracker {
    public static final long TIMEOUT = 300000L;
    public static final long WAIT_TIME = 1000L;
    private final CloudFoundryServer cloudServer;
    private final String appName;
    private final long timeout;

    public ApplicationInstanceRunningTracker(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        this.cloudServer = cloudServer;
        this.appName = appModule.getDeployedApplicationName();
        this.timeout = 300000L;
    }

    public InstanceState track(IProgressMonitor monitor) throws CoreException {
        InstanceState runState = null;
        long currentTime = System.currentTimeMillis();
        long totalTime = currentTime + this.timeout;
        CloudFoundryApplicationModule appModule = this.cloudServer.getBehaviour().updateCloudModuleWithInstances(this.appName, monitor);
        ApplicationStats stats = this.getStats(monitor);
        this.printlnToConsole(NLS.bind((String)Messages.ApplicationInstanceStartingTracker_STARTING_TRACKING, (Object)this.appName), appModule);
        while (runState != InstanceState.RUNNING && runState != InstanceState.FLAPPING && runState != InstanceState.CRASHED && currentTime < totalTime) {
            appModule = this.cloudServer.getBehaviour().updateCloudModuleWithInstances(this.appName, monitor);
            if (appModule == null || appModule.getApplication() == null) {
                this.printlnToConsole(NLS.bind((String)Messages.ApplicationInstanceStartingTracker_APPLICATION_NOT_EXISTS, (Object)this.appName), appModule);
                return null;
            }
            if (appModule.getApplication().getState() == CloudApplication.AppState.STOPPED) {
                return null;
            }
            if (monitor != null && monitor.isCanceled()) {
                this.printlnToConsole(NLS.bind((String)Messages.ApplicationInstanceStartingTracker_APPLICATION_CHECK_CANCELED, (Object)this.appName), appModule);
                return null;
            }
            runState = ApplicationInstanceRunningTracker.getRunState(stats, appModule.getApplication());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            stats = this.getStats(monitor);
            currentTime = System.currentTimeMillis();
        }
        String runningStateMessage = runState == InstanceState.RUNNING ? NLS.bind((String)Messages.ApplicationInstanceStartingTracker_APPLICATION_IS_RUNNING, (Object)this.appName) : NLS.bind((String)Messages.ApplicationInstanceStartingTracker_APPLICATION_IS_NOT_RUNNING, (Object)this.appName);
        this.printlnToConsole(runningStateMessage, appModule);
        return runState;
    }

    protected void printlnToConsole(String message, CloudFoundryApplicationModule appModule) throws CoreException {
        message = String.valueOf(message) + '\n';
        CloudFoundryPlugin.getCallback().printToConsole(this.cloudServer, appModule, message, false, false);
    }

    protected ApplicationStats getStats(IProgressMonitor monitor) throws CoreException {
        return this.cloudServer.getBehaviour().getApplicationStats(this.appName, monitor);
    }

    public static InstanceState getRunState(ApplicationStats stats, CloudApplication app) {
        InstanceState runState = InstanceState.UNKNOWN;
        if (stats != null && stats.getRecords() != null && !stats.getRecords().isEmpty() && app.getState() != CloudApplication.AppState.STOPPED) {
            return ((InstanceStats)stats.getRecords().get(0)).getState();
        }
        return runState;
    }
}

