/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import org.eclipse.cft.server.ui.internal.ColumnSortListener;
import org.eclipse.cft.server.ui.internal.editor.ServiceViewColumn;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ServiceViewerConfigurator {
    private boolean addAutomaticViewerResizing = false;

    public ServiceViewerConfigurator enableAutomaticViewerResizing() {
        this.addAutomaticViewerResizing = true;
        return this;
    }

    public void configureViewer(final TableViewer tableViewer) {
        ServiceViewColumn[] columns;
        final Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        int columnIndex = 0;
        ServiceViewColumn.ServiceViewColumnDescriptor descriptor = ServiceViewColumn.getServiceViewColumnDescriptor();
        ServiceViewColumn[] serviceViewColumnArray = columns = descriptor != null ? descriptor.getServiceViewColumn() : null;
        if (columns == null) {
            return;
        }
        String[] columnProperties = new String[columns.length];
        TableColumn sortColumn = null;
        ServiceViewColumn[] serviceViewColumnArray2 = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceViewColumn column = serviceViewColumnArray2[n2];
            columnProperties[columnIndex] = column.name();
            TableColumn tableColumn = new TableColumn(table, 0, columnIndex++);
            tableColumn.setData((Object)column);
            tableColumn.setText(column.name());
            tableColumn.setWidth(column.getWidth());
            tableColumn.addSelectionListener((SelectionListener)new ColumnSortListener(tableViewer));
            if (column == ServiceViewColumn.Name) {
                sortColumn = tableColumn;
            }
            ++n2;
        }
        if (this.addAutomaticViewerResizing) {
            table.getParent().addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Composite tableComposite = tableViewer.getTable().getParent();
                    Rectangle tableCompositeArea = tableComposite.getClientArea();
                    int width = tableCompositeArea.width;
                    ServiceViewerConfigurator.this.resizeTableColumns(width, table);
                }
            });
        }
        tableViewer.setColumnProperties(columnProperties);
        if (sortColumn != null) {
            table.setSortColumn(sortColumn);
            table.setSortDirection(128);
        }
    }

    protected void resizeTableColumns(int tableWidth, Table table) {
        TableColumn[] tableColumns = table.getColumns();
        if (tableColumns.length == 0) {
            return;
        }
        int total = 0;
        TableColumn[] tableColumnArray = tableColumns;
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            total += column.getWidth();
            ++n2;
        }
        if (total < tableWidth) {
            TableColumn lastColumn = tableColumns[tableColumns.length - 1];
            int newWidth = tableWidth - total + lastColumn.getWidth();
            lastColumn.setWidth(newWidth);
        }
    }
}

